@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The network group resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2022-04-01-preview, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### NetworkGroupsPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkGroup = new AzureNative.Network.NetworkGroup("networkGroup", new()
 *     {
 *         Description = "A sample group",
 *         NetworkGroupName = "testNetworkGroup",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkGroup(ctx, "networkGroup", &network.NetworkGroupArgs{
 * 			Description:        pulumi.String("A sample group"),
 * 			NetworkGroupName:   pulumi.String("testNetworkGroup"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkGroup;
 * import com.pulumi.azurenative.network.NetworkGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkGroup = new NetworkGroup("networkGroup", NetworkGroupArgs.builder()
 *             .description("A sample group")
 *             .networkGroupName("testNetworkGroup")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkGroup testNetworkGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/networkGroups/{networkGroupName}
 * ```
 * @property description A description of the network group.
 * @property networkGroupName The name of the network group.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 */
public data class NetworkGroupArgs(
    public val description: Output<String>? = null,
    public val networkGroupName: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkGroupArgs =
        com.pulumi.azurenative.network.NetworkGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .networkGroupName(networkGroupName?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkGroupArgs].
 */
@PulumiTagMarker
public class NetworkGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var networkGroupName: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value A description of the network group.
     */
    @JvmName("nhdghrtqlyxivbab")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the network group.
     */
    @JvmName("yftbqqdieuycrgxq")
    public suspend fun networkGroupName(`value`: Output<String>) {
        this.networkGroupName = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("yaqgaxeuevgoyvvs")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bfxwdiffalgrfgsj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A description of the network group.
     */
    @JvmName("crfhtavfxeuucpgt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the network group.
     */
    @JvmName("ggkhwbyrwobjwnon")
    public suspend fun networkGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkGroupName = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("eexflvjrybdxscdg")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gmunoqgmyxjgmmbh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): NetworkGroupArgs = NetworkGroupArgs(
        description = description,
        networkGroupName = networkGroupName,
        networkManagerName = networkManagerName,
        resourceGroupName = resourceGroupName,
    )
}
