@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkManagerArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ConfigurationType
import com.pulumi.azurenative.network.kotlin.inputs.NetworkManagerPropertiesNetworkManagerScopesArgs
import com.pulumi.azurenative.network.kotlin.inputs.NetworkManagerPropertiesNetworkManagerScopesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Managed Network resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Put Network Manager
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkManager = new AzureNative.Network.NetworkManager("networkManager", new()
 *     {
 *         Description = "My Test Network Manager",
 *         NetworkManagerName = "TestNetworkManager",
 *         NetworkManagerScopeAccesses = new[]
 *         {
 *             AzureNative.Network.ConfigurationType.Connectivity,
 *         },
 *         NetworkManagerScopes = new AzureNative.Network.Inputs.NetworkManagerPropertiesNetworkManagerScopesArgs
 *         {
 *             ManagementGroups = new[]
 *             {
 *                 "/providers/Microsoft.Management/managementGroups/sampleMG",
 *             },
 *             Subscriptions = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkManager(ctx, "networkManager", &network.NetworkManagerArgs{
 * 			Description:        pulumi.String("My Test Network Manager"),
 * 			NetworkManagerName: pulumi.String("TestNetworkManager"),
 * 			NetworkManagerScopeAccesses: pulumi.StringArray{
 * 				pulumi.String(network.ConfigurationTypeConnectivity),
 * 			},
 * 			NetworkManagerScopes: &network.NetworkManagerPropertiesNetworkManagerScopesArgs{
 * 				ManagementGroups: pulumi.StringArray{
 * 					pulumi.String("/providers/Microsoft.Management/managementGroups/sampleMG"),
 * 				},
 * 				Subscriptions: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkManager;
 * import com.pulumi.azurenative.network.NetworkManagerArgs;
 * import com.pulumi.azurenative.network.inputs.NetworkManagerPropertiesNetworkManagerScopesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkManager = new NetworkManager("networkManager", NetworkManagerArgs.builder()
 *             .description("My Test Network Manager")
 *             .networkManagerName("TestNetworkManager")
 *             .networkManagerScopeAccesses("Connectivity")
 *             .networkManagerScopes(NetworkManagerPropertiesNetworkManagerScopesArgs.builder()
 *                 .managementGroups("/providers/Microsoft.Management/managementGroups/sampleMG")
 *                 .subscriptions("/subscriptions/00000000-0000-0000-0000-000000000000")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkManager TestNetworkManager /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}
 * ```
 * @property description A description of the network manager.
 * @property id Resource ID.
 * @property location Resource location.
 * @property networkManagerName The name of the network manager.
 * @property networkManagerScopeAccesses Scope Access.
 * @property networkManagerScopes Scope of Network Manager.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class NetworkManagerArgs(
    public val description: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val networkManagerScopeAccesses: Output<List<Either<String, ConfigurationType>>>? = null,
    public val networkManagerScopes: Output<NetworkManagerPropertiesNetworkManagerScopesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkManagerArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkManagerArgs =
        com.pulumi.azurenative.network.NetworkManagerArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .networkManagerScopeAccesses(
                networkManagerScopeAccesses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .networkManagerScopes(
                networkManagerScopes?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkManagerArgs].
 */
@PulumiTagMarker
public class NetworkManagerArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var networkManagerScopeAccesses: Output<List<Either<String, ConfigurationType>>>? = null

    private var networkManagerScopes: Output<NetworkManagerPropertiesNetworkManagerScopesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description of the network manager.
     */
    @JvmName("thidfiibthekyxmo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tbmggqftrxdriyaw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jepasbvotdcrnjpy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("uritjafimsknqmlp")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value Scope Access.
     */
    @JvmName("lowbbnjehxdalmsw")
    public suspend fun networkManagerScopeAccesses(`value`: Output<List<Either<String, ConfigurationType>>>) {
        this.networkManagerScopeAccesses = value
    }

    @JvmName("qpsliajiqlsorgaf")
    public suspend fun networkManagerScopeAccesses(vararg values: Output<Either<String, ConfigurationType>>) {
        this.networkManagerScopeAccesses = Output.all(values.asList())
    }

    /**
     * @param values Scope Access.
     */
    @JvmName("mkdywnkhkxnawlbn")
    public suspend fun networkManagerScopeAccesses(values: List<Output<Either<String, ConfigurationType>>>) {
        this.networkManagerScopeAccesses = Output.all(values)
    }

    /**
     * @param value Scope of Network Manager.
     */
    @JvmName("ehpbpfgsfakmcrwt")
    public suspend fun networkManagerScopes(`value`: Output<NetworkManagerPropertiesNetworkManagerScopesArgs>) {
        this.networkManagerScopes = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("peojulrknxnflvlt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lenkbffkylfilihx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description of the network manager.
     */
    @JvmName("ywpqyetotbhpqbuy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ppcwxdruphrvrxsu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("fglooveiqktdniuc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("uqcalatdjagimrpe")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value Scope Access.
     */
    @JvmName("tibdmowguvwdvmjt")
    public suspend fun networkManagerScopeAccesses(`value`: List<Either<String, ConfigurationType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerScopeAccesses = mapped
    }

    /**
     * @param values Scope Access.
     */
    @JvmName("vghvcecafrptgnax")
    public suspend fun networkManagerScopeAccesses(vararg values: Either<String, ConfigurationType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkManagerScopeAccesses = mapped
    }

    /**
     * @param value Scope of Network Manager.
     */
    @JvmName("keiakgppkytiyarf")
    public suspend fun networkManagerScopes(`value`: NetworkManagerPropertiesNetworkManagerScopesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerScopes = mapped
    }

    /**
     * @param argument Scope of Network Manager.
     */
    @JvmName("rmkfkngvcvwdsfcb")
    public suspend fun networkManagerScopes(argument: suspend NetworkManagerPropertiesNetworkManagerScopesArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkManagerPropertiesNetworkManagerScopesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkManagerScopes = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wvqsiowyrhxkvosp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lxtlhicymwxpmfog")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nphcduhrcpiotblj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkManagerArgs = NetworkManagerArgs(
        description = description,
        id = id,
        location = location,
        networkManagerName = networkManagerName,
        networkManagerScopeAccesses = networkManagerScopeAccesses,
        networkManagerScopes = networkManagerScopes,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
