@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ContainerNetworkInterfaceConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ContainerNetworkInterfaceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ContainerNetworkInterfaceConfigurationResponse.Companion.toKotlin as containerNetworkInterfaceConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ContainerNetworkInterfaceResponse.Companion.toKotlin as containerNetworkInterfaceResponseToKotlin

/**
 * Builder for [NetworkProfile].
 */
@PulumiTagMarker
public class NetworkProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkProfileArgs = NetworkProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val builder = NetworkProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkProfile {
        val builtJavaResource = com.pulumi.azurenative.network.NetworkProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkProfile(builtJavaResource)
    }
}

/**
 * Network profile resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create network profile defaults
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkProfile = new AzureNative.Network.NetworkProfile("networkProfile", new()
 *     {
 *         ContainerNetworkInterfaceConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.ContainerNetworkInterfaceConfigurationArgs
 *             {
 *                 IpConfigurations = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.IPConfigurationProfileArgs
 *                     {
 *                         Name = "ipconfig1",
 *                         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/networkProfileVnet/subnets/networkProfileSubnet1",
 *                         },
 *                     },
 *                 },
 *                 Name = "eth1",
 *             },
 *         },
 *         Location = "westus",
 *         NetworkProfileName = "networkProfile1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkProfile(ctx, "networkProfile", &network.NetworkProfileArgs{
 * 			ContainerNetworkInterfaceConfigurations: network.ContainerNetworkInterfaceConfigurationArray{
 * 				&network.ContainerNetworkInterfaceConfigurationArgs{
 * 					IpConfigurations: network.IPConfigurationProfileArray{
 * 						&network.IPConfigurationProfileArgs{
 * 							Name: pulumi.String("ipconfig1"),
 * 							Subnet: &network.SubnetTypeArgs{
 * 								Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/networkProfileVnet/subnets/networkProfileSubnet1"),
 * 							},
 * 						},
 * 					},
 * 					Name: pulumi.String("eth1"),
 * 				},
 * 			},
 * 			Location:           pulumi.String("westus"),
 * 			NetworkProfileName: pulumi.String("networkProfile1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkProfile;
 * import com.pulumi.azurenative.network.NetworkProfileArgs;
 * import com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkProfile = new NetworkProfile("networkProfile", NetworkProfileArgs.builder()
 *             .containerNetworkInterfaceConfigurations(ContainerNetworkInterfaceConfigurationArgs.builder()
 *                 .ipConfigurations(IPConfigurationProfileArgs.builder()
 *                     .name("ipconfig1")
 *                     .subnet(SubnetArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/networkProfileVnet/subnets/networkProfileSubnet1")
 *                         .build())
 *                     .build())
 *                 .name("eth1")
 *                 .build())
 *             .location("westus")
 *             .networkProfileName("networkProfile1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkProfile networkProfile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkProfiles/{networkProfileName}
 * ```
 */
public class NetworkProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NetworkProfile,
) : KotlinCustomResource(javaResource, NetworkProfileMapper) {
    /**
     * List of chid container network interface configurations.
     */
    public val containerNetworkInterfaceConfigurations:
        Output<List<ContainerNetworkInterfaceConfigurationResponse>>?
        get() = javaResource.containerNetworkInterfaceConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        containerNetworkInterfaceConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of child container network interfaces.
     */
    public val containerNetworkInterfaces: Output<List<ContainerNetworkInterfaceResponse>>
        get() = javaResource.containerNetworkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> containerNetworkInterfaceResponseToKotlin(args0) })
            })
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the network profile resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the network profile resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkProfileMapper : ResourceMapper<NetworkProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NetworkProfile::class == javaResource::class

    override fun map(javaResource: Resource): NetworkProfile = NetworkProfile(
        javaResource as
            com.pulumi.azurenative.network.NetworkProfile,
    )
}

/**
 * @see [NetworkProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkProfile].
 */
public suspend fun networkProfile(
    name: String,
    block: suspend NetworkProfileResourceBuilder.() -> Unit,
): NetworkProfile {
    val builder = NetworkProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkProfile(name: String): NetworkProfile {
    val builder = NetworkProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
