@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [NspLink].
 */
@PulumiTagMarker
public class NspLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NspLinkArgs = NspLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NspLinkArgsBuilder.() -> Unit) {
        val builder = NspLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NspLink {
        val builtJavaResource = com.pulumi.azurenative.network.NspLink(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NspLink(builtJavaResource)
    }
}

/**
 * The network security perimeter link resource
 * Azure REST API version: 2021-02-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### NspLinksPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nspLink = new AzureNative.Network.NspLink("nspLink", new()
 *     {
 *         AutoApprovedRemotePerimeterResourceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp2",
 *         LinkName = "link1",
 *         NetworkSecurityPerimeterName = "nsp1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNspLink(ctx, "nspLink", &network.NspLinkArgs{
 * 			AutoApprovedRemotePerimeterResourceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp2"),
 * 			LinkName:                              pulumi.String("link1"),
 * 			NetworkSecurityPerimeterName:          pulumi.String("nsp1"),
 * 			ResourceGroupName:                     pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NspLink;
 * import com.pulumi.azurenative.network.NspLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nspLink = new NspLink("nspLink", NspLinkArgs.builder()
 *             .autoApprovedRemotePerimeterResourceId("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityPerimeters/nsp2")
 *             .linkName("link1")
 *             .networkSecurityPerimeterName("nsp1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NspLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/links/{linkName}
 * ```
 */
public class NspLink internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NspLink,
) : KotlinCustomResource(javaResource, NspLinkMapper) {
    /**
     * Perimeter ARM Id for the remote NSP with which the link gets created in Auto-approval mode. It should be used when the NSP admin have Microsoft.Network/networkSecurityPerimeters/linkPerimeter/action permission on the remote NSP resource.
     */
    public val autoApprovedRemotePerimeterResourceId: Output<String>?
        get() = javaResource.autoApprovedRemotePerimeterResourceId().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * A message passed to the owner of the remote NSP link resource with this connection request. In case of Auto-approved flow, it is default to 'Auto Approved'. Restricted to 140 chars.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Local Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; It's default value is ['*'].
     */
    public val localInboundProfiles: Output<List<String>>?
        get() = javaResource.localInboundProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Local Outbound profile names from which Outbound is allowed. In current version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later version, user will be able to modify it.
     */
    public val localOutboundProfiles: Output<List<String>>
        get() = javaResource.localOutboundProfiles().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the NSP Link resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Remote Inbound profile names to which Inbound is allowed. Use ['*'] to allow inbound to all profiles&#46; This property can only be updated in auto-approval mode&#46; It's default value is ['*'].
     */
    public val remoteInboundProfiles: Output<List<String>>?
        get() = javaResource.remoteInboundProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Remote Outbound profile names from which Outbound is allowed. In current version, it is readonly property and it's value is set to ['*'] to allow outbound from all profiles. In later version, user will be able to modify it.
     */
    public val remoteOutboundProfiles: Output<List<String>>
        get() = javaResource.remoteOutboundProfiles().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Remote NSP Guid with which the link gets created.
     */
    public val remotePerimeterGuid: Output<String>
        get() = javaResource.remotePerimeterGuid().applyValue({ args0 -> args0 })

    /**
     * Remote NSP location with which the link gets created.
     */
    public val remotePerimeterLocation: Output<String>
        get() = javaResource.remotePerimeterLocation().applyValue({ args0 -> args0 })

    /**
     * The NSP link state.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NspLinkMapper : ResourceMapper<NspLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NspLink::class == javaResource::class

    override fun map(javaResource: Resource): NspLink = NspLink(
        javaResource as
            com.pulumi.azurenative.network.NspLink,
    )
}

/**
 * @see [NspLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NspLink].
 */
public suspend fun nspLink(name: String, block: suspend NspLinkResourceBuilder.() -> Unit): NspLink {
    val builder = NspLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NspLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nspLink(name: String): NspLink {
    val builder = NspLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
