@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigRadiusClientRootCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigRadiusServerRootCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigVpnClientRevokedCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigVpnClientRootCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin as ipsecPolicyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigRadiusClientRootCertificateResponse.Companion.toKotlin as p2SVpnServerConfigRadiusClientRootCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigRadiusServerRootCertificateResponse.Companion.toKotlin as p2SVpnServerConfigRadiusServerRootCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigVpnClientRevokedCertificateResponse.Companion.toKotlin as p2SVpnServerConfigVpnClientRevokedCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigVpnClientRootCertificateResponse.Companion.toKotlin as p2SVpnServerConfigVpnClientRootCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [P2sVpnServerConfiguration].
 */
@PulumiTagMarker
public class P2sVpnServerConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: P2sVpnServerConfigurationArgs = P2sVpnServerConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend P2sVpnServerConfigurationArgsBuilder.() -> Unit) {
        val builder = P2sVpnServerConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): P2sVpnServerConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.network.P2sVpnServerConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return P2sVpnServerConfiguration(builtJavaResource)
    }
}

/**
 * P2SVpnServerConfiguration Resource.
 * Azure REST API version: 2019-07-01. Prior API version in Azure Native 1.x: 2019-07-01.
 * ## Example Usage
 * ### P2SVpnServerConfigurationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var p2sVpnServerConfiguration = new AzureNative.Network.P2sVpnServerConfiguration("p2sVpnServerConfiguration", new()
 *     {
 *         P2SVpnServerConfigRadiusClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SVpnServerConfigRadiusClientRootCertificateArgs
 *             {
 *                 Name = "p2sVpnServerConfigRadiusClientRootCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         P2SVpnServerConfigRadiusServerRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SVpnServerConfigRadiusServerRootCertificateArgs
 *             {
 *                 Name = "p2sVpnServerConfigRadiusServerRootCert1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM",
 *             },
 *         },
 *         P2SVpnServerConfigVpnClientRevokedCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs
 *             {
 *                 Name = "p2sVpnServerConfigVpnClientRevokedCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         P2SVpnServerConfigVpnClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SVpnServerConfigVpnClientRootCertificateArgs
 *             {
 *                 Name = "p2sVpnServerConfigVpnClientRootCert1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN",
 *             },
 *         },
 *         P2SVpnServerConfigurationName = "p2sVpnServerConfiguration1",
 *         RadiusServerAddress = "8.9.9.9",
 *         RadiusServerSecret = "<radiusServerSecret>",
 *         ResourceGroupName = "rg1",
 *         VirtualWanName = "virtualWan1",
 *         VpnClientIpsecPolicies = new[]
 *         {
 *             new AzureNative.Network.Inputs.IpsecPolicyArgs
 *             {
 *                 DhGroup = AzureNative.Network.DhGroup.DHGroup14,
 *                 IkeEncryption = AzureNative.Network.IkeEncryption.AES256,
 *                 IkeIntegrity = AzureNative.Network.IkeIntegrity.SHA384,
 *                 IpsecEncryption = AzureNative.Network.IpsecEncryption.AES256,
 *                 IpsecIntegrity = AzureNative.Network.IpsecIntegrity.SHA256,
 *                 PfsGroup = AzureNative.Network.PfsGroup.PFS14,
 *                 SaDataSizeKilobytes = 429497,
 *                 SaLifeTimeSeconds = 86472,
 *             },
 *         },
 *         VpnProtocols = new[]
 *         {
 *             AzureNative.Network.VpnGatewayTunnelingProtocol.IkeV2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewP2sVpnServerConfiguration(ctx, "p2sVpnServerConfiguration", &network.P2sVpnServerConfigurationArgs{
 * 			P2SVpnServerConfigRadiusClientRootCertificates: network.P2SVpnServerConfigRadiusClientRootCertificateArray{
 * 				&network.P2SVpnServerConfigRadiusClientRootCertificateArgs{
 * 					Name:       pulumi.String("p2sVpnServerConfigRadiusClientRootCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			P2SVpnServerConfigRadiusServerRootCertificates: network.P2SVpnServerConfigRadiusServerRootCertificateArray{
 * 				&network.P2SVpnServerConfigRadiusServerRootCertificateArgs{
 * 					Name:           pulumi.String("p2sVpnServerConfigRadiusServerRootCert1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
 * 				},
 * 			},
 * 			P2SVpnServerConfigVpnClientRevokedCertificates: network.P2SVpnServerConfigVpnClientRevokedCertificateArray{
 * 				&network.P2SVpnServerConfigVpnClientRevokedCertificateArgs{
 * 					Name:       pulumi.String("p2sVpnServerConfigVpnClientRevokedCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			P2SVpnServerConfigVpnClientRootCertificates: network.P2SVpnServerConfigVpnClientRootCertificateArray{
 * 				&network.P2SVpnServerConfigVpnClientRootCertificateArgs{
 * 					Name:           pulumi.String("p2sVpnServerConfigVpnClientRootCert1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
 * 				},
 * 			},
 * 			P2SVpnServerConfigurationName: pulumi.String("p2sVpnServerConfiguration1"),
 * 			RadiusServerAddress:           pulumi.String("8.9.9.9"),
 * 			RadiusServerSecret:            pulumi.String("<radiusServerSecret>"),
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 			VirtualWanName:                pulumi.String("virtualWan1"),
 * 			VpnClientIpsecPolicies: network.IpsecPolicyArray{
 * 				&network.IpsecPolicyArgs{
 * 					DhGroup:             pulumi.String(network.DhGroupDHGroup14),
 * 					IkeEncryption:       pulumi.String(network.IkeEncryptionAES256),
 * 					IkeIntegrity:        pulumi.String(network.IkeIntegritySHA384),
 * 					IpsecEncryption:     pulumi.String(network.IpsecEncryptionAES256),
 * 					IpsecIntegrity:      pulumi.String(network.IpsecIntegritySHA256),
 * 					PfsGroup:            pulumi.String(network.PfsGroupPFS14),
 * 					SaDataSizeKilobytes: pulumi.Int(429497),
 * 					SaLifeTimeSeconds:   pulumi.Int(86472),
 * 				},
 * 			},
 * 			VpnProtocols: pulumi.StringArray{
 * 				pulumi.String(network.VpnGatewayTunnelingProtocolIkeV2),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.P2sVpnServerConfiguration;
 * import com.pulumi.azurenative.network.P2sVpnServerConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigRadiusClientRootCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigRadiusServerRootCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRevokedCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRootCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.IpsecPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var p2sVpnServerConfiguration = new P2sVpnServerConfiguration("p2sVpnServerConfiguration", P2sVpnServerConfigurationArgs.builder()
 *             .p2SVpnServerConfigRadiusClientRootCertificates(P2SVpnServerConfigRadiusClientRootCertificateArgs.builder()
 *                 .name("p2sVpnServerConfigRadiusClientRootCert1")
 *                 .thumbprint("83FFBFC8848B5A5836C94D0112367E16148A286F")
 *                 .build())
 *             .p2SVpnServerConfigRadiusServerRootCertificates(P2SVpnServerConfigRadiusServerRootCertificateArgs.builder()
 *                 .name("p2sVpnServerConfigRadiusServerRootCert1")
 *                 .publicCertData("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM")
 *                 .build())
 *             .p2SVpnServerConfigVpnClientRevokedCertificates(P2SVpnServerConfigVpnClientRevokedCertificateArgs.builder()
 *                 .name("p2sVpnServerConfigVpnClientRevokedCert1")
 *                 .thumbprint("83FFBFC8848B5A5836C94D0112367E16148A286F")
 *                 .build())
 *             .p2SVpnServerConfigVpnClientRootCertificates(P2SVpnServerConfigVpnClientRootCertificateArgs.builder()
 *                 .name("p2sVpnServerConfigVpnClientRootCert1")
 *                 .publicCertData("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN")
 *                 .build())
 *             .p2SVpnServerConfigurationName("p2sVpnServerConfiguration1")
 *             .radiusServerAddress("8.9.9.9")
 *             .radiusServerSecret("<radiusServerSecret>")
 *             .resourceGroupName("rg1")
 *             .virtualWanName("virtualWan1")
 *             .vpnClientIpsecPolicies(IpsecPolicyArgs.builder()
 *                 .dhGroup("DHGroup14")
 *                 .ikeEncryption("AES256")
 *                 .ikeIntegrity("SHA384")
 *                 .ipsecEncryption("AES256")
 *                 .ipsecIntegrity("SHA256")
 *                 .pfsGroup("PFS14")
 *                 .saDataSizeKilobytes(429497)
 *                 .saLifeTimeSeconds(86472)
 *                 .build())
 *             .vpnProtocols("IkeV2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:P2sVpnServerConfiguration p2sVpnServerConfiguration1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}
 * ```
 */
public class P2sVpnServerConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.network.P2sVpnServerConfiguration,
) : KotlinCustomResource(javaResource, P2sVpnServerConfigurationMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the P2SVpnServerConfiguration that is unique within a VirtualWan in a resource group. This name can be used to access the resource along with Paren VirtualWan resource name.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of references to P2SVpnGateways.
     */
    public val p2SVpnGateways: Output<List<SubResourceResponse>>
        get() = javaResource.p2SVpnGateways().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * Radius client root certificate of P2SVpnServerConfiguration.
     */
    public val p2SVpnServerConfigRadiusClientRootCertificates:
        Output<List<P2SVpnServerConfigRadiusClientRootCertificateResponse>>?
        get() = javaResource.p2SVpnServerConfigRadiusClientRootCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        p2SVpnServerConfigRadiusClientRootCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Radius Server root certificate of P2SVpnServerConfiguration.
     */
    public val p2SVpnServerConfigRadiusServerRootCertificates:
        Output<List<P2SVpnServerConfigRadiusServerRootCertificateResponse>>?
        get() = javaResource.p2SVpnServerConfigRadiusServerRootCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        p2SVpnServerConfigRadiusServerRootCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * VPN client revoked certificate of P2SVpnServerConfiguration.
     */
    public val p2SVpnServerConfigVpnClientRevokedCertificates:
        Output<List<P2SVpnServerConfigVpnClientRevokedCertificateResponse>>?
        get() = javaResource.p2SVpnServerConfigVpnClientRevokedCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        p2SVpnServerConfigVpnClientRevokedCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * VPN client root certificate of P2SVpnServerConfiguration.
     */
    public val p2SVpnServerConfigVpnClientRootCertificates:
        Output<List<P2SVpnServerConfigVpnClientRootCertificateResponse>>?
        get() = javaResource.p2SVpnServerConfigVpnClientRootCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        p2SVpnServerConfigVpnClientRootCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the P2S VPN server configuration resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The radius server address property of the P2SVpnServerConfiguration resource for point to site client connection.
     */
    public val radiusServerAddress: Output<String>?
        get() = javaResource.radiusServerAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The radius secret property of the P2SVpnServerConfiguration resource for point to site client connection.
     */
    public val radiusServerSecret: Output<String>?
        get() = javaResource.radiusServerSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * VpnClientIpsecPolicies for P2SVpnServerConfiguration.
     */
    public val vpnClientIpsecPolicies: Output<List<IpsecPolicyResponse>>?
        get() = javaResource.vpnClientIpsecPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        ipsecPolicyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * VPN protocols for the P2SVpnServerConfiguration.
     */
    public val vpnProtocols: Output<List<String>>?
        get() = javaResource.vpnProtocols().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object P2sVpnServerConfigurationMapper : ResourceMapper<P2sVpnServerConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.P2sVpnServerConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): P2sVpnServerConfiguration =
        P2sVpnServerConfiguration(
            javaResource as
                com.pulumi.azurenative.network.P2sVpnServerConfiguration,
        )
}

/**
 * @see [P2sVpnServerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [P2sVpnServerConfiguration].
 */
public suspend fun p2sVpnServerConfiguration(
    name: String,
    block: suspend P2sVpnServerConfigurationResourceBuilder.() -> Unit,
): P2sVpnServerConfiguration {
    val builder = P2sVpnServerConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [P2sVpnServerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun p2sVpnServerConfiguration(name: String): P2sVpnServerConfiguration {
    val builder = P2sVpnServerConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
