@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PrivateDnsZoneGroupArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.PrivateDnsZoneConfigArgs
import com.pulumi.azurenative.network.kotlin.inputs.PrivateDnsZoneConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Private dns zone group resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-02-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create private dns zone group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateDnsZoneGroup = new AzureNative.Network.PrivateDnsZoneGroup("privateDnsZoneGroup", new()
 *     {
 *         PrivateDnsZoneConfigs = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateDnsZoneConfigArgs
 *             {
 *                 PrivateDnsZoneId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateDnsZones/zone1.com",
 *             },
 *         },
 *         PrivateDnsZoneGroupName = "testPdnsgroup",
 *         PrivateEndpointName = "testPe",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateDnsZoneGroup(ctx, "privateDnsZoneGroup", &network.PrivateDnsZoneGroupArgs{
 * 			PrivateDnsZoneConfigs: network.PrivateDnsZoneConfigArray{
 * 				&network.PrivateDnsZoneConfigArgs{
 * 					PrivateDnsZoneId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateDnsZones/zone1.com"),
 * 				},
 * 			},
 * 			PrivateDnsZoneGroupName: pulumi.String("testPdnsgroup"),
 * 			PrivateEndpointName:     pulumi.String("testPe"),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateDnsZoneGroup;
 * import com.pulumi.azurenative.network.PrivateDnsZoneGroupArgs;
 * import com.pulumi.azurenative.network.inputs.PrivateDnsZoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateDnsZoneGroup = new PrivateDnsZoneGroup("privateDnsZoneGroup", PrivateDnsZoneGroupArgs.builder()
 *             .privateDnsZoneConfigs(PrivateDnsZoneConfigArgs.builder()
 *                 .privateDnsZoneId("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateDnsZones/zone1.com")
 *                 .build())
 *             .privateDnsZoneGroupName("testPdnsgroup")
 *             .privateEndpointName("testPe")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateDnsZoneGroup testPdnsgroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}/privateDnsZoneGroups/{privateDnsZoneGroupName}
 * ```
 * @property id Resource ID.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateDnsZoneConfigs A collection of private dns zone configurations of the private dns zone group.
 * @property privateDnsZoneGroupName The name of the private dns zone group.
 * @property privateEndpointName The name of the private endpoint.
 * @property resourceGroupName The name of the resource group.
 */
public data class PrivateDnsZoneGroupArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateDnsZoneConfigs: Output<List<PrivateDnsZoneConfigArgs>>? = null,
    public val privateDnsZoneGroupName: Output<String>? = null,
    public val privateEndpointName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PrivateDnsZoneGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PrivateDnsZoneGroupArgs =
        com.pulumi.azurenative.network.PrivateDnsZoneGroupArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateDnsZoneConfigs(
                privateDnsZoneConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateDnsZoneGroupName(privateDnsZoneGroupName?.applyValue({ args0 -> args0 }))
            .privateEndpointName(privateEndpointName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateDnsZoneGroupArgs].
 */
@PulumiTagMarker
public class PrivateDnsZoneGroupArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var privateDnsZoneConfigs: Output<List<PrivateDnsZoneConfigArgs>>? = null

    private var privateDnsZoneGroupName: Output<String>? = null

    private var privateEndpointName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("bkiggnqjqswhwybn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("bokpodhgbmcqneks")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A collection of private dns zone configurations of the private dns zone group.
     */
    @JvmName("bufmwqujfmdeuxva")
    public suspend fun privateDnsZoneConfigs(`value`: Output<List<PrivateDnsZoneConfigArgs>>) {
        this.privateDnsZoneConfigs = value
    }

    @JvmName("ahdjtbqudxgmjqsk")
    public suspend fun privateDnsZoneConfigs(vararg values: Output<PrivateDnsZoneConfigArgs>) {
        this.privateDnsZoneConfigs = Output.all(values.asList())
    }

    /**
     * @param values A collection of private dns zone configurations of the private dns zone group.
     */
    @JvmName("udqywkwqhdgysblx")
    public suspend fun privateDnsZoneConfigs(values: List<Output<PrivateDnsZoneConfigArgs>>) {
        this.privateDnsZoneConfigs = Output.all(values)
    }

    /**
     * @param value The name of the private dns zone group.
     */
    @JvmName("asdqjprsguclnthr")
    public suspend fun privateDnsZoneGroupName(`value`: Output<String>) {
        this.privateDnsZoneGroupName = value
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("icsjquggbwaceuvl")
    public suspend fun privateEndpointName(`value`: Output<String>) {
        this.privateEndpointName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dayqhwfnwknqawvu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("rjfkyctbpiefutlg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("jwylygkwbrwijysr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A collection of private dns zone configurations of the private dns zone group.
     */
    @JvmName("vjhvketwchxkvldy")
    public suspend fun privateDnsZoneConfigs(`value`: List<PrivateDnsZoneConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsZoneConfigs = mapped
    }

    /**
     * @param argument A collection of private dns zone configurations of the private dns zone group.
     */
    @JvmName("drpsvtveurcrflvu")
    public suspend fun privateDnsZoneConfigs(argument: List<suspend PrivateDnsZoneConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateDnsZoneConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateDnsZoneConfigs = mapped
    }

    /**
     * @param argument A collection of private dns zone configurations of the private dns zone group.
     */
    @JvmName("mbphjdulouoxnvhr")
    public suspend fun privateDnsZoneConfigs(vararg argument: suspend PrivateDnsZoneConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrivateDnsZoneConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateDnsZoneConfigs = mapped
    }

    /**
     * @param argument A collection of private dns zone configurations of the private dns zone group.
     */
    @JvmName("wxmbbkyfvlcmltiv")
    public suspend fun privateDnsZoneConfigs(argument: suspend PrivateDnsZoneConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrivateDnsZoneConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.privateDnsZoneConfigs = mapped
    }

    /**
     * @param values A collection of private dns zone configurations of the private dns zone group.
     */
    @JvmName("egdenpsqccesvnas")
    public suspend fun privateDnsZoneConfigs(vararg values: PrivateDnsZoneConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateDnsZoneConfigs = mapped
    }

    /**
     * @param value The name of the private dns zone group.
     */
    @JvmName("svrgdtuxldreimms")
    public suspend fun privateDnsZoneGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsZoneGroupName = mapped
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("eystqtbdfveshyjg")
    public suspend fun privateEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tctxpsmfseyaxdyg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateDnsZoneGroupArgs = PrivateDnsZoneGroupArgs(
        id = id,
        name = name,
        privateDnsZoneConfigs = privateDnsZoneConfigs,
        privateDnsZoneGroupName = privateDnsZoneGroupName,
        privateEndpointName = privateEndpointName,
        resourceGroupName = resourceGroupName,
    )
}
