@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceIpConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServicePropertiesResponseAutoApproval
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServicePropertiesResponseVisibility
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FrontendIPConfigurationResponse.Companion.toKotlin as frontendIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin as networkInterfaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceIpConfigurationResponse.Companion.toKotlin as privateLinkServiceIpConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServicePropertiesResponseAutoApproval.Companion.toKotlin as privateLinkServicePropertiesResponseAutoApprovalToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServicePropertiesResponseVisibility.Companion.toKotlin as privateLinkServicePropertiesResponseVisibilityToKotlin

/**
 * Builder for [PrivateLinkService].
 */
@PulumiTagMarker
public class PrivateLinkServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkServiceArgs = PrivateLinkServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateLinkServiceArgsBuilder.() -> Unit) {
        val builder = PrivateLinkServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateLinkService {
        val builtJavaResource =
            com.pulumi.azurenative.network.PrivateLinkService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateLinkService(builtJavaResource)
    }
}

/**
 * Private link service resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-08-01, 2021-02-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create private link service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkService = new AzureNative.Network.PrivateLinkService("privateLinkService", new()
 *     {
 *         AutoApproval = new AzureNative.Network.Inputs.PrivateLinkServicePropertiesAutoApprovalArgs
 *         {
 *             Subscriptions = new[]
 *             {
 *                 "subscription1",
 *                 "subscription2",
 *             },
 *         },
 *         Fqdns = new[]
 *         {
 *             "fqdn1",
 *             "fqdn2",
 *             "fqdn3",
 *         },
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateLinkServiceIpConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 PrivateIPAddress = "10.0.1.4",
 *                 PrivateIPAddressVersion = AzureNative.Network.IPVersion.IPv4,
 *                 PrivateIPAllocationMethod = AzureNative.Network.IPAllocationMethod.Static,
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         LoadBalancerFrontendIpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "testPls",
 *         Visibility = new AzureNative.Network.Inputs.PrivateLinkServicePropertiesVisibilityArgs
 *         {
 *             Subscriptions = new[]
 *             {
 *                 "subscription1",
 *                 "subscription2",
 *                 "subscription3",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateLinkService(ctx, "privateLinkService", &network.PrivateLinkServiceArgs{
 * 			AutoApproval: &network.PrivateLinkServicePropertiesAutoApprovalArgs{
 * 				Subscriptions: pulumi.StringArray{
 * 					pulumi.String("subscription1"),
 * 					pulumi.String("subscription2"),
 * 				},
 * 			},
 * 			Fqdns: pulumi.StringArray{
 * 				pulumi.String("fqdn1"),
 * 				pulumi.String("fqdn2"),
 * 				pulumi.String("fqdn3"),
 * 			},
 * 			IpConfigurations: network.PrivateLinkServiceIpConfigurationArray{
 * 				&network.PrivateLinkServiceIpConfigurationArgs{
 * 					Name:                      pulumi.String("fe-lb"),
 * 					PrivateIPAddress:          pulumi.String("10.0.1.4"),
 * 					PrivateIPAddressVersion:   pulumi.String(network.IPVersionIPv4),
 * 					PrivateIPAllocationMethod: pulumi.String(network.IPAllocationMethodStatic),
 * 					Subnet: &network.SubnetTypeArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			LoadBalancerFrontendIpConfigurations: network.FrontendIPConfigurationArray{
 * 				&network.FrontendIPConfigurationArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("testPls"),
 * 			Visibility: &network.PrivateLinkServicePropertiesVisibilityArgs{
 * 				Subscriptions: pulumi.StringArray{
 * 					pulumi.String("subscription1"),
 * 					pulumi.String("subscription2"),
 * 					pulumi.String("subscription3"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateLinkService;
 * import com.pulumi.azurenative.network.PrivateLinkServiceArgs;
 * import com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesAutoApprovalArgs;
 * import com.pulumi.azurenative.network.inputs.PrivateLinkServiceIpConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.FrontendIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesVisibilityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkService = new PrivateLinkService("privateLinkService", PrivateLinkServiceArgs.builder()
 *             .autoApproval(PrivateLinkServicePropertiesAutoApprovalArgs.builder()
 *                 .subscriptions(
 *                     "subscription1",
 *                     "subscription2")
 *                 .build())
 *             .fqdns(
 *                 "fqdn1",
 *                 "fqdn2",
 *                 "fqdn3")
 *             .ipConfigurations(PrivateLinkServiceIpConfigurationArgs.builder()
 *                 .name("fe-lb")
 *                 .privateIPAddress("10.0.1.4")
 *                 .privateIPAddressVersion("IPv4")
 *                 .privateIPAllocationMethod("Static")
 *                 .subnet(SubnetArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")
 *                     .build())
 *                 .build())
 *             .loadBalancerFrontendIpConfigurations(FrontendIPConfigurationArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .serviceName("testPls")
 *             .visibility(PrivateLinkServicePropertiesVisibilityArgs.builder()
 *                 .subscriptions(
 *                     "subscription1",
 *                     "subscription2",
 *                     "subscription3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateLinkService testPls /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}
 * ```
 */
public class PrivateLinkService internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PrivateLinkService,
) : KotlinCustomResource(javaResource, PrivateLinkServiceMapper) {
    /**
     * The alias of the private link service.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * The auto-approval list of the private link service.
     */
    public val autoApproval: Output<PrivateLinkServicePropertiesResponseAutoApproval>?
        get() = javaResource.autoApproval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServicePropertiesResponseAutoApprovalToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Whether the private link service is enabled for proxy protocol or not.
     */
    public val enableProxyProtocol: Output<Boolean>?
        get() = javaResource.enableProxyProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The extended location of the load balancer.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The list of Fqdn.
     */
    public val fqdns: Output<List<String>>?
        get() = javaResource.fqdns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * An array of private link service IP configurations.
     */
    public val ipConfigurations: Output<List<PrivateLinkServiceIpConfigurationResponse>>?
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateLinkServiceIpConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of references to the load balancer IP configurations.
     */
    public val loadBalancerFrontendIpConfigurations: Output<List<FrontendIPConfigurationResponse>>?
        get() = javaResource.loadBalancerFrontendIpConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        frontendIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An array of references to the network interfaces created for this private link service.
     */
    public val networkInterfaces: Output<List<NetworkInterfaceResponse>>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfaceResponseToKotlin(args0) })
            })
        })

    /**
     * An array of list about connections to the private endpoint.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state of the private link service resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The visibility list of the private link service.
     */
    public val visibility: Output<PrivateLinkServicePropertiesResponseVisibility>?
        get() = javaResource.visibility().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServicePropertiesResponseVisibilityToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object PrivateLinkServiceMapper : ResourceMapper<PrivateLinkService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PrivateLinkService::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkService = PrivateLinkService(
        javaResource as
            com.pulumi.azurenative.network.PrivateLinkService,
    )
}

/**
 * @see [PrivateLinkService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkService].
 */
public suspend fun privateLinkService(
    name: String,
    block: suspend PrivateLinkServiceResourceBuilder.() -> Unit,
): PrivateLinkService {
    val builder = PrivateLinkServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkService(name: String): PrivateLinkService {
    val builder = PrivateLinkServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
