@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateResolverVirtualNetworkLink].
 */
@PulumiTagMarker
public class PrivateResolverVirtualNetworkLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateResolverVirtualNetworkLinkArgs = PrivateResolverVirtualNetworkLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateResolverVirtualNetworkLinkArgsBuilder.() -> Unit) {
        val builder = PrivateResolverVirtualNetworkLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateResolverVirtualNetworkLink {
        val builtJavaResource =
            com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLink(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateResolverVirtualNetworkLink(builtJavaResource)
    }
}

/**
 * Describes a virtual network link.
 * Azure REST API version: 2022-07-01.
 * Other available API versions: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert virtual network link to a DNS forwarding ruleset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateResolverVirtualNetworkLink = new AzureNative.Network.PrivateResolverVirtualNetworkLink("privateResolverVirtualNetworkLink", new()
 *     {
 *         DnsForwardingRulesetName = "sampleDnsForwardingRuleset",
 *         Metadata =
 *         {
 *             { "additionalProp1", "value1" },
 *         },
 *         ResourceGroupName = "sampleResourceGroup",
 *         VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork",
 *         },
 *         VirtualNetworkLinkName = "sampleVirtualNetworkLink",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateResolverVirtualNetworkLink(ctx, "privateResolverVirtualNetworkLink", &network.PrivateResolverVirtualNetworkLinkArgs{
 * 			DnsForwardingRulesetName: pulumi.String("sampleDnsForwardingRuleset"),
 * 			Metadata: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("value1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			VirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork"),
 * 			},
 * 			VirtualNetworkLinkName: pulumi.String("sampleVirtualNetworkLink"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLink;
 * import com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLinkArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateResolverVirtualNetworkLink = new PrivateResolverVirtualNetworkLink("privateResolverVirtualNetworkLink", PrivateResolverVirtualNetworkLinkArgs.builder()
 *             .dnsForwardingRulesetName("sampleDnsForwardingRuleset")
 *             .metadata(Map.of("additionalProp1", "value1"))
 *             .resourceGroupName("sampleResourceGroup")
 *             .virtualNetwork(SubResourceArgs.builder()
 *                 .id("/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork")
 *                 .build())
 *             .virtualNetworkLinkName("sampleVirtualNetworkLink")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateResolverVirtualNetworkLink sampleVirtualNetworkLink /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/virtualNetworkLinks/{virtualNetworkLinkName}
 * ```
 */
public class PrivateResolverVirtualNetworkLink internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLink,
) : KotlinCustomResource(javaResource, PrivateResolverVirtualNetworkLinkMapper) {
    /**
     * ETag of the virtual network link.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Metadata attached to the virtual network link.
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current provisioning state of the virtual network link. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The reference to the virtual network. This cannot be changed after creation.
     */
    public val virtualNetwork: Output<SubResourceResponse>
        get() = javaResource.virtualNetwork().applyValue({ args0 ->
            args0.let({ args0 ->
                subResourceResponseToKotlin(args0)
            })
        })
}

public object PrivateResolverVirtualNetworkLinkMapper :
    ResourceMapper<PrivateResolverVirtualNetworkLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLink::class == javaResource::class

    override fun map(javaResource: Resource): PrivateResolverVirtualNetworkLink =
        PrivateResolverVirtualNetworkLink(
            javaResource as
                com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLink,
        )
}

/**
 * @see [PrivateResolverVirtualNetworkLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateResolverVirtualNetworkLink].
 */
public suspend fun privateResolverVirtualNetworkLink(
    name: String,
    block: suspend PrivateResolverVirtualNetworkLinkResourceBuilder.() -> Unit,
): PrivateResolverVirtualNetworkLink {
    val builder = PrivateResolverVirtualNetworkLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateResolverVirtualNetworkLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateResolverVirtualNetworkLink(name: String): PrivateResolverVirtualNetworkLink {
    val builder = PrivateResolverVirtualNetworkLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
