@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PrivateZoneArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Private DNS zone.
 * Azure REST API version: 2020-06-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * ## Example Usage
 * ### PUT Private DNS Zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateZone = new AzureNative.Network.PrivateZone("privateZone", new()
 *     {
 *         Location = "Global",
 *         PrivateZoneName = "privatezone1.com",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateZone(ctx, "privateZone", &network.PrivateZoneArgs{
 * 			Location:          pulumi.String("Global"),
 * 			PrivateZoneName:   pulumi.String("privatezone1.com"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateZone;
 * import com.pulumi.azurenative.network.PrivateZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateZone = new PrivateZone("privateZone", PrivateZoneArgs.builder()
 *             .location("Global")
 *             .privateZoneName("privatezone1.com")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateZone privatezone1.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}
 * ```
 * @property location The Azure Region where the resource lives
 * @property privateZoneName The name of the Private DNS zone (without a terminating dot).
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class PrivateZoneArgs(
    public val location: Output<String>? = null,
    public val privateZoneName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PrivateZoneArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PrivateZoneArgs =
        com.pulumi.azurenative.network.PrivateZoneArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .privateZoneName(privateZoneName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateZoneArgs].
 */
@PulumiTagMarker
public class PrivateZoneArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var privateZoneName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Azure Region where the resource lives
     */
    @JvmName("nwnbkwcwrvhhwcou")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("jugohkirdiunptsm")
    public suspend fun privateZoneName(`value`: Output<String>) {
        this.privateZoneName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rabsgfuqpsflayjf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cvkvlwsyucymbmbn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Azure Region where the resource lives
     */
    @JvmName("onmeaoolradpfdrk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("bylpeiirbrtmttuy")
    public suspend fun privateZoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateZoneName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ljnfkoyjfdbiseye")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qcwybjogwwlbfeas")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("sxtaiguoubtatvul")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateZoneArgs = PrivateZoneArgs(
        location = location,
        privateZoneName = privateZoneName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
