@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PublicIPAddressArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.DeleteOptions
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.azurenative.network.kotlin.enums.IPVersion
import com.pulumi.azurenative.network.kotlin.enums.PublicIPAddressMigrationPhase
import com.pulumi.azurenative.network.kotlin.inputs.DdosSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.DdosSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.IpTagArgs
import com.pulumi.azurenative.network.kotlin.inputs.IpTagArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.NatGatewayArgs
import com.pulumi.azurenative.network.kotlin.inputs.NatGatewayArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressDnsSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressDnsSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressSkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressSkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Public IP address resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2016-03-30, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create public IP address DNS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPAddress = new AzureNative.Network.PublicIPAddress("publicIPAddress", new()
 *     {
 *         DnsSettings = new AzureNative.Network.Inputs.PublicIPAddressDnsSettingsArgs
 *         {
 *             DomainNameLabel = "dnslbl",
 *         },
 *         Location = "eastus",
 *         PublicIpAddressName = "test-ip",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPAddress(ctx, "publicIPAddress", &network.PublicIPAddressArgs{
 * 			DnsSettings: &network.PublicIPAddressDnsSettingsArgs{
 * 				DomainNameLabel: pulumi.String("dnslbl"),
 * 			},
 * 			Location:            pulumi.String("eastus"),
 * 			PublicIpAddressName: pulumi.String("test-ip"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPAddress;
 * import com.pulumi.azurenative.network.PublicIPAddressArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPAddressDnsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPAddress = new PublicIPAddress("publicIPAddress", PublicIPAddressArgs.builder()
 *             .dnsSettings(PublicIPAddressDnsSettingsArgs.builder()
 *                 .domainNameLabel("dnslbl")
 *                 .build())
 *             .location("eastus")
 *             .publicIpAddressName("test-ip")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create public IP address DNS with Domain Name Label Scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPAddress = new AzureNative.Network.PublicIPAddress("publicIPAddress", new()
 *     {
 *         DnsSettings = new AzureNative.Network.Inputs.PublicIPAddressDnsSettingsArgs
 *         {
 *             DomainNameLabel = "dnslbl",
 *             DomainNameLabelScope = AzureNative.Network.PublicIpAddressDnsSettingsDomainNameLabelScope.TenantReuse,
 *         },
 *         Location = "eastus",
 *         PublicIpAddressName = "test-ip",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPAddress(ctx, "publicIPAddress", &network.PublicIPAddressArgs{
 * 			DnsSettings: &network.PublicIPAddressDnsSettingsArgs{
 * 				DomainNameLabel:      pulumi.String("dnslbl"),
 * 				DomainNameLabelScope: network.PublicIpAddressDnsSettingsDomainNameLabelScopeTenantReuse,
 * 			},
 * 			Location:            pulumi.String("eastus"),
 * 			PublicIpAddressName: pulumi.String("test-ip"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPAddress;
 * import com.pulumi.azurenative.network.PublicIPAddressArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPAddressDnsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPAddress = new PublicIPAddress("publicIPAddress", PublicIPAddressArgs.builder()
 *             .dnsSettings(PublicIPAddressDnsSettingsArgs.builder()
 *                 .domainNameLabel("dnslbl")
 *                 .domainNameLabelScope("TenantReuse")
 *                 .build())
 *             .location("eastus")
 *             .publicIpAddressName("test-ip")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create public IP address allocation method
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPAddress = new AzureNative.Network.PublicIPAddress("publicIPAddress", new()
 *     {
 *         IdleTimeoutInMinutes = 10,
 *         Location = "eastus",
 *         PublicIPAddressVersion = AzureNative.Network.IPVersion.IPv4,
 *         PublicIPAllocationMethod = AzureNative.Network.IPAllocationMethod.Static,
 *         PublicIpAddressName = "test-ip",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.PublicIPAddressSkuArgs
 *         {
 *             Name = AzureNative.Network.PublicIPAddressSkuName.Standard,
 *             Tier = AzureNative.Network.PublicIPAddressSkuTier.Global,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPAddress(ctx, "publicIPAddress", &network.PublicIPAddressArgs{
 * 			IdleTimeoutInMinutes:     pulumi.Int(10),
 * 			Location:                 pulumi.String("eastus"),
 * 			PublicIPAddressVersion:   pulumi.String(network.IPVersionIPv4),
 * 			PublicIPAllocationMethod: pulumi.String(network.IPAllocationMethodStatic),
 * 			PublicIpAddressName:      pulumi.String("test-ip"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 			Sku: &network.PublicIPAddressSkuArgs{
 * 				Name: pulumi.String(network.PublicIPAddressSkuNameStandard),
 * 				Tier: pulumi.String(network.PublicIPAddressSkuTierGlobal),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPAddress;
 * import com.pulumi.azurenative.network.PublicIPAddressArgs;
 * import com.pulumi.azurenative.network.inputs.PublicIPAddressSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPAddress = new PublicIPAddress("publicIPAddress", PublicIPAddressArgs.builder()
 *             .idleTimeoutInMinutes(10)
 *             .location("eastus")
 *             .publicIPAddressVersion("IPv4")
 *             .publicIPAllocationMethod("Static")
 *             .publicIpAddressName("test-ip")
 *             .resourceGroupName("rg1")
 *             .sku(PublicIPAddressSkuArgs.builder()
 *                 .name("Standard")
 *                 .tier("Global")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create public IP address defaults
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPAddress = new AzureNative.Network.PublicIPAddress("publicIPAddress", new()
 *     {
 *         Location = "eastus",
 *         PublicIpAddressName = "test-ip",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPAddress(ctx, "publicIPAddress", &network.PublicIPAddressArgs{
 * 			Location:            pulumi.String("eastus"),
 * 			PublicIpAddressName: pulumi.String("test-ip"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPAddress;
 * import com.pulumi.azurenative.network.PublicIPAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPAddress = new PublicIPAddress("publicIPAddress", PublicIPAddressArgs.builder()
 *             .location("eastus")
 *             .publicIpAddressName("test-ip")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PublicIPAddress testDNS-ip /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPAddresses/{publicIpAddressName}
 * ```
 * @property ddosSettings The DDoS protection custom policy associated with the public IP address.
 * @property deleteOption Specify what happens to the public IP address when the VM using it is deleted
 * @property dnsSettings The FQDN of the DNS record associated with the public IP address.
 * @property extendedLocation The extended location of the public ip address.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The idle timeout of the public IP address.
 * @property ipAddress The IP address associated with the public IP address resource.
 * @property ipTags The list of tags associated with the public IP address.
 * @property linkedPublicIPAddress The linked public IP address of the public IP address resource.
 * @property location Resource location.
 * @property migrationPhase Migration phase of Public IP Address.
 * @property natGateway The NatGateway for the Public IP address.
 * @property publicIPAddressVersion The public IP address version.
 * @property publicIPAllocationMethod The public IP address allocation method.
 * @property publicIPPrefix The Public IP Prefix this Public IP Address should be allocated from.
 * @property publicIpAddressName The name of the public IP address.
 * @property resourceGroupName The name of the resource group.
 * @property servicePublicIPAddress The service public IP address of the public IP address resource.
 * @property sku The public IP address SKU.
 * @property tags Resource tags.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class PublicIPAddressArgs(
    public val ddosSettings: Output<DdosSettingsArgs>? = null,
    public val deleteOption: Output<Either<String, DeleteOptions>>? = null,
    public val dnsSettings: Output<PublicIPAddressDnsSettingsArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val ipAddress: Output<String>? = null,
    public val ipTags: Output<List<IpTagArgs>>? = null,
    public val linkedPublicIPAddress: Output<com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs>? = null,
    public val location: Output<String>? = null,
    public val migrationPhase: Output<Either<String, PublicIPAddressMigrationPhase>>? = null,
    public val natGateway: Output<NatGatewayArgs>? = null,
    public val publicIPAddressVersion: Output<Either<String, IPVersion>>? = null,
    public val publicIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val publicIPPrefix: Output<SubResourceArgs>? = null,
    public val publicIpAddressName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val servicePublicIPAddress: Output<com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs>? = null,
    public val sku: Output<PublicIPAddressSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PublicIPAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PublicIPAddressArgs =
        com.pulumi.azurenative.network.PublicIPAddressArgs.builder()
            .ddosSettings(ddosSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .ipTags(ipTags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .linkedPublicIPAddress(
                linkedPublicIPAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .migrationPhase(
                migrationPhase?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .natGateway(natGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicIPAddressVersion(
                publicIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAllocationMethod(
                publicIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPPrefix(publicIPPrefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicIpAddressName(publicIpAddressName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .servicePublicIPAddress(
                servicePublicIPAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PublicIPAddressArgs].
 */
@PulumiTagMarker
public class PublicIPAddressArgsBuilder internal constructor() {
    private var ddosSettings: Output<DdosSettingsArgs>? = null

    private var deleteOption: Output<Either<String, DeleteOptions>>? = null

    private var dnsSettings: Output<PublicIPAddressDnsSettingsArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var ipAddress: Output<String>? = null

    private var ipTags: Output<List<IpTagArgs>>? = null

    private var linkedPublicIPAddress:
        Output<com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs>? = null

    private var location: Output<String>? = null

    private var migrationPhase: Output<Either<String, PublicIPAddressMigrationPhase>>? = null

    private var natGateway: Output<NatGatewayArgs>? = null

    private var publicIPAddressVersion: Output<Either<String, IPVersion>>? = null

    private var publicIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var publicIPPrefix: Output<SubResourceArgs>? = null

    private var publicIpAddressName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var servicePublicIPAddress:
        Output<com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs>? = null

    private var sku: Output<PublicIPAddressSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The DDoS protection custom policy associated with the public IP address.
     */
    @JvmName("jjvorgmpiadpmfrk")
    public suspend fun ddosSettings(`value`: Output<DdosSettingsArgs>) {
        this.ddosSettings = value
    }

    /**
     * @param value Specify what happens to the public IP address when the VM using it is deleted
     */
    @JvmName("pqqeciqdxewyqtkd")
    public suspend fun deleteOption(`value`: Output<Either<String, DeleteOptions>>) {
        this.deleteOption = value
    }

    /**
     * @param value The FQDN of the DNS record associated with the public IP address.
     */
    @JvmName("tsdmpkqnhjqsmurs")
    public suspend fun dnsSettings(`value`: Output<PublicIPAddressDnsSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value The extended location of the public ip address.
     */
    @JvmName("smcyaldilkegfkhv")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pvttnsafkorqwuah")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The idle timeout of the public IP address.
     */
    @JvmName("uguxyysgrcdqbrud")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The IP address associated with the public IP address resource.
     */
    @JvmName("furbuqcepmjnhnea")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value The list of tags associated with the public IP address.
     */
    @JvmName("ewcifakgfnojkgfc")
    public suspend fun ipTags(`value`: Output<List<IpTagArgs>>) {
        this.ipTags = value
    }

    @JvmName("egkocoruompqkcof")
    public suspend fun ipTags(vararg values: Output<IpTagArgs>) {
        this.ipTags = Output.all(values.asList())
    }

    /**
     * @param values The list of tags associated with the public IP address.
     */
    @JvmName("oxpweosuegjuqlkn")
    public suspend fun ipTags(values: List<Output<IpTagArgs>>) {
        this.ipTags = Output.all(values)
    }

    /**
     * @param value The linked public IP address of the public IP address resource.
     */
    @JvmName("uokgrpyrdugyaxaf")
    public suspend fun linkedPublicIPAddress(`value`: Output<com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs>) {
        this.linkedPublicIPAddress = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("wcjbduigvnbjxrkf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Migration phase of Public IP Address.
     */
    @JvmName("bybuoxlfrbusiwjr")
    public suspend fun migrationPhase(`value`: Output<Either<String, PublicIPAddressMigrationPhase>>) {
        this.migrationPhase = value
    }

    /**
     * @param value The NatGateway for the Public IP address.
     */
    @JvmName("oxaxxwvehhdgdugo")
    public suspend fun natGateway(`value`: Output<NatGatewayArgs>) {
        this.natGateway = value
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("hyayiirqoceqxqhr")
    public suspend fun publicIPAddressVersion(`value`: Output<Either<String, IPVersion>>) {
        this.publicIPAddressVersion = value
    }

    /**
     * @param value The public IP address allocation method.
     */
    @JvmName("knqokgpccxlpsqje")
    public suspend fun publicIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.publicIPAllocationMethod = value
    }

    /**
     * @param value The Public IP Prefix this Public IP Address should be allocated from.
     */
    @JvmName("gydyfthgewaewupn")
    public suspend fun publicIPPrefix(`value`: Output<SubResourceArgs>) {
        this.publicIPPrefix = value
    }

    /**
     * @param value The name of the public IP address.
     */
    @JvmName("jitmxbfjxhhyoyxp")
    public suspend fun publicIpAddressName(`value`: Output<String>) {
        this.publicIpAddressName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("slrpadcabxwnwmit")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The service public IP address of the public IP address resource.
     */
    @JvmName("kcdullnxnevpudui")
    public suspend fun servicePublicIPAddress(`value`: Output<com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs>) {
        this.servicePublicIPAddress = value
    }

    /**
     * @param value The public IP address SKU.
     */
    @JvmName("dakyoqosmxwgfyik")
    public suspend fun sku(`value`: Output<PublicIPAddressSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("turqdbqfbkdhtykf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("qhhdnsvocfahublf")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("tvuwuijycabfsavq")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("ferflvceosobbreq")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The DDoS protection custom policy associated with the public IP address.
     */
    @JvmName("labdmhlejgxplccj")
    public suspend fun ddosSettings(`value`: DdosSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosSettings = mapped
    }

    /**
     * @param argument The DDoS protection custom policy associated with the public IP address.
     */
    @JvmName("iasamkknnsutwoiq")
    public suspend fun ddosSettings(argument: suspend DdosSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DdosSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ddosSettings = mapped
    }

    /**
     * @param value Specify what happens to the public IP address when the VM using it is deleted
     */
    @JvmName("bvngktvodnmvocuu")
    public suspend fun deleteOption(`value`: Either<String, DeleteOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the public IP address when the VM using it is deleted
     */
    @JvmName("silhimnwjbodderv")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the public IP address when the VM using it is deleted
     */
    @JvmName("gspbojetpevndbpr")
    public fun deleteOption(`value`: DeleteOptions) {
        val toBeMapped = Either.ofRight<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value The FQDN of the DNS record associated with the public IP address.
     */
    @JvmName("nfbhlplacavkkwso")
    public suspend fun dnsSettings(`value`: PublicIPAddressDnsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument The FQDN of the DNS record associated with the public IP address.
     */
    @JvmName("gthonqsmjnoibmje")
    public suspend fun dnsSettings(argument: suspend PublicIPAddressDnsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressDnsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value The extended location of the public ip address.
     */
    @JvmName("loutmwlrfwbdonjb")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the public ip address.
     */
    @JvmName("gmlikdcgmgknxuyi")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pkqcrowprbipivfa")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The idle timeout of the public IP address.
     */
    @JvmName("lfdjhrddqnujjcih")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The IP address associated with the public IP address resource.
     */
    @JvmName("wemjeadnlmswpsmv")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value The list of tags associated with the public IP address.
     */
    @JvmName("ktbsfhqllcxvvnnu")
    public suspend fun ipTags(`value`: List<IpTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP address.
     */
    @JvmName("kmjwtlnaoqelvuoq")
    public suspend fun ipTags(argument: List<suspend IpTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP address.
     */
    @JvmName("wpkmkgdeftefhqgm")
    public suspend fun ipTags(vararg argument: suspend IpTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP address.
     */
    @JvmName("cekdtshrtrhivllt")
    public suspend fun ipTags(argument: suspend IpTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param values The list of tags associated with the public IP address.
     */
    @JvmName("xebnmtgusuecsbxw")
    public suspend fun ipTags(vararg values: IpTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param value The linked public IP address of the public IP address resource.
     */
    @JvmName("ntnjjyfimunefksl")
    public suspend fun linkedPublicIPAddress(`value`: com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedPublicIPAddress = mapped
    }

    /**
     * @param argument The linked public IP address of the public IP address resource.
     */
    @JvmName("ppgutivtkgysoqpj")
    public suspend fun linkedPublicIPAddress(argument: suspend com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.linkedPublicIPAddress = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tnvkmwornsnyoosq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Migration phase of Public IP Address.
     */
    @JvmName("rdeprbtubaoetclx")
    public suspend fun migrationPhase(`value`: Either<String, PublicIPAddressMigrationPhase>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value Migration phase of Public IP Address.
     */
    @JvmName("gtukrphpoqctpuxf")
    public fun migrationPhase(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPAddressMigrationPhase>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value Migration phase of Public IP Address.
     */
    @JvmName("prkqbwvhjjbrdoyl")
    public fun migrationPhase(`value`: PublicIPAddressMigrationPhase) {
        val toBeMapped = Either.ofRight<String, PublicIPAddressMigrationPhase>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value The NatGateway for the Public IP address.
     */
    @JvmName("ltmdobaehihgmyqa")
    public suspend fun natGateway(`value`: NatGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGateway = mapped
    }

    /**
     * @param argument The NatGateway for the Public IP address.
     */
    @JvmName("kamktxjcpbnalaob")
    public suspend fun natGateway(argument: suspend NatGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = NatGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.natGateway = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("ujhtynnhxvnauixw")
    public suspend fun publicIPAddressVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("dhelwvmlpguguvfm")
    public fun publicIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("qfdaoasqgdeuuigc")
    public fun publicIPAddressVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The public IP address allocation method.
     */
    @JvmName("xkcvvbspuevqanlx")
    public suspend fun publicIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value The public IP address allocation method.
     */
    @JvmName("tvxbymsgohhcturv")
    public fun publicIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value The public IP address allocation method.
     */
    @JvmName("xxtxmdpwpdsknbrj")
    public fun publicIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value The Public IP Prefix this Public IP Address should be allocated from.
     */
    @JvmName("sptslujaqnonvtuf")
    public suspend fun publicIPPrefix(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPPrefix = mapped
    }

    /**
     * @param argument The Public IP Prefix this Public IP Address should be allocated from.
     */
    @JvmName("umqjaenlhaanhcky")
    public suspend fun publicIPPrefix(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPPrefix = mapped
    }

    /**
     * @param value The name of the public IP address.
     */
    @JvmName("cxuxsehtlqgjtupk")
    public suspend fun publicIpAddressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tlqtgfdgjtdyoxuy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The service public IP address of the public IP address resource.
     */
    @JvmName("lgapbipolbjpcrjj")
    public suspend fun servicePublicIPAddress(`value`: com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePublicIPAddress = mapped
    }

    /**
     * @param argument The service public IP address of the public IP address resource.
     */
    @JvmName("gynfqdnxuojqwwyi")
    public suspend fun servicePublicIPAddress(argument: suspend com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.servicePublicIPAddress = mapped
    }

    /**
     * @param value The public IP address SKU.
     */
    @JvmName("bxrxqdmrsoaxgnrn")
    public suspend fun sku(`value`: PublicIPAddressSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The public IP address SKU.
     */
    @JvmName("ndjycmgfmlvuvknq")
    public suspend fun sku(argument: suspend PublicIPAddressSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rbfxjwbblsnrjioh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bxvtydddsajuwhtt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("mkkatqlrgdgbtvny")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("xqsivqejviwuywey")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): PublicIPAddressArgs = PublicIPAddressArgs(
        ddosSettings = ddosSettings,
        deleteOption = deleteOption,
        dnsSettings = dnsSettings,
        extendedLocation = extendedLocation,
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        ipAddress = ipAddress,
        ipTags = ipTags,
        linkedPublicIPAddress = linkedPublicIPAddress,
        location = location,
        migrationPhase = migrationPhase,
        natGateway = natGateway,
        publicIPAddressVersion = publicIPAddressVersion,
        publicIPAllocationMethod = publicIPAllocationMethod,
        publicIPPrefix = publicIPPrefix,
        publicIpAddressName = publicIpAddressName,
        resourceGroupName = resourceGroupName,
        servicePublicIPAddress = servicePublicIPAddress,
        sku = sku,
        tags = tags,
        zones = zones,
    )
}
