@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RouteFilterArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.RouteFilterRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.RouteFilterRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Route Filter Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### RouteFilterCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeFilter = new AzureNative.Network.RouteFilter("routeFilter", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         RouteFilterName = "filterName",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RouteFilterRuleArgs
 *             {
 *                 Access = AzureNative.Network.Access.Allow,
 *                 Communities = new[]
 *                 {
 *                     "12076:5030",
 *                     "12076:5040",
 *                 },
 *                 Name = "ruleName",
 *                 RouteFilterRuleType = AzureNative.Network.RouteFilterRuleType.Community,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteFilter(ctx, "routeFilter", &network.RouteFilterArgs{
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteFilterName:   pulumi.String("filterName"),
 * 			Rules: network.RouteFilterRuleTypeArray{
 * 				&network.RouteFilterRuleTypeArgs{
 * 					Access: pulumi.String(network.AccessAllow),
 * 					Communities: pulumi.StringArray{
 * 						pulumi.String("12076:5030"),
 * 						pulumi.String("12076:5040"),
 * 					},
 * 					Name:                pulumi.String("ruleName"),
 * 					RouteFilterRuleType: pulumi.String(network.RouteFilterRuleTypeCommunity),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteFilter;
 * import com.pulumi.azurenative.network.RouteFilterArgs;
 * import com.pulumi.azurenative.network.inputs.RouteFilterRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeFilter = new RouteFilter("routeFilter", RouteFilterArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .routeFilterName("filterName")
 *             .rules(RouteFilterRuleArgs.builder()
 *                 .access("Allow")
 *                 .communities(
 *                     "12076:5030",
 *                     "12076:5040")
 *                 .name("ruleName")
 *                 .routeFilterRuleType("Community")
 *                 .build())
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RouteFilter filterName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}
 * ```
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property routeFilterName The name of the route filter.
 * @property rules Collection of RouteFilterRules contained within a route filter.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property tags Resource tags.
 */
public data class RouteFilterArgs(
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeFilterName: Output<String>? = null,
    public val rules: Output<List<RouteFilterRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RouteFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RouteFilterArgs =
        com.pulumi.azurenative.network.RouteFilterArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeFilterName(routeFilterName?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RouteFilterArgs].
 */
@PulumiTagMarker
public class RouteFilterArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeFilterName: Output<String>? = null

    private var rules: Output<List<RouteFilterRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("obengwbdswnyfapv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hypgiofokruiwyyc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wrrmokhdotodtrqi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the route filter.
     */
    @JvmName("wlvxepgeqownrfpj")
    public suspend fun routeFilterName(`value`: Output<String>) {
        this.routeFilterName = value
    }

    /**
     * @param value Collection of RouteFilterRules contained within a route filter.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("totuiaejgdywmfqq")
    public suspend fun rules(`value`: Output<List<RouteFilterRuleArgs>>) {
        this.rules = value
    }

    @JvmName("brynytgxeydtuqad")
    public suspend fun rules(vararg values: Output<RouteFilterRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Collection of RouteFilterRules contained within a route filter.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xiwfnvkbfqywvxby")
    public suspend fun rules(values: List<Output<RouteFilterRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wvhhmcouivqixswn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qtidiknoorsfdufg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tvctuolambwqrmch")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nvlotmhjwikqluqf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the route filter.
     */
    @JvmName("ijdamjshcfubrmqt")
    public suspend fun routeFilterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeFilterName = mapped
    }

    /**
     * @param value Collection of RouteFilterRules contained within a route filter.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("dncbuvwbbumjbalr")
    public suspend fun rules(`value`: List<RouteFilterRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Collection of RouteFilterRules contained within a route filter.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("qjytxtmgbqtdicso")
    public suspend fun rules(argument: List<suspend RouteFilterRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteFilterRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of RouteFilterRules contained within a route filter.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("sccuicmygjfcqltb")
    public suspend fun rules(vararg argument: suspend RouteFilterRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RouteFilterRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of RouteFilterRules contained within a route filter.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hyuptihlxupgvdld")
    public suspend fun rules(argument: suspend RouteFilterRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RouteFilterRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Collection of RouteFilterRules contained within a route filter.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("niokspsnjxljkgfw")
    public suspend fun rules(vararg values: RouteFilterRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("whvxyuxgimxhlegk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qhhmnuwfegljuehd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RouteFilterArgs = RouteFilterArgs(
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        routeFilterName = routeFilterName,
        rules = rules,
        tags = tags,
    )
}
