@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.RulesEngineRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.RulesEngineRuleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RulesEngine].
 */
@PulumiTagMarker
public class RulesEngineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RulesEngineArgs = RulesEngineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RulesEngineArgsBuilder.() -> Unit) {
        val builder = RulesEngineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RulesEngine {
        val builtJavaResource = com.pulumi.azurenative.network.RulesEngine(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RulesEngine(builtJavaResource)
    }
}

/**
 * A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the request and response.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create or update a specific Rules Engine Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rulesEngine = new AzureNative.Network.RulesEngine("rulesEngine", new()
 *     {
 *         FrontDoorName = "frontDoor1",
 *         ResourceGroupName = "rg1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     RouteConfigurationOverride = new AzureNative.Network.Inputs.RedirectConfigurationArgs
 *                     {
 *                         CustomFragment = "fragment",
 *                         CustomHost = "www.bing.com",
 *                         CustomPath = "/api",
 *                         CustomQueryString = "a=b",
 *                         OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration",
 *                         RedirectProtocol = AzureNative.Network.FrontDoorRedirectProtocol.HttpsOnly,
 *                         RedirectType = AzureNative.Network.FrontDoorRedirectType.Moved,
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "CH",
 *                         },
 *                         RulesEngineMatchVariable = AzureNative.Network.RulesEngineMatchVariable.RemoteAddr,
 *                         RulesEngineOperator = AzureNative.Network.RulesEngineOperator.GeoMatch,
 *                     },
 *                 },
 *                 MatchProcessingBehavior = AzureNative.Network.MatchProcessingBehavior.Stop,
 *                 Name = "Rule1",
 *                 Priority = 1,
 *             },
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     ResponseHeaderActions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.HeaderActionArgs
 *                         {
 *                             HeaderActionType = AzureNative.Network.HeaderActionType.Overwrite,
 *                             HeaderName = "Cache-Control",
 *                             Value = "public, max-age=31536000",
 *                         },
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "jpg",
 *                         },
 *                         RulesEngineMatchVariable = AzureNative.Network.RulesEngineMatchVariable.RequestFilenameExtension,
 *                         RulesEngineOperator = AzureNative.Network.RulesEngineOperator.Equal,
 *                         Transforms = new[]
 *                         {
 *                             AzureNative.Network.Transform.Lowercase,
 *                         },
 *                     },
 *                 },
 *                 Name = "Rule2",
 *                 Priority = 2,
 *             },
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     RouteConfigurationOverride = new AzureNative.Network.Inputs.ForwardingConfigurationArgs
 *                     {
 *                         BackendPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 *                         },
 *                         CacheConfiguration = new AzureNative.Network.Inputs.CacheConfigurationArgs
 *                         {
 *                             CacheDuration = "P1DT12H20M30S",
 *                             DynamicCompression = AzureNative.Network.DynamicCompressionEnabled.Disabled,
 *                             QueryParameterStripDirective = AzureNative.Network.FrontDoorQuery.StripOnly,
 *                             QueryParameters = "a=b,p=q",
 *                         },
 *                         ForwardingProtocol = AzureNative.Network.FrontDoorForwardingProtocol.HttpsOnly,
 *                         OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         NegateCondition = false,
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "allowoverride",
 *                         },
 *                         RulesEngineMatchVariable = AzureNative.Network.RulesEngineMatchVariable.RequestHeader,
 *                         RulesEngineOperator = AzureNative.Network.RulesEngineOperator.Equal,
 *                         Selector = "Rules-Engine-Route-Forward",
 *                         Transforms = new[]
 *                         {
 *                             AzureNative.Network.Transform.Lowercase,
 *                         },
 *                     },
 *                 },
 *                 Name = "Rule3",
 *                 Priority = 3,
 *             },
 *         },
 *         RulesEngineName = "rulesEngine1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRulesEngine(ctx, "rulesEngine", &network.RulesEngineArgs{
 * 			FrontDoorName:     pulumi.String("frontDoor1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Rules: network.RulesEngineRuleArray{
 * 				&network.RulesEngineRuleArgs{
 * 					Action: &network.RulesEngineActionArgs{
 * 						RouteConfigurationOverride: network.RedirectConfiguration{
 * 							CustomFragment:    "fragment",
 * 							CustomHost:        "www.bing.com",
 * 							CustomPath:        "/api",
 * 							CustomQueryString: "a=b",
 * 							OdataType:         "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration",
 * 							RedirectProtocol:  network.FrontDoorRedirectProtocolHttpsOnly,
 * 							RedirectType:      network.FrontDoorRedirectTypeMoved,
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						&network.RulesEngineMatchConditionArgs{
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("CH"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String(network.RulesEngineMatchVariableRemoteAddr),
 * 							RulesEngineOperator:      pulumi.String(network.RulesEngineOperatorGeoMatch),
 * 						},
 * 					},
 * 					MatchProcessingBehavior: pulumi.String(network.MatchProcessingBehaviorStop),
 * 					Name:                    pulumi.String("Rule1"),
 * 					Priority:                pulumi.Int(1),
 * 				},
 * 				&network.RulesEngineRuleArgs{
 * 					Action: &network.RulesEngineActionArgs{
 * 						ResponseHeaderActions: network.HeaderActionArray{
 * 							&network.HeaderActionArgs{
 * 								HeaderActionType: pulumi.String(network.HeaderActionTypeOverwrite),
 * 								HeaderName:       pulumi.String("Cache-Control"),
 * 								Value:            pulumi.String("public, max-age=31536000"),
 * 							},
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						&network.RulesEngineMatchConditionArgs{
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("jpg"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String(network.RulesEngineMatchVariableRequestFilenameExtension),
 * 							RulesEngineOperator:      pulumi.String(network.RulesEngineOperatorEqual),
 * 							Transforms: pulumi.StringArray{
 * 								pulumi.String(network.TransformLowercase),
 * 							},
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule2"),
 * 					Priority: pulumi.Int(2),
 * 				},
 * 				&network.RulesEngineRuleArgs{
 * 					Action: &network.RulesEngineActionArgs{
 * 						RouteConfigurationOverride: network.ForwardingConfiguration{
 * 							BackendPool: network.SubResource{
 * 								Id: "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 * 							},
 * 							CacheConfiguration: network.CacheConfiguration{
 * 								CacheDuration:                "P1DT12H20M30S",
 * 								DynamicCompression:           network.DynamicCompressionEnabledDisabled,
 * 								QueryParameterStripDirective: network.FrontDoorQueryStripOnly,
 * 								QueryParameters:              "a=b,p=q",
 * 							},
 * 							ForwardingProtocol: network.FrontDoorForwardingProtocolHttpsOnly,
 * 							OdataType:          "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						&network.RulesEngineMatchConditionArgs{
 * 							NegateCondition: pulumi.Bool(false),
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("allowoverride"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String(network.RulesEngineMatchVariableRequestHeader),
 * 							RulesEngineOperator:      pulumi.String(network.RulesEngineOperatorEqual),
 * 							Selector:                 pulumi.String("Rules-Engine-Route-Forward"),
 * 							Transforms: pulumi.StringArray{
 * 								pulumi.String(network.TransformLowercase),
 * 							},
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule3"),
 * 					Priority: pulumi.Int(3),
 * 				},
 * 			},
 * 			RulesEngineName: pulumi.String("rulesEngine1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RulesEngine;
 * import com.pulumi.azurenative.network.RulesEngineArgs;
 * import com.pulumi.azurenative.network.inputs.RulesEngineRuleArgs;
 * import com.pulumi.azurenative.network.inputs.RulesEngineActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rulesEngine = new RulesEngine("rulesEngine", RulesEngineArgs.builder()
 *             .frontDoorName("frontDoor1")
 *             .resourceGroupName("rg1")
 *             .rules(
 *                 RulesEngineRuleArgs.builder()
 *                     .action(RulesEngineActionArgs.builder()
 *                         .routeConfigurationOverride(ForwardingConfigurationArgs.builder()
 *                             .customFragment("fragment")
 *                             .customHost("www.bing.com")
 *                             .customPath("/api")
 *                             .customQueryString("a=b")
 *                             .odataType("#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration")
 *                             .redirectProtocol("HttpsOnly")
 *                             .redirectType("Moved")
 *                             .build())
 *                         .build())
 *                     .matchConditions(RulesEngineMatchConditionArgs.builder()
 *                         .rulesEngineMatchValue("CH")
 *                         .rulesEngineMatchVariable("RemoteAddr")
 *                         .rulesEngineOperator("GeoMatch")
 *                         .build())
 *                     .matchProcessingBehavior("Stop")
 *                     .name("Rule1")
 *                     .priority(1)
 *                     .build(),
 *                 RulesEngineRuleArgs.builder()
 *                     .action(RulesEngineActionArgs.builder()
 *                         .responseHeaderActions(HeaderActionArgs.builder()
 *                             .headerActionType("Overwrite")
 *                             .headerName("Cache-Control")
 *                             .value("public, max-age=31536000")
 *                             .build())
 *                         .build())
 *                     .matchConditions(RulesEngineMatchConditionArgs.builder()
 *                         .rulesEngineMatchValue("jpg")
 *                         .rulesEngineMatchVariable("RequestFilenameExtension")
 *                         .rulesEngineOperator("Equal")
 *                         .transforms("Lowercase")
 *                         .build())
 *                     .name("Rule2")
 *                     .priority(2)
 *                     .build(),
 *                 RulesEngineRuleArgs.builder()
 *                     .action(RulesEngineActionArgs.builder()
 *                         .routeConfigurationOverride(ForwardingConfigurationArgs.builder()
 *                             .backendPool(SubResourceArgs.builder()
 *                                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1")
 *                                 .build())
 *                             .cacheConfiguration(CacheConfigurationArgs.builder()
 *                                 .cacheDuration("P1DT12H20M30S")
 *                                 .dynamicCompression("Disabled")
 *                                 .queryParameterStripDirective("StripOnly")
 *                                 .queryParameters("a=b,p=q")
 *                                 .build())
 *                             .forwardingProtocol("HttpsOnly")
 *                             .odataType("#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration")
 *                             .build())
 *                         .build())
 *                     .matchConditions(RulesEngineMatchConditionArgs.builder()
 *                         .negateCondition(false)
 *                         .rulesEngineMatchValue("allowoverride")
 *                         .rulesEngineMatchVariable("RequestHeader")
 *                         .rulesEngineOperator("Equal")
 *                         .selector("Rules-Engine-Route-Forward")
 *                         .transforms("Lowercase")
 *                         .build())
 *                     .name("Rule3")
 *                     .priority(3)
 *                     .build())
 *             .rulesEngineName("rulesEngine1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RulesEngine rulesEngine1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/rulesEngines/{rulesEngineName}
 * ```
 */
public class RulesEngine internal constructor(
    override val javaResource: com.pulumi.azurenative.network.RulesEngine,
) : KotlinCustomResource(javaResource, RulesEngineMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource status.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * A list of rules that define a particular Rules Engine Configuration.
     */
    public val rules: Output<List<RulesEngineRuleResponse>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RulesEngineMapper : ResourceMapper<RulesEngine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.RulesEngine::class == javaResource::class

    override fun map(javaResource: Resource): RulesEngine = RulesEngine(
        javaResource as
            com.pulumi.azurenative.network.RulesEngine,
    )
}

/**
 * @see [RulesEngine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RulesEngine].
 */
public suspend fun rulesEngine(name: String, block: suspend RulesEngineResourceBuilder.() -> Unit): RulesEngine {
    val builder = RulesEngineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RulesEngine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rulesEngine(name: String): RulesEngine {
    val builder = RulesEngineResourceBuilder()
    builder.name(name)
    return builder.build()
}
