@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.SecurityRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleAccess
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleDirection
import com.pulumi.azurenative.network.kotlin.enums.SecurityRuleProtocol
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationSecurityGroupArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationSecurityGroupArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network security rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2017-03-01, 2019-06-01, 2022-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create security rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityRule = new AzureNative.Network.SecurityRule("securityRule", new()
 *     {
 *         Access = AzureNative.Network.SecurityRuleAccess.Deny,
 *         DestinationAddressPrefix = "11.0.0.0/8",
 *         DestinationPortRange = "8080",
 *         Direction = AzureNative.Network.SecurityRuleDirection.Outbound,
 *         NetworkSecurityGroupName = "testnsg",
 *         Priority = 100,
 *         Protocol = AzureNative.Network.SecurityRuleProtocol.Asterisk,
 *         ResourceGroupName = "rg1",
 *         SecurityRuleName = "rule1",
 *         SourceAddressPrefix = "10.0.0.0/8",
 *         SourcePortRange = "*",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSecurityRule(ctx, "securityRule", &network.SecurityRuleArgs{
 * 			Access:                   pulumi.String(network.SecurityRuleAccessDeny),
 * 			DestinationAddressPrefix: pulumi.String("11.0.0.0/8"),
 * 			DestinationPortRange:     pulumi.String("8080"),
 * 			Direction:                pulumi.String(network.SecurityRuleDirectionOutbound),
 * 			NetworkSecurityGroupName: pulumi.String("testnsg"),
 * 			Priority:                 pulumi.Int(100),
 * 			Protocol:                 pulumi.String(network.SecurityRuleProtocolAsterisk),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 			SecurityRuleName:         pulumi.String("rule1"),
 * 			SourceAddressPrefix:      pulumi.String("10.0.0.0/8"),
 * 			SourcePortRange:          pulumi.String("*"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SecurityRule;
 * import com.pulumi.azurenative.network.SecurityRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityRule = new SecurityRule("securityRule", SecurityRuleArgs.builder()
 *             .access("Deny")
 *             .destinationAddressPrefix("11.0.0.0/8")
 *             .destinationPortRange("8080")
 *             .direction("Outbound")
 *             .networkSecurityGroupName("testnsg")
 *             .priority(100)
 *             .protocol("*")
 *             .resourceGroupName("rg1")
 *             .securityRuleName("rule1")
 *             .sourceAddressPrefix("10.0.0.0/8")
 *             .sourcePortRange("*")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SecurityRule rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}/securityRules/{securityRuleName}
 * ```
 * @property access The network traffic is allowed or denied.
 * @property description A description for this rule. Restricted to 140 chars.
 * @property destinationAddressPrefix The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
 * @property destinationAddressPrefixes The destination address prefixes. CIDR or destination IP ranges.
 * @property destinationApplicationSecurityGroups The application security group specified as destination.
 * @property destinationPortRange The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property destinationPortRanges The destination port ranges.
 * @property direction The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property networkSecurityGroupName The name of the network security group.
 * @property priority The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
 * @property protocol Network protocol this rule applies to.
 * @property resourceGroupName The name of the resource group.
 * @property securityRuleName The name of the security rule.
 * @property sourceAddressPrefix The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
 * @property sourceAddressPrefixes The CIDR or source IP ranges.
 * @property sourceApplicationSecurityGroups The application security group specified as source.
 * @property sourcePortRange The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property sourcePortRanges The source port ranges.
 * @property type The type of the resource.
 */
public data class SecurityRuleArgs(
    public val access: Output<Either<String, SecurityRuleAccess>>? = null,
    public val description: Output<String>? = null,
    public val destinationAddressPrefix: Output<String>? = null,
    public val destinationAddressPrefixes: Output<List<String>>? = null,
    public val destinationApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? =
        null,
    public val destinationPortRange: Output<String>? = null,
    public val destinationPortRanges: Output<List<String>>? = null,
    public val direction: Output<Either<String, SecurityRuleDirection>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkSecurityGroupName: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val protocol: Output<Either<String, SecurityRuleProtocol>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityRuleName: Output<String>? = null,
    public val sourceAddressPrefix: Output<String>? = null,
    public val sourceAddressPrefixes: Output<List<String>>? = null,
    public val sourceApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null,
    public val sourcePortRange: Output<String>? = null,
    public val sourcePortRanges: Output<List<String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.SecurityRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.SecurityRuleArgs =
        com.pulumi.azurenative.network.SecurityRuleArgs.builder()
            .access(
                access?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefix(destinationAddressPrefix?.applyValue({ args0 -> args0 }))
            .destinationAddressPrefixes(
                destinationAddressPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .destinationApplicationSecurityGroups(
                destinationApplicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .destinationPortRange(destinationPortRange?.applyValue({ args0 -> args0 }))
            .destinationPortRanges(destinationPortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .direction(
                direction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkSecurityGroupName(networkSecurityGroupName?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityRuleName(securityRuleName?.applyValue({ args0 -> args0 }))
            .sourceAddressPrefix(sourceAddressPrefix?.applyValue({ args0 -> args0 }))
            .sourceAddressPrefixes(sourceAddressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceApplicationSecurityGroups(
                sourceApplicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 }))
            .sourcePortRanges(sourcePortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityRuleArgs].
 */
@PulumiTagMarker
public class SecurityRuleArgsBuilder internal constructor() {
    private var access: Output<Either<String, SecurityRuleAccess>>? = null

    private var description: Output<String>? = null

    private var destinationAddressPrefix: Output<String>? = null

    private var destinationAddressPrefixes: Output<List<String>>? = null

    private var destinationApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? =
        null

    private var destinationPortRange: Output<String>? = null

    private var destinationPortRanges: Output<List<String>>? = null

    private var direction: Output<Either<String, SecurityRuleDirection>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var networkSecurityGroupName: Output<String>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<Either<String, SecurityRuleProtocol>>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityRuleName: Output<String>? = null

    private var sourceAddressPrefix: Output<String>? = null

    private var sourceAddressPrefixes: Output<List<String>>? = null

    private var sourceApplicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null

    private var sourcePortRange: Output<String>? = null

    private var sourcePortRanges: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("lmdcyhanbkkcehbc")
    public suspend fun access(`value`: Output<Either<String, SecurityRuleAccess>>) {
        this.access = value
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("yqoxwbwesvqymwhl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    @JvmName("unlreockwiliggxb")
    public suspend fun destinationAddressPrefix(`value`: Output<String>) {
        this.destinationAddressPrefix = value
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("wkattwskddkqukku")
    public suspend fun destinationAddressPrefixes(`value`: Output<List<String>>) {
        this.destinationAddressPrefixes = value
    }

    @JvmName("wuboykisgjypbiuw")
    public suspend fun destinationAddressPrefixes(vararg values: Output<String>) {
        this.destinationAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("ovqppwkynbgxtpel")
    public suspend fun destinationAddressPrefixes(values: List<Output<String>>) {
        this.destinationAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The application security group specified as destination.
     */
    @JvmName("utjiwpthmjlvylar")
    public suspend fun destinationApplicationSecurityGroups(`value`: Output<List<ApplicationSecurityGroupArgs>>) {
        this.destinationApplicationSecurityGroups = value
    }

    @JvmName("uptuhjoxceofncbj")
    public suspend fun destinationApplicationSecurityGroups(vararg values: Output<ApplicationSecurityGroupArgs>) {
        this.destinationApplicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values The application security group specified as destination.
     */
    @JvmName("cbyksjduitgpvlrw")
    public suspend fun destinationApplicationSecurityGroups(values: List<Output<ApplicationSecurityGroupArgs>>) {
        this.destinationApplicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("nsoyovjmwnkcysre")
    public suspend fun destinationPortRange(`value`: Output<String>) {
        this.destinationPortRange = value
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("vfbmkfuoxfdmlpcf")
    public suspend fun destinationPortRanges(`value`: Output<List<String>>) {
        this.destinationPortRanges = value
    }

    @JvmName("xguxlmxiefahgogv")
    public suspend fun destinationPortRanges(vararg values: Output<String>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("tviyjuhhxfrdooge")
    public suspend fun destinationPortRanges(values: List<Output<String>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("fhgpgubpqyjweauo")
    public suspend fun direction(`value`: Output<Either<String, SecurityRuleDirection>>) {
        this.direction = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bvcniikupxtafxjw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ahahblwxasovlegw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the network security group.
     */
    @JvmName("ybnpajoibposvhgc")
    public suspend fun networkSecurityGroupName(`value`: Output<String>) {
        this.networkSecurityGroupName = value
    }

    /**
     * @param value The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("vaukbqlytlfgggjn")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("oyhyjobhgmsxwpjf")
    public suspend fun protocol(`value`: Output<Either<String, SecurityRuleProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mtuevbadlxbgnhfu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the security rule.
     */
    @JvmName("sedtorrhdltwcars")
    public suspend fun securityRuleName(`value`: Output<String>) {
        this.securityRuleName = value
    }

    /**
     * @param value The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    @JvmName("qbpgyhvnefcnhwel")
    public suspend fun sourceAddressPrefix(`value`: Output<String>) {
        this.sourceAddressPrefix = value
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("qnuyynkybenjeahh")
    public suspend fun sourceAddressPrefixes(`value`: Output<List<String>>) {
        this.sourceAddressPrefixes = value
    }

    @JvmName("gpxtfpyswjkgqsra")
    public suspend fun sourceAddressPrefixes(vararg values: Output<String>) {
        this.sourceAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("wlrfmebgeqbpwcso")
    public suspend fun sourceAddressPrefixes(values: List<Output<String>>) {
        this.sourceAddressPrefixes = Output.all(values)
    }

    /**
     * @param value The application security group specified as source.
     */
    @JvmName("tyrualrrxkwpuydk")
    public suspend fun sourceApplicationSecurityGroups(`value`: Output<List<ApplicationSecurityGroupArgs>>) {
        this.sourceApplicationSecurityGroups = value
    }

    @JvmName("uwwfrnbwrimebadj")
    public suspend fun sourceApplicationSecurityGroups(vararg values: Output<ApplicationSecurityGroupArgs>) {
        this.sourceApplicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values The application security group specified as source.
     */
    @JvmName("kbwtgrdyuxmhppxh")
    public suspend fun sourceApplicationSecurityGroups(values: List<Output<ApplicationSecurityGroupArgs>>) {
        this.sourceApplicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("ekbyygitlfdmbtug")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("rubxmvqjbtyeysfs")
    public suspend fun sourcePortRanges(`value`: Output<List<String>>) {
        this.sourcePortRanges = value
    }

    @JvmName("fgrsbermkginvoot")
    public suspend fun sourcePortRanges(vararg values: Output<String>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("eqijsadhthmvyohk")
    public suspend fun sourcePortRanges(values: List<Output<String>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("gvukiqeekrgqhjnp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("jginwpttwestpkpa")
    public suspend fun access(`value`: Either<String, SecurityRuleAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("frxdnedpwdpgqfyj")
    public fun access(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The network traffic is allowed or denied.
     */
    @JvmName("dpfkppxusmddmllk")
    public fun access(`value`: SecurityRuleAccess) {
        val toBeMapped = Either.ofRight<String, SecurityRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("oetdyaijhxqrishl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
     */
    @JvmName("iuhjxonlqmpeevsc")
    public suspend fun destinationAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefix = mapped
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("ysfgjcmanqfqmdsi")
    public suspend fun destinationAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddressPrefixes = mapped
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("wpvotnmblgndejyc")
    public suspend fun destinationAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddressPrefixes = mapped
    }

    /**
     * @param value The application security group specified as destination.
     */
    @JvmName("agfoduresyrkcyca")
    public suspend fun destinationApplicationSecurityGroups(`value`: List<ApplicationSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("tylgbmvudhprtthd")
    public suspend fun destinationApplicationSecurityGroups(argument: List<suspend ApplicationSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("pijxbxkjwevdqnvc")
    public suspend fun destinationApplicationSecurityGroups(vararg argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as destination.
     */
    @JvmName("vijptnvofkbjihth")
    public suspend fun destinationApplicationSecurityGroups(argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param values The application security group specified as destination.
     */
    @JvmName("sruyjvdvxwynobjs")
    public suspend fun destinationApplicationSecurityGroups(vararg values: ApplicationSecurityGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationApplicationSecurityGroups = mapped
    }

    /**
     * @param value The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("injiqwcooilkrmac")
    public suspend fun destinationPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRange = mapped
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("jlpxmghgstppfiqt")
    public suspend fun destinationPortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("xraoqivbqrmkvcev")
    public suspend fun destinationPortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("lbqckshmtyevqkai")
    public suspend fun direction(`value`: Either<String, SecurityRuleDirection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("tojlfvywlfqfvkvu")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
     */
    @JvmName("jmdghniebvxadgfv")
    public fun direction(`value`: SecurityRuleDirection) {
        val toBeMapped = Either.ofRight<String, SecurityRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qwtdmrfpvhjpuokn")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("fqgfxeacmxbeunre")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the network security group.
     */
    @JvmName("jtpuwogncbjmaffb")
    public suspend fun networkSecurityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroupName = mapped
    }

    /**
     * @param value The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("abbycvwsiqpnwawl")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("gqxymapjkvmqigjb")
    public suspend fun protocol(`value`: Either<String, SecurityRuleProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("cawgcadrarqcgnft")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("xqutasetpladfnkl")
    public fun protocol(`value`: SecurityRuleProtocol) {
        val toBeMapped = Either.ofRight<String, SecurityRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vatqhnnvejtpnqqc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the security rule.
     */
    @JvmName("bsyjxewvagdvuwmj")
    public suspend fun securityRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityRuleName = mapped
    }

    /**
     * @param value The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
     */
    @JvmName("sjteecxtosvosqvf")
    public suspend fun sourceAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefix = mapped
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("kcmlabaetfewdran")
    public suspend fun sourceAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddressPrefixes = mapped
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("rdintlmoffarwchy")
    public suspend fun sourceAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddressPrefixes = mapped
    }

    /**
     * @param value The application security group specified as source.
     */
    @JvmName("ytxlymyllkdcqyrv")
    public suspend fun sourceApplicationSecurityGroups(`value`: List<ApplicationSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("ijisbcwcuocodpej")
    public suspend fun sourceApplicationSecurityGroups(argument: List<suspend ApplicationSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("bkdkuelbcqjsebgu")
    public suspend fun sourceApplicationSecurityGroups(vararg argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param argument The application security group specified as source.
     */
    @JvmName("qwxkvygvlnkgraby")
    public suspend fun sourceApplicationSecurityGroups(argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param values The application security group specified as source.
     */
    @JvmName("rjhnpcdtvbxfbyts")
    public suspend fun sourceApplicationSecurityGroups(vararg values: ApplicationSecurityGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceApplicationSecurityGroups = mapped
    }

    /**
     * @param value The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
     */
    @JvmName("svnejykkbpfmnbqe")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("ynywdyavxhlhrmcn")
    public suspend fun sourcePortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("krogirodbnrymkce")
    public suspend fun sourcePortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("fcmdfuprslfqfhhn")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SecurityRuleArgs = SecurityRuleArgs(
        access = access,
        description = description,
        destinationAddressPrefix = destinationAddressPrefix,
        destinationAddressPrefixes = destinationAddressPrefixes,
        destinationApplicationSecurityGroups = destinationApplicationSecurityGroups,
        destinationPortRange = destinationPortRange,
        destinationPortRanges = destinationPortRanges,
        direction = direction,
        id = id,
        name = name,
        networkSecurityGroupName = networkSecurityGroupName,
        priority = priority,
        protocol = protocol,
        resourceGroupName = resourceGroupName,
        securityRuleName = securityRuleName,
        sourceAddressPrefix = sourceAddressPrefix,
        sourceAddressPrefixes = sourceAddressPrefixes,
        sourceApplicationSecurityGroups = sourceApplicationSecurityGroups,
        sourcePortRange = sourcePortRange,
        sourcePortRanges = sourcePortRanges,
        type = type,
    )
}
