@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.StaticMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * StaticMember Item.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-02-01-preview.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### StaticMemberPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticMember = new AzureNative.Network.StaticMember("staticMember", new()
 *     {
 *         NetworkGroupName = "testNetworkGroup",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroup/rg1/providers/Microsoft.Network/virtualnetworks/vnet1",
 *         StaticMemberName = "testStaticMember",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewStaticMember(ctx, "staticMember", &network.StaticMemberArgs{
 * 			NetworkGroupName:   pulumi.String("testNetworkGroup"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			ResourceId:         pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroup/rg1/providers/Microsoft.Network/virtualnetworks/vnet1"),
 * 			StaticMemberName:   pulumi.String("testStaticMember"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.StaticMember;
 * import com.pulumi.azurenative.network.StaticMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticMember = new StaticMember("staticMember", StaticMemberArgs.builder()
 *             .networkGroupName("testNetworkGroup")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .resourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroup/rg1/providers/Microsoft.Network/virtualnetworks/vnet1")
 *             .staticMemberName("testStaticMember")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:StaticMember testStaticMember /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/networkGroups/{networkGroupName}/staticMembers/{staticMemberName}
 * ```
 * @property networkGroupName The name of the network group.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property resourceId Resource Id.
 * @property staticMemberName The name of the static member.
 */
public data class StaticMemberArgs(
    public val networkGroupName: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val staticMemberName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.StaticMemberArgs> {
    override fun toJava(): com.pulumi.azurenative.network.StaticMemberArgs =
        com.pulumi.azurenative.network.StaticMemberArgs.builder()
            .networkGroupName(networkGroupName?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .staticMemberName(staticMemberName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticMemberArgs].
 */
@PulumiTagMarker
public class StaticMemberArgsBuilder internal constructor() {
    private var networkGroupName: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var staticMemberName: Output<String>? = null

    /**
     * @param value The name of the network group.
     */
    @JvmName("pacrnqmuwpwhsfky")
    public suspend fun networkGroupName(`value`: Output<String>) {
        this.networkGroupName = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("saqudakpvnnnqjit")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nkagdnxfyxgxniie")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource Id.
     */
    @JvmName("exdlgfbjmcvpyjgs")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The name of the static member.
     */
    @JvmName("qipkymygvtxuetkm")
    public suspend fun staticMemberName(`value`: Output<String>) {
        this.staticMemberName = value
    }

    /**
     * @param value The name of the network group.
     */
    @JvmName("lcnidnortgwvcmsk")
    public suspend fun networkGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkGroupName = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("doovbuspdnyfkhwv")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cvkljlhcchyvftwx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource Id.
     */
    @JvmName("sbcqdjykxbwlrqgl")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The name of the static member.
     */
    @JvmName("plslsfryggyfoifp")
    public suspend fun staticMemberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticMemberName = mapped
    }

    internal fun build(): StaticMemberArgs = StaticMemberArgs(
        networkGroupName = networkGroupName,
        networkManagerName = networkManagerName,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        staticMemberName = staticMemberName,
    )
}
