@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.SubnetArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPrivateEndpointNetworkPolicies
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPrivateLinkServiceNetworkPolicies
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationGatewayIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.DelegationArgs
import com.pulumi.azurenative.network.kotlin.inputs.DelegationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.NetworkSecurityGroupArgs
import com.pulumi.azurenative.network.kotlin.inputs.NetworkSecurityGroupArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.RouteTableArgs
import com.pulumi.azurenative.network.kotlin.inputs.RouteTableArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ServiceEndpointPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.ServiceEndpointPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ServiceEndpointPropertiesFormatArgs
import com.pulumi.azurenative.network.kotlin.inputs.ServiceEndpointPropertiesFormatArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Subnet in a virtual network resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2016-03-30, 2019-02-01, 2019-06-01, 2019-08-01, 2020-06-01, 2022-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subnet = new AzureNative.Network.Subnet("subnet", new()
 *     {
 *         AddressPrefix = "10.0.0.0/16",
 *         ResourceGroupName = "subnet-test",
 *         SubnetName = "subnet1",
 *         VirtualNetworkName = "vnetname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSubnet(ctx, "subnet", &network.SubnetArgs{
 * 			AddressPrefix:      pulumi.String("10.0.0.0/16"),
 * 			ResourceGroupName:  pulumi.String("subnet-test"),
 * 			SubnetName:         pulumi.String("subnet1"),
 * 			VirtualNetworkName: pulumi.String("vnetname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Subnet;
 * import com.pulumi.azurenative.network.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subnet = new Subnet("subnet", SubnetArgs.builder()
 *             .addressPrefix("10.0.0.0/16")
 *             .resourceGroupName("subnet-test")
 *             .subnetName("subnet1")
 *             .virtualNetworkName("vnetname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create subnet with a delegation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subnet = new AzureNative.Network.Subnet("subnet", new()
 *     {
 *         AddressPrefix = "10.0.0.0/16",
 *         ResourceGroupName = "subnet-test",
 *         SubnetName = "subnet1",
 *         VirtualNetworkName = "vnetname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSubnet(ctx, "subnet", &network.SubnetArgs{
 * 			AddressPrefix:      pulumi.String("10.0.0.0/16"),
 * 			ResourceGroupName:  pulumi.String("subnet-test"),
 * 			SubnetName:         pulumi.String("subnet1"),
 * 			VirtualNetworkName: pulumi.String("vnetname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Subnet;
 * import com.pulumi.azurenative.network.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subnet = new Subnet("subnet", SubnetArgs.builder()
 *             .addressPrefix("10.0.0.0/16")
 *             .resourceGroupName("subnet-test")
 *             .subnetName("subnet1")
 *             .virtualNetworkName("vnetname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create subnet with service endpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subnet = new AzureNative.Network.Subnet("subnet", new()
 *     {
 *         AddressPrefix = "10.0.0.0/16",
 *         ResourceGroupName = "subnet-test",
 *         ServiceEndpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.ServiceEndpointPropertiesFormatArgs
 *             {
 *                 Service = "Microsoft.Storage",
 *             },
 *         },
 *         SubnetName = "subnet1",
 *         VirtualNetworkName = "vnetname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSubnet(ctx, "subnet", &network.SubnetArgs{
 * 			AddressPrefix:     pulumi.String("10.0.0.0/16"),
 * 			ResourceGroupName: pulumi.String("subnet-test"),
 * 			ServiceEndpoints: network.ServiceEndpointPropertiesFormatArray{
 * 				&network.ServiceEndpointPropertiesFormatArgs{
 * 					Service: pulumi.String("Microsoft.Storage"),
 * 				},
 * 			},
 * 			SubnetName:         pulumi.String("subnet1"),
 * 			VirtualNetworkName: pulumi.String("vnetname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Subnet;
 * import com.pulumi.azurenative.network.SubnetArgs;
 * import com.pulumi.azurenative.network.inputs.ServiceEndpointPropertiesFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subnet = new Subnet("subnet", SubnetArgs.builder()
 *             .addressPrefix("10.0.0.0/16")
 *             .resourceGroupName("subnet-test")
 *             .serviceEndpoints(ServiceEndpointPropertiesFormatArgs.builder()
 *                 .service("Microsoft.Storage")
 *                 .build())
 *             .subnetName("subnet1")
 *             .virtualNetworkName("vnetname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Subnet subnet1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
 * ```
 * @property addressPrefix The address prefix for the subnet.
 * @property addressPrefixes List of address prefixes for the subnet.
 * @property applicationGatewayIPConfigurations Application gateway IP configurations of virtual network resource.
 * @property delegations An array of references to the delegations on the subnet.
 * @property id Resource ID.
 * @property ipAllocations Array of IpAllocation which reference this subnet.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property natGateway Nat gateway associated with this subnet.
 * @property networkSecurityGroup The reference to the NetworkSecurityGroup resource.
 * @property privateEndpointNetworkPolicies Enable or Disable apply network policies on private end point in the subnet.
 * @property privateLinkServiceNetworkPolicies Enable or Disable apply network policies on private link service in the subnet.
 * @property resourceGroupName The name of the resource group.
 * @property routeTable The reference to the RouteTable resource.
 * @property serviceEndpointPolicies An array of service endpoint policies.
 * @property serviceEndpoints An array of service endpoints.
 * @property subnetName The name of the subnet.
 * @property type Resource type.
 * @property virtualNetworkName The name of the virtual network.
 */
public data class SubnetArgs(
    public val addressPrefix: Output<String>? = null,
    public val addressPrefixes: Output<List<String>>? = null,
    public val applicationGatewayIPConfigurations: Output<List<ApplicationGatewayIPConfigurationArgs>>? = null,
    public val delegations: Output<List<DelegationArgs>>? = null,
    public val id: Output<String>? = null,
    public val ipAllocations: Output<List<SubResourceArgs>>? = null,
    public val name: Output<String>? = null,
    public val natGateway: Output<SubResourceArgs>? = null,
    public val networkSecurityGroup: Output<NetworkSecurityGroupArgs>? = null,
    public val privateEndpointNetworkPolicies: Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>? = null,
    public val privateLinkServiceNetworkPolicies: Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeTable: Output<RouteTableArgs>? = null,
    public val serviceEndpointPolicies: Output<List<ServiceEndpointPolicyArgs>>? = null,
    public val serviceEndpoints: Output<List<ServiceEndpointPropertiesFormatArgs>>? = null,
    public val subnetName: Output<String>? = null,
    public val type: Output<String>? = null,
    public val virtualNetworkName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.SubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.SubnetArgs =
        com.pulumi.azurenative.network.SubnetArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .applicationGatewayIPConfigurations(
                applicationGatewayIPConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .delegations(
                delegations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ipAllocations(
                ipAllocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .natGateway(natGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkSecurityGroup(
                networkSecurityGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .privateEndpointNetworkPolicies(
                privateEndpointNetworkPolicies?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateLinkServiceNetworkPolicies(
                privateLinkServiceNetworkPolicies?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeTable(routeTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceEndpointPolicies(
                serviceEndpointPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceEndpoints(
                serviceEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnetName(subnetName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
public class SubnetArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var addressPrefixes: Output<List<String>>? = null

    private var applicationGatewayIPConfigurations:
        Output<List<ApplicationGatewayIPConfigurationArgs>>? = null

    private var delegations: Output<List<DelegationArgs>>? = null

    private var id: Output<String>? = null

    private var ipAllocations: Output<List<SubResourceArgs>>? = null

    private var name: Output<String>? = null

    private var natGateway: Output<SubResourceArgs>? = null

    private var networkSecurityGroup: Output<NetworkSecurityGroupArgs>? = null

    private var privateEndpointNetworkPolicies:
        Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>? = null

    private var privateLinkServiceNetworkPolicies:
        Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeTable: Output<RouteTableArgs>? = null

    private var serviceEndpointPolicies: Output<List<ServiceEndpointPolicyArgs>>? = null

    private var serviceEndpoints: Output<List<ServiceEndpointPropertiesFormatArgs>>? = null

    private var subnetName: Output<String>? = null

    private var type: Output<String>? = null

    private var virtualNetworkName: Output<String>? = null

    /**
     * @param value The address prefix for the subnet.
     */
    @JvmName("ajtsdwvjeuxdlwuq")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value List of address prefixes for the subnet.
     */
    @JvmName("kkwuvtsyjiiotkax")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("sygeleeibdmrsjyw")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of address prefixes for the subnet.
     */
    @JvmName("iqfvgbcmpiqgofea")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value Application gateway IP configurations of virtual network resource.
     */
    @JvmName("uawkawbiibxdxoro")
    public suspend fun applicationGatewayIPConfigurations(`value`: Output<List<ApplicationGatewayIPConfigurationArgs>>) {
        this.applicationGatewayIPConfigurations = value
    }

    @JvmName("faamrsuxxsvjndmt")
    public suspend fun applicationGatewayIPConfigurations(vararg values: Output<ApplicationGatewayIPConfigurationArgs>) {
        this.applicationGatewayIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Application gateway IP configurations of virtual network resource.
     */
    @JvmName("tdxdjvlwuccqsmuw")
    public suspend fun applicationGatewayIPConfigurations(values: List<Output<ApplicationGatewayIPConfigurationArgs>>) {
        this.applicationGatewayIPConfigurations = Output.all(values)
    }

    /**
     * @param value An array of references to the delegations on the subnet.
     */
    @JvmName("fqqyxxlrlxihxdmy")
    public suspend fun delegations(`value`: Output<List<DelegationArgs>>) {
        this.delegations = value
    }

    @JvmName("jqjkvhfxgfprjvjy")
    public suspend fun delegations(vararg values: Output<DelegationArgs>) {
        this.delegations = Output.all(values.asList())
    }

    /**
     * @param values An array of references to the delegations on the subnet.
     */
    @JvmName("sofvqlvovubdkaiq")
    public suspend fun delegations(values: List<Output<DelegationArgs>>) {
        this.delegations = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("iwjcheqmkcuiykne")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Array of IpAllocation which reference this subnet.
     */
    @JvmName("gvygieweryyejrtm")
    public suspend fun ipAllocations(`value`: Output<List<SubResourceArgs>>) {
        this.ipAllocations = value
    }

    @JvmName("knefthhgbnrullxv")
    public suspend fun ipAllocations(vararg values: Output<SubResourceArgs>) {
        this.ipAllocations = Output.all(values.asList())
    }

    /**
     * @param values Array of IpAllocation which reference this subnet.
     */
    @JvmName("psfqdkebfggdjynw")
    public suspend fun ipAllocations(values: List<Output<SubResourceArgs>>) {
        this.ipAllocations = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("vexppbtbqepjsgfb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Nat gateway associated with this subnet.
     */
    @JvmName("tleqpvpbwaxsniow")
    public suspend fun natGateway(`value`: Output<SubResourceArgs>) {
        this.natGateway = value
    }

    /**
     * @param value The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("gcfwhwbpqrnloynq")
    public suspend fun networkSecurityGroup(`value`: Output<NetworkSecurityGroupArgs>) {
        this.networkSecurityGroup = value
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("ynbxphyksnbkadsv")
    public suspend fun privateEndpointNetworkPolicies(`value`: Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>) {
        this.privateEndpointNetworkPolicies = value
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("fmuhdrcmwlginyyt")
    public suspend fun privateLinkServiceNetworkPolicies(`value`: Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>) {
        this.privateLinkServiceNetworkPolicies = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eypsadghfvkyxpiy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The reference to the RouteTable resource.
     */
    @JvmName("tpabjbgkshdnrsny")
    public suspend fun routeTable(`value`: Output<RouteTableArgs>) {
        this.routeTable = value
    }

    /**
     * @param value An array of service endpoint policies.
     */
    @JvmName("pqemvcwxoaidokbm")
    public suspend fun serviceEndpointPolicies(`value`: Output<List<ServiceEndpointPolicyArgs>>) {
        this.serviceEndpointPolicies = value
    }

    @JvmName("gaxsgustjplwohme")
    public suspend fun serviceEndpointPolicies(vararg values: Output<ServiceEndpointPolicyArgs>) {
        this.serviceEndpointPolicies = Output.all(values.asList())
    }

    /**
     * @param values An array of service endpoint policies.
     */
    @JvmName("ukolprybbcurqfpl")
    public suspend fun serviceEndpointPolicies(values: List<Output<ServiceEndpointPolicyArgs>>) {
        this.serviceEndpointPolicies = Output.all(values)
    }

    /**
     * @param value An array of service endpoints.
     */
    @JvmName("autumklrijovovyw")
    public suspend fun serviceEndpoints(`value`: Output<List<ServiceEndpointPropertiesFormatArgs>>) {
        this.serviceEndpoints = value
    }

    @JvmName("elsaeukyrrmvtjrb")
    public suspend fun serviceEndpoints(vararg values: Output<ServiceEndpointPropertiesFormatArgs>) {
        this.serviceEndpoints = Output.all(values.asList())
    }

    /**
     * @param values An array of service endpoints.
     */
    @JvmName("nlcdckxnyswuwsqx")
    public suspend fun serviceEndpoints(values: List<Output<ServiceEndpointPropertiesFormatArgs>>) {
        this.serviceEndpoints = Output.all(values)
    }

    /**
     * @param value The name of the subnet.
     */
    @JvmName("cuaxeifadfusdjno")
    public suspend fun subnetName(`value`: Output<String>) {
        this.subnetName = value
    }

    /**
     * @param value Resource type.
     */
    @JvmName("fgmewwekfjekaaqi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("fyexirgjodyxmhyk")
    public suspend fun virtualNetworkName(`value`: Output<String>) {
        this.virtualNetworkName = value
    }

    /**
     * @param value The address prefix for the subnet.
     */
    @JvmName("dvpmftkvhtrcwdol")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value List of address prefixes for the subnet.
     */
    @JvmName("tsiklvorfqhtlfpy")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values List of address prefixes for the subnet.
     */
    @JvmName("tbdckjfbcqpuivqj")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param value Application gateway IP configurations of virtual network resource.
     */
    @JvmName("ocokfvhjyjvkpnmu")
    public suspend fun applicationGatewayIPConfigurations(`value`: List<ApplicationGatewayIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("nkpeidympxbtyvqc")
    public suspend fun applicationGatewayIPConfigurations(argument: List<suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("rggujjnkiptkpnvr")
    public suspend fun applicationGatewayIPConfigurations(vararg argument: suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("hfphmfsmxourmbel")
    public suspend fun applicationGatewayIPConfigurations(argument: suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param values Application gateway IP configurations of virtual network resource.
     */
    @JvmName("ccktxnabpghsgwas")
    public suspend fun applicationGatewayIPConfigurations(vararg values: ApplicationGatewayIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param value An array of references to the delegations on the subnet.
     */
    @JvmName("smirqirtqscuhnam")
    public suspend fun delegations(`value`: List<DelegationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("ujtrjbqcnnxyfmeg")
    public suspend fun delegations(argument: List<suspend DelegationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DelegationArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("sgybyqqvfkmtqthj")
    public suspend fun delegations(vararg argument: suspend DelegationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DelegationArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("jbhwngyejlamspam")
    public suspend fun delegations(argument: suspend DelegationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DelegationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param values An array of references to the delegations on the subnet.
     */
    @JvmName("odemlakwapfixtdp")
    public suspend fun delegations(vararg values: DelegationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.delegations = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("abqrnabonmfpmjdl")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Array of IpAllocation which reference this subnet.
     */
    @JvmName("kyyiaqhfbwhllkiu")
    public suspend fun ipAllocations(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("ypsmycqytolourby")
    public suspend fun ipAllocations(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("uqxkikuslvpapven")
    public suspend fun ipAllocations(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("mmeltpowsolcoxvo")
    public suspend fun ipAllocations(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param values Array of IpAllocation which reference this subnet.
     */
    @JvmName("hjdtyfuopaehjvsh")
    public suspend fun ipAllocations(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocations = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("cjlwcvenyhcupqmc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Nat gateway associated with this subnet.
     */
    @JvmName("ucyedqshucthfdmr")
    public suspend fun natGateway(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGateway = mapped
    }

    /**
     * @param argument Nat gateway associated with this subnet.
     */
    @JvmName("ejpehylusuxsbvjf")
    public suspend fun natGateway(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.natGateway = mapped
    }

    /**
     * @param value The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("gdkkxbrthdajfqoy")
    public suspend fun networkSecurityGroup(`value`: NetworkSecurityGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroup = mapped
    }

    /**
     * @param argument The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("dyrnixmorguvjdjk")
    public suspend fun networkSecurityGroup(argument: suspend NetworkSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkSecurityGroupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSecurityGroup = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("ilesdhegwnjvdviw")
    public suspend fun privateEndpointNetworkPolicies(`value`: Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("nkdeacslfvgbhptf")
    public fun privateEndpointNetworkPolicies(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPrivateEndpointNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("fitujowudtfckgnc")
    public fun privateEndpointNetworkPolicies(`value`: VirtualNetworkPrivateEndpointNetworkPolicies) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPrivateEndpointNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("bxffwgpqxotfwtty")
    public suspend fun privateLinkServiceNetworkPolicies(`value`: Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("amdcrewijsdhycvr")
    public fun privateLinkServiceNetworkPolicies(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("yghrliwnlmusqffa")
    public fun privateLinkServiceNetworkPolicies(`value`: VirtualNetworkPrivateLinkServiceNetworkPolicies) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sxkfvmbqwdhbsmrs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The reference to the RouteTable resource.
     */
    @JvmName("cfyogksecrfouwol")
    public suspend fun routeTable(`value`: RouteTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTable = mapped
    }

    /**
     * @param argument The reference to the RouteTable resource.
     */
    @JvmName("ieeqoswhkbwkoywp")
    public suspend fun routeTable(argument: suspend RouteTableArgsBuilder.() -> Unit) {
        val toBeMapped = RouteTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routeTable = mapped
    }

    /**
     * @param value An array of service endpoint policies.
     */
    @JvmName("endanyuwgmfosxtd")
    public suspend fun serviceEndpointPolicies(`value`: List<ServiceEndpointPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("oqkaxsxhafmujvjy")
    public suspend fun serviceEndpointPolicies(argument: List<suspend ServiceEndpointPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("gkduwuqpfrmryjfq")
    public suspend fun serviceEndpointPolicies(vararg argument: suspend ServiceEndpointPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("jjruschpvrecljky")
    public suspend fun serviceEndpointPolicies(argument: suspend ServiceEndpointPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceEndpointPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param values An array of service endpoint policies.
     */
    @JvmName("owmuhvtxnptqrwnw")
    public suspend fun serviceEndpointPolicies(vararg values: ServiceEndpointPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param value An array of service endpoints.
     */
    @JvmName("jdqgjnxfutbbjixd")
    public suspend fun serviceEndpoints(`value`: List<ServiceEndpointPropertiesFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("poetvjwgrjyklody")
    public suspend fun serviceEndpoints(argument: List<suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("lnpscvmagcodpoxl")
    public suspend fun serviceEndpoints(vararg argument: suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("ljkhyctfgqvqjptl")
    public suspend fun serviceEndpoints(argument: suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param values An array of service endpoints.
     */
    @JvmName("fphvaadpocbtrqef")
    public suspend fun serviceEndpoints(vararg values: ServiceEndpointPropertiesFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param value The name of the subnet.
     */
    @JvmName("jgpqfoebdwnohwee")
    public suspend fun subnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetName = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("laciqpiyapylbqpc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("auatejekbbmyfvqt")
    public suspend fun virtualNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkName = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        addressPrefix = addressPrefix,
        addressPrefixes = addressPrefixes,
        applicationGatewayIPConfigurations = applicationGatewayIPConfigurations,
        delegations = delegations,
        id = id,
        ipAllocations = ipAllocations,
        name = name,
        natGateway = natGateway,
        networkSecurityGroup = networkSecurityGroup,
        privateEndpointNetworkPolicies = privateEndpointNetworkPolicies,
        privateLinkServiceNetworkPolicies = privateLinkServiceNetworkPolicies,
        resourceGroupName = resourceGroupName,
        routeTable = routeTable,
        serviceEndpointPolicies = serviceEndpointPolicies,
        serviceEndpoints = serviceEndpoints,
        subnetName = subnetName,
        type = type,
        virtualNetworkName = virtualNetworkName,
    )
}
