@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteTableResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteTableV2Response
import com.pulumi.azurenative.network.kotlin.outputs.VirtualRouterAutoScaleConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteTableResponse.Companion.toKotlin as virtualHubRouteTableResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteTableV2Response.Companion.toKotlin as virtualHubRouteTableV2ResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualRouterAutoScaleConfigurationResponse.Companion.toKotlin as virtualRouterAutoScaleConfigurationResponseToKotlin

/**
 * Builder for [VirtualHub].
 */
@PulumiTagMarker
public class VirtualHubResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualHubArgs = VirtualHubArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualHubArgsBuilder.() -> Unit) {
        val builder = VirtualHubArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualHub {
        val builtJavaResource = com.pulumi.azurenative.network.VirtualHub(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualHub(builtJavaResource)
    }
}

/**
 * VirtualHub Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2020-04-01, 2020-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### VirtualHubPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHub = new AzureNative.Network.VirtualHub("virtualHub", new()
 *     {
 *         AddressPrefix = "10.168.0.0/24",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Sku = "Basic",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHubName = "virtualHub2",
 *         VirtualWan = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWans/virtualWan1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualHub(ctx, "virtualHub", &network.VirtualHubArgs{
 * 			AddressPrefix:     pulumi.String("10.168.0.0/24"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku:               pulumi.String("Basic"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub2"),
 * 			VirtualWan: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWans/virtualWan1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualHub;
 * import com.pulumi.azurenative.network.VirtualHubArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHub = new VirtualHub("virtualHub", VirtualHubArgs.builder()
 *             .addressPrefix("10.168.0.0/24")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .sku("Basic")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHubName("virtualHub2")
 *             .virtualWan(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWans/virtualWan1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualHub virtualHub2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}
 * ```
 */
public class VirtualHub internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualHub,
) : KotlinCustomResource(javaResource, VirtualHubMapper) {
    /**
     * Address-prefix for this VirtualHub.
     */
    public val addressPrefix: Output<String>?
        get() = javaResource.addressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to control transit for VirtualRouter hub.
     */
    public val allowBranchToBranchTraffic: Output<Boolean>?
        get() = javaResource.allowBranchToBranchTraffic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The azureFirewall associated with this VirtualHub.
     */
    public val azureFirewall: Output<SubResourceResponse>?
        get() = javaResource.azureFirewall().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of references to Bgp Connections.
     */
    public val bgpConnections: Output<List<SubResourceResponse>>
        get() = javaResource.bgpConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The expressRouteGateway associated with this VirtualHub.
     */
    public val expressRouteGateway: Output<SubResourceResponse>?
        get() = javaResource.expressRouteGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The hubRoutingPreference of this VirtualHub.
     */
    public val hubRoutingPreference: Output<String>?
        get() = javaResource.hubRoutingPreference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of references to IpConfigurations.
     */
    public val ipConfigurations: Output<List<SubResourceResponse>>
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * Kind of service virtual hub. This is metadata used for the Azure portal experience for Route Server.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The P2SVpnGateway associated with this VirtualHub.
     */
    public val p2SVpnGateway: Output<SubResourceResponse>?
        get() = javaResource.p2SVpnGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The preferred gateway to route on-prem traffic
     */
    public val preferredRoutingGateway: Output<String>?
        get() = javaResource.preferredRoutingGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the virtual hub resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of references to RouteMaps.
     */
    public val routeMaps: Output<List<SubResourceResponse>>
        get() = javaResource.routeMaps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            })
        })

    /**
     * The routeTable associated with this virtual hub.
     */
    public val routeTable: Output<VirtualHubRouteTableResponse>?
        get() = javaResource.routeTable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualHubRouteTableResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The routing state.
     */
    public val routingState: Output<String>
        get() = javaResource.routingState().applyValue({ args0 -> args0 })

    /**
     * The securityPartnerProvider associated with this VirtualHub.
     */
    public val securityPartnerProvider: Output<SubResourceResponse>?
        get() = javaResource.securityPartnerProvider().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Security Provider name.
     */
    public val securityProviderName: Output<String>?
        get() = javaResource.securityProviderName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The sku of this VirtualHub.
     */
    public val sku: Output<String>?
        get() = javaResource.sku().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of all virtual hub route table v2s associated with this VirtualHub.
     */
    public val virtualHubRouteTableV2s: Output<List<VirtualHubRouteTableV2Response>>?
        get() = javaResource.virtualHubRouteTableV2s().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        virtualHubRouteTableV2ResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * VirtualRouter ASN.
     */
    public val virtualRouterAsn: Output<Double>?
        get() = javaResource.virtualRouterAsn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The VirtualHub Router autoscale configuration.
     */
    public val virtualRouterAutoScaleConfiguration:
        Output<VirtualRouterAutoScaleConfigurationResponse>?
        get() = javaResource.virtualRouterAutoScaleConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualRouterAutoScaleConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * VirtualRouter IPs.
     */
    public val virtualRouterIps: Output<List<String>>?
        get() = javaResource.virtualRouterIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The VirtualWAN to which the VirtualHub belongs.
     */
    public val virtualWan: Output<SubResourceResponse>?
        get() = javaResource.virtualWan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The VpnGateway associated with this VirtualHub.
     */
    public val vpnGateway: Output<SubResourceResponse>?
        get() = javaResource.vpnGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object VirtualHubMapper : ResourceMapper<VirtualHub> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualHub::class == javaResource::class

    override fun map(javaResource: Resource): VirtualHub = VirtualHub(
        javaResource as
            com.pulumi.azurenative.network.VirtualHub,
    )
}

/**
 * @see [VirtualHub].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualHub].
 */
public suspend fun virtualHub(name: String, block: suspend VirtualHubResourceBuilder.() -> Unit): VirtualHub {
    val builder = VirtualHubResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualHub].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualHub(name: String): VirtualHub {
    val builder = VirtualHubResourceBuilder()
    builder.name(name)
    return builder.build()
}
