@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualHubArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.HubRoutingPreference
import com.pulumi.azurenative.network.kotlin.enums.PreferredRoutingGateway
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualHubRouteTableArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualHubRouteTableArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualHubRouteTableV2Args
import com.pulumi.azurenative.network.kotlin.inputs.VirtualHubRouteTableV2ArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualRouterAutoScaleConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualRouterAutoScaleConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VirtualHub Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2020-04-01, 2020-06-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### VirtualHubPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHub = new AzureNative.Network.VirtualHub("virtualHub", new()
 *     {
 *         AddressPrefix = "10.168.0.0/24",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Sku = "Basic",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHubName = "virtualHub2",
 *         VirtualWan = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWans/virtualWan1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualHub(ctx, "virtualHub", &network.VirtualHubArgs{
 * 			AddressPrefix:     pulumi.String("10.168.0.0/24"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku:               pulumi.String("Basic"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub2"),
 * 			VirtualWan: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWans/virtualWan1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualHub;
 * import com.pulumi.azurenative.network.VirtualHubArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHub = new VirtualHub("virtualHub", VirtualHubArgs.builder()
 *             .addressPrefix("10.168.0.0/24")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .sku("Basic")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHubName("virtualHub2")
 *             .virtualWan(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWans/virtualWan1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualHub virtualHub2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}
 * ```
 * @property addressPrefix Address-prefix for this VirtualHub.
 * @property allowBranchToBranchTraffic Flag to control transit for VirtualRouter hub.
 * @property azureFirewall The azureFirewall associated with this VirtualHub.
 * @property expressRouteGateway The expressRouteGateway associated with this VirtualHub.
 * @property hubRoutingPreference The hubRoutingPreference of this VirtualHub.
 * @property id Resource ID.
 * @property location Resource location.
 * @property p2SVpnGateway The P2SVpnGateway associated with this VirtualHub.
 * @property preferredRoutingGateway The preferred gateway to route on-prem traffic
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property routeTable The routeTable associated with this virtual hub.
 * @property securityPartnerProvider The securityPartnerProvider associated with this VirtualHub.
 * @property securityProviderName The Security Provider name.
 * @property sku The sku of this VirtualHub.
 * @property tags Resource tags.
 * @property virtualHubName The name of the VirtualHub.
 * @property virtualHubRouteTableV2s List of all virtual hub route table v2s associated with this VirtualHub.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property virtualRouterAsn VirtualRouter ASN.
 * @property virtualRouterAutoScaleConfiguration The VirtualHub Router autoscale configuration.
 * @property virtualRouterIps VirtualRouter IPs.
 * @property virtualWan The VirtualWAN to which the VirtualHub belongs.
 * @property vpnGateway The VpnGateway associated with this VirtualHub.
 */
public data class VirtualHubArgs(
    public val addressPrefix: Output<String>? = null,
    public val allowBranchToBranchTraffic: Output<Boolean>? = null,
    public val azureFirewall: Output<SubResourceArgs>? = null,
    public val expressRouteGateway: Output<SubResourceArgs>? = null,
    public val hubRoutingPreference: Output<Either<String, HubRoutingPreference>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val p2SVpnGateway: Output<SubResourceArgs>? = null,
    public val preferredRoutingGateway: Output<Either<String, PreferredRoutingGateway>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeTable: Output<VirtualHubRouteTableArgs>? = null,
    public val securityPartnerProvider: Output<SubResourceArgs>? = null,
    public val securityProviderName: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualHubName: Output<String>? = null,
    public val virtualHubRouteTableV2s: Output<List<VirtualHubRouteTableV2Args>>? = null,
    public val virtualRouterAsn: Output<Double>? = null,
    public val virtualRouterAutoScaleConfiguration: Output<VirtualRouterAutoScaleConfigurationArgs>? =
        null,
    public val virtualRouterIps: Output<List<String>>? = null,
    public val virtualWan: Output<SubResourceArgs>? = null,
    public val vpnGateway: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualHubArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualHubArgs =
        com.pulumi.azurenative.network.VirtualHubArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .allowBranchToBranchTraffic(allowBranchToBranchTraffic?.applyValue({ args0 -> args0 }))
            .azureFirewall(azureFirewall?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .expressRouteGateway(
                expressRouteGateway?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hubRoutingPreference(
                hubRoutingPreference?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .p2SVpnGateway(p2SVpnGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preferredRoutingGateway(
                preferredRoutingGateway?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeTable(routeTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityPartnerProvider(
                securityPartnerProvider?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityProviderName(securityProviderName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualHubName(virtualHubName?.applyValue({ args0 -> args0 }))
            .virtualHubRouteTableV2s(
                virtualHubRouteTableV2s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualRouterAsn(virtualRouterAsn?.applyValue({ args0 -> args0 }))
            .virtualRouterAutoScaleConfiguration(
                virtualRouterAutoScaleConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .virtualRouterIps(virtualRouterIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .virtualWan(virtualWan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpnGateway(vpnGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualHubArgs].
 */
@PulumiTagMarker
public class VirtualHubArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var allowBranchToBranchTraffic: Output<Boolean>? = null

    private var azureFirewall: Output<SubResourceArgs>? = null

    private var expressRouteGateway: Output<SubResourceArgs>? = null

    private var hubRoutingPreference: Output<Either<String, HubRoutingPreference>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var p2SVpnGateway: Output<SubResourceArgs>? = null

    private var preferredRoutingGateway: Output<Either<String, PreferredRoutingGateway>>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeTable: Output<VirtualHubRouteTableArgs>? = null

    private var securityPartnerProvider: Output<SubResourceArgs>? = null

    private var securityProviderName: Output<String>? = null

    private var sku: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualHubName: Output<String>? = null

    private var virtualHubRouteTableV2s: Output<List<VirtualHubRouteTableV2Args>>? = null

    private var virtualRouterAsn: Output<Double>? = null

    private var virtualRouterAutoScaleConfiguration: Output<VirtualRouterAutoScaleConfigurationArgs>? =
        null

    private var virtualRouterIps: Output<List<String>>? = null

    private var virtualWan: Output<SubResourceArgs>? = null

    private var vpnGateway: Output<SubResourceArgs>? = null

    /**
     * @param value Address-prefix for this VirtualHub.
     */
    @JvmName("stlxnyjgoxcebnne")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value Flag to control transit for VirtualRouter hub.
     */
    @JvmName("ihxsqtuyrtfligrp")
    public suspend fun allowBranchToBranchTraffic(`value`: Output<Boolean>) {
        this.allowBranchToBranchTraffic = value
    }

    /**
     * @param value The azureFirewall associated with this VirtualHub.
     */
    @JvmName("ccqmlniahxcvjema")
    public suspend fun azureFirewall(`value`: Output<SubResourceArgs>) {
        this.azureFirewall = value
    }

    /**
     * @param value The expressRouteGateway associated with this VirtualHub.
     */
    @JvmName("umckadaqmrrqswoi")
    public suspend fun expressRouteGateway(`value`: Output<SubResourceArgs>) {
        this.expressRouteGateway = value
    }

    /**
     * @param value The hubRoutingPreference of this VirtualHub.
     */
    @JvmName("guvfrbsubyjrmaca")
    public suspend fun hubRoutingPreference(`value`: Output<Either<String, HubRoutingPreference>>) {
        this.hubRoutingPreference = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dutrnjuijwlhhprq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hkpwcioeapqjoxnr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The P2SVpnGateway associated with this VirtualHub.
     */
    @JvmName("iqotnumxfwrwblay")
    public suspend fun p2SVpnGateway(`value`: Output<SubResourceArgs>) {
        this.p2SVpnGateway = value
    }

    /**
     * @param value The preferred gateway to route on-prem traffic
     */
    @JvmName("kkmnmhgblsdpbsct")
    public suspend fun preferredRoutingGateway(`value`: Output<Either<String, PreferredRoutingGateway>>) {
        this.preferredRoutingGateway = value
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("gdaeiphvpuhaulys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The routeTable associated with this virtual hub.
     */
    @JvmName("lojuqxlrsnpibawg")
    public suspend fun routeTable(`value`: Output<VirtualHubRouteTableArgs>) {
        this.routeTable = value
    }

    /**
     * @param value The securityPartnerProvider associated with this VirtualHub.
     */
    @JvmName("wferokojiqijuhpj")
    public suspend fun securityPartnerProvider(`value`: Output<SubResourceArgs>) {
        this.securityPartnerProvider = value
    }

    /**
     * @param value The Security Provider name.
     */
    @JvmName("msnjkguirssprghe")
    public suspend fun securityProviderName(`value`: Output<String>) {
        this.securityProviderName = value
    }

    /**
     * @param value The sku of this VirtualHub.
     */
    @JvmName("tvrerhgmflaiejux")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("psrkhfjkwykrtxvj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("nsphrfribuacgwib")
    public suspend fun virtualHubName(`value`: Output<String>) {
        this.virtualHubName = value
    }

    /**
     * @param value List of all virtual hub route table v2s associated with this VirtualHub.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bcwqkatnlyehxykd")
    public suspend fun virtualHubRouteTableV2s(`value`: Output<List<VirtualHubRouteTableV2Args>>) {
        this.virtualHubRouteTableV2s = value
    }

    @JvmName("ubodqhvshmhwcolo")
    public suspend fun virtualHubRouteTableV2s(vararg values: Output<VirtualHubRouteTableV2Args>) {
        this.virtualHubRouteTableV2s = Output.all(values.asList())
    }

    /**
     * @param values List of all virtual hub route table v2s associated with this VirtualHub.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("eniltroocjnsgebs")
    public suspend fun virtualHubRouteTableV2s(values: List<Output<VirtualHubRouteTableV2Args>>) {
        this.virtualHubRouteTableV2s = Output.all(values)
    }

    /**
     * @param value VirtualRouter ASN.
     */
    @JvmName("ffqyyhgsxkklpyyp")
    public suspend fun virtualRouterAsn(`value`: Output<Double>) {
        this.virtualRouterAsn = value
    }

    /**
     * @param value The VirtualHub Router autoscale configuration.
     */
    @JvmName("rnqngvtdmaikaauu")
    public suspend fun virtualRouterAutoScaleConfiguration(`value`: Output<VirtualRouterAutoScaleConfigurationArgs>) {
        this.virtualRouterAutoScaleConfiguration = value
    }

    /**
     * @param value VirtualRouter IPs.
     */
    @JvmName("lcsbudavacxwwotu")
    public suspend fun virtualRouterIps(`value`: Output<List<String>>) {
        this.virtualRouterIps = value
    }

    @JvmName("qaarkftuqunyxdfg")
    public suspend fun virtualRouterIps(vararg values: Output<String>) {
        this.virtualRouterIps = Output.all(values.asList())
    }

    /**
     * @param values VirtualRouter IPs.
     */
    @JvmName("bkespctegmvbogob")
    public suspend fun virtualRouterIps(values: List<Output<String>>) {
        this.virtualRouterIps = Output.all(values)
    }

    /**
     * @param value The VirtualWAN to which the VirtualHub belongs.
     */
    @JvmName("oywpfhvvwfrgmscj")
    public suspend fun virtualWan(`value`: Output<SubResourceArgs>) {
        this.virtualWan = value
    }

    /**
     * @param value The VpnGateway associated with this VirtualHub.
     */
    @JvmName("xjngncqachxlsjuo")
    public suspend fun vpnGateway(`value`: Output<SubResourceArgs>) {
        this.vpnGateway = value
    }

    /**
     * @param value Address-prefix for this VirtualHub.
     */
    @JvmName("wmtmwybvdvruqdvo")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value Flag to control transit for VirtualRouter hub.
     */
    @JvmName("cbdnocamdpwdyrbu")
    public suspend fun allowBranchToBranchTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowBranchToBranchTraffic = mapped
    }

    /**
     * @param value The azureFirewall associated with this VirtualHub.
     */
    @JvmName("gpnsvkjrfgadkanp")
    public suspend fun azureFirewall(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFirewall = mapped
    }

    /**
     * @param argument The azureFirewall associated with this VirtualHub.
     */
    @JvmName("wopqwjowsjohtbdb")
    public suspend fun azureFirewall(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureFirewall = mapped
    }

    /**
     * @param value The expressRouteGateway associated with this VirtualHub.
     */
    @JvmName("ryrissafpokyynmn")
    public suspend fun expressRouteGateway(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteGateway = mapped
    }

    /**
     * @param argument The expressRouteGateway associated with this VirtualHub.
     */
    @JvmName("diltkilvmueemoft")
    public suspend fun expressRouteGateway(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expressRouteGateway = mapped
    }

    /**
     * @param value The hubRoutingPreference of this VirtualHub.
     */
    @JvmName("aeoxymybjqsungpm")
    public suspend fun hubRoutingPreference(`value`: Either<String, HubRoutingPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubRoutingPreference = mapped
    }

    /**
     * @param value The hubRoutingPreference of this VirtualHub.
     */
    @JvmName("wexgucuogtkukbbn")
    public fun hubRoutingPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HubRoutingPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hubRoutingPreference = mapped
    }

    /**
     * @param value The hubRoutingPreference of this VirtualHub.
     */
    @JvmName("krpthciuayaappdf")
    public fun hubRoutingPreference(`value`: HubRoutingPreference) {
        val toBeMapped = Either.ofRight<String, HubRoutingPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hubRoutingPreference = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("esdrjygxwopguktu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gwrmuwilhegdvwoa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The P2SVpnGateway associated with this VirtualHub.
     */
    @JvmName("kcubkwkhlqmatxeb")
    public suspend fun p2SVpnGateway(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.p2SVpnGateway = mapped
    }

    /**
     * @param argument The P2SVpnGateway associated with this VirtualHub.
     */
    @JvmName("ahswipppbbgdqsdu")
    public suspend fun p2SVpnGateway(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.p2SVpnGateway = mapped
    }

    /**
     * @param value The preferred gateway to route on-prem traffic
     */
    @JvmName("jgatforhpdxqjwwh")
    public suspend fun preferredRoutingGateway(`value`: Either<String, PreferredRoutingGateway>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredRoutingGateway = mapped
    }

    /**
     * @param value The preferred gateway to route on-prem traffic
     */
    @JvmName("igkcnyxnocxfgoow")
    public fun preferredRoutingGateway(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreferredRoutingGateway>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredRoutingGateway = mapped
    }

    /**
     * @param value The preferred gateway to route on-prem traffic
     */
    @JvmName("ewkautdmbdnitljk")
    public fun preferredRoutingGateway(`value`: PreferredRoutingGateway) {
        val toBeMapped = Either.ofRight<String, PreferredRoutingGateway>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredRoutingGateway = mapped
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("ypitwbogwqilbtbp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The routeTable associated with this virtual hub.
     */
    @JvmName("odmuktrkojylwhyy")
    public suspend fun routeTable(`value`: VirtualHubRouteTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTable = mapped
    }

    /**
     * @param argument The routeTable associated with this virtual hub.
     */
    @JvmName("vlvdjbctysixkaun")
    public suspend fun routeTable(argument: suspend VirtualHubRouteTableArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualHubRouteTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routeTable = mapped
    }

    /**
     * @param value The securityPartnerProvider associated with this VirtualHub.
     */
    @JvmName("ufdafyihohsgnudw")
    public suspend fun securityPartnerProvider(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPartnerProvider = mapped
    }

    /**
     * @param argument The securityPartnerProvider associated with this VirtualHub.
     */
    @JvmName("kfkwwxppkrkbeaqr")
    public suspend fun securityPartnerProvider(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityPartnerProvider = mapped
    }

    /**
     * @param value The Security Provider name.
     */
    @JvmName("kyqwsuaubgdqfuck")
    public suspend fun securityProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProviderName = mapped
    }

    /**
     * @param value The sku of this VirtualHub.
     */
    @JvmName("woriqcopkqmmhrgg")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wwunkkgqqdtxkdjt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dmsfdseckjwgesvr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("dypoafqvbinlvahg")
    public suspend fun virtualHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubName = mapped
    }

    /**
     * @param value List of all virtual hub route table v2s associated with this VirtualHub.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("vrqvntpellyffpch")
    public suspend fun virtualHubRouteTableV2s(`value`: List<VirtualHubRouteTableV2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubRouteTableV2s = mapped
    }

    /**
     * @param argument List of all virtual hub route table v2s associated with this VirtualHub.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("tpfinwbmoliqpwuq")
    public suspend fun virtualHubRouteTableV2s(argument: List<suspend VirtualHubRouteTableV2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualHubRouteTableV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualHubRouteTableV2s = mapped
    }

    /**
     * @param argument List of all virtual hub route table v2s associated with this VirtualHub.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pefdhwayyntgfmrt")
    public suspend fun virtualHubRouteTableV2s(vararg argument: suspend VirtualHubRouteTableV2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualHubRouteTableV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualHubRouteTableV2s = mapped
    }

    /**
     * @param argument List of all virtual hub route table v2s associated with this VirtualHub.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ofqilcvgnlewdsub")
    public suspend fun virtualHubRouteTableV2s(argument: suspend VirtualHubRouteTableV2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualHubRouteTableV2ArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualHubRouteTableV2s = mapped
    }

    /**
     * @param values List of all virtual hub route table v2s associated with this VirtualHub.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ayxajqsftqioepuy")
    public suspend fun virtualHubRouteTableV2s(vararg values: VirtualHubRouteTableV2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualHubRouteTableV2s = mapped
    }

    /**
     * @param value VirtualRouter ASN.
     */
    @JvmName("etiyqfnrvwlttcmf")
    public suspend fun virtualRouterAsn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualRouterAsn = mapped
    }

    /**
     * @param value The VirtualHub Router autoscale configuration.
     */
    @JvmName("cfnjfcvhhstycyyk")
    public suspend fun virtualRouterAutoScaleConfiguration(`value`: VirtualRouterAutoScaleConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualRouterAutoScaleConfiguration = mapped
    }

    /**
     * @param argument The VirtualHub Router autoscale configuration.
     */
    @JvmName("iaterubvmlfacibv")
    public suspend fun virtualRouterAutoScaleConfiguration(argument: suspend VirtualRouterAutoScaleConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualRouterAutoScaleConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.virtualRouterAutoScaleConfiguration = mapped
    }

    /**
     * @param value VirtualRouter IPs.
     */
    @JvmName("tqrffcgicoagstqv")
    public suspend fun virtualRouterIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualRouterIps = mapped
    }

    /**
     * @param values VirtualRouter IPs.
     */
    @JvmName("smkxdaqiylgtkysw")
    public suspend fun virtualRouterIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualRouterIps = mapped
    }

    /**
     * @param value The VirtualWAN to which the VirtualHub belongs.
     */
    @JvmName("qsubeqphhtckwkbt")
    public suspend fun virtualWan(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualWan = mapped
    }

    /**
     * @param argument The VirtualWAN to which the VirtualHub belongs.
     */
    @JvmName("pdlcrluxmqnpvsik")
    public suspend fun virtualWan(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualWan = mapped
    }

    /**
     * @param value The VpnGateway associated with this VirtualHub.
     */
    @JvmName("ujisdwdhsyggvwop")
    public suspend fun vpnGateway(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGateway = mapped
    }

    /**
     * @param argument The VpnGateway associated with this VirtualHub.
     */
    @JvmName("yocyfuykfflbhdcm")
    public suspend fun vpnGateway(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnGateway = mapped
    }

    internal fun build(): VirtualHubArgs = VirtualHubArgs(
        addressPrefix = addressPrefix,
        allowBranchToBranchTraffic = allowBranchToBranchTraffic,
        azureFirewall = azureFirewall,
        expressRouteGateway = expressRouteGateway,
        hubRoutingPreference = hubRoutingPreference,
        id = id,
        location = location,
        p2SVpnGateway = p2SVpnGateway,
        preferredRoutingGateway = preferredRoutingGateway,
        resourceGroupName = resourceGroupName,
        routeTable = routeTable,
        securityPartnerProvider = securityPartnerProvider,
        securityProviderName = securityProviderName,
        sku = sku,
        tags = tags,
        virtualHubName = virtualHubName,
        virtualHubRouteTableV2s = virtualHubRouteTableV2s,
        virtualRouterAsn = virtualRouterAsn,
        virtualRouterAutoScaleConfiguration = virtualRouterAutoScaleConfiguration,
        virtualRouterIps = virtualRouterIps,
        virtualWan = virtualWan,
        vpnGateway = vpnGateway,
    )
}
