@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VirtualHubBgpConnection].
 */
@PulumiTagMarker
public class VirtualHubBgpConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualHubBgpConnectionArgs = VirtualHubBgpConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualHubBgpConnectionArgsBuilder.() -> Unit) {
        val builder = VirtualHubBgpConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualHubBgpConnection {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualHubBgpConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualHubBgpConnection(builtJavaResource)
    }
}

/**
 * Virtual Appliance Site resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### VirtualHubRouteTableV2Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHubBgpConnection = new AzureNative.Network.VirtualHubBgpConnection("virtualHubBgpConnection", new()
 *     {
 *         ConnectionName = "conn1",
 *         HubVirtualNetworkConnection = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubVirtualNetworkConnections/hubVnetConn1",
 *         },
 *         PeerAsn = 20000,
 *         PeerIp = "192.168.1.5",
 *         ResourceGroupName = "rg1",
 *         VirtualHubName = "hub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualHubBgpConnection(ctx, "virtualHubBgpConnection", &network.VirtualHubBgpConnectionArgs{
 * 			ConnectionName: pulumi.String("conn1"),
 * 			HubVirtualNetworkConnection: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubVirtualNetworkConnections/hubVnetConn1"),
 * 			},
 * 			PeerAsn:           pulumi.Float64(20000),
 * 			PeerIp:            pulumi.String("192.168.1.5"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			VirtualHubName:    pulumi.String("hub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualHubBgpConnection;
 * import com.pulumi.azurenative.network.VirtualHubBgpConnectionArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHubBgpConnection = new VirtualHubBgpConnection("virtualHubBgpConnection", VirtualHubBgpConnectionArgs.builder()
 *             .connectionName("conn1")
 *             .hubVirtualNetworkConnection(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubVirtualNetworkConnections/hubVnetConn1")
 *                 .build())
 *             .peerAsn(20000)
 *             .peerIp("192.168.1.5")
 *             .resourceGroupName("rg1")
 *             .virtualHubName("hub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualHubBgpConnection conn1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/bgpConnections/{connectionName}
 * ```
 */
public class VirtualHubBgpConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualHubBgpConnection,
) : KotlinCustomResource(javaResource, VirtualHubBgpConnectionMapper) {
    /**
     * The current state of the VirtualHub to Peer.
     */
    public val connectionState: Output<String>
        get() = javaResource.connectionState().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The reference to the HubVirtualNetworkConnection resource.
     */
    public val hubVirtualNetworkConnection: Output<SubResourceResponse>?
        get() = javaResource.hubVirtualNetworkConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the connection.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Peer ASN.
     */
    public val peerAsn: Output<Double>?
        get() = javaResource.peerAsn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Peer IP.
     */
    public val peerIp: Output<String>?
        get() = javaResource.peerIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Connection type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualHubBgpConnectionMapper : ResourceMapper<VirtualHubBgpConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualHubBgpConnection::class == javaResource::class

    override fun map(javaResource: Resource): VirtualHubBgpConnection =
        VirtualHubBgpConnection(
            javaResource as
                com.pulumi.azurenative.network.VirtualHubBgpConnection,
        )
}

/**
 * @see [VirtualHubBgpConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualHubBgpConnection].
 */
public suspend fun virtualHubBgpConnection(
    name: String,
    block: suspend VirtualHubBgpConnectionResourceBuilder.() -> Unit,
): VirtualHubBgpConnection {
    val builder = VirtualHubBgpConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualHubBgpConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualHubBgpConnection(name: String): VirtualHubBgpConnection {
    val builder = VirtualHubBgpConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
