@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualNetworkArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgs
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.DhcpOptionsArgs
import com.pulumi.azurenative.network.kotlin.inputs.DhcpOptionsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubnetArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubnetArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkBgpCommunitiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkBgpCommunitiesArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkEncryptionArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkEncryptionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkPeeringArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkPeeringArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Virtual Network resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create virtual network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         FlowTimeoutInMinutes = 10,
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			FlowTimeoutInMinutes: pulumi.Int(10),
 * 			Location:             pulumi.String("eastus"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			VirtualNetworkName:   pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(AddressSpaceArgs.builder()
 *                 .addressPrefixes("10.0.0.0/16")
 *                 .build())
 *             .flowTimeoutInMinutes(10)
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with Bgp Communities
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         BgpCommunities = new AzureNative.Network.Inputs.VirtualNetworkBgpCommunitiesArgs
 *         {
 *             VirtualNetworkCommunity = "12076:20000",
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/24",
 *                 Name = "test-1",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			BgpCommunities: &network.VirtualNetworkBgpCommunitiesArgs{
 * 				VirtualNetworkCommunity: pulumi.String("12076:20000"),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: network.SubnetTypeArray{
 * 				&network.SubnetTypeArgs{
 * 					AddressPrefix: pulumi.String("10.0.0.0/24"),
 * 					Name:          pulumi.String("test-1"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import com.pulumi.azurenative.network.inputs.VirtualNetworkBgpCommunitiesArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(AddressSpaceArgs.builder()
 *                 .addressPrefixes("10.0.0.0/16")
 *                 .build())
 *             .bgpCommunities(VirtualNetworkBgpCommunitiesArgs.builder()
 *                 .virtualNetworkCommunity("12076:20000")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .subnets(SubnetArgs.builder()
 *                 .addressPrefix("10.0.0.0/24")
 *                 .name("test-1")
 *                 .build())
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with delegated subnets
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "westcentralus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/24",
 *                 Delegations = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.DelegationArgs
 *                     {
 *                         Name = "myDelegation",
 *                         ServiceName = "Microsoft.Sql/managedInstances",
 *                     },
 *                 },
 *                 Name = "test-1",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westcentralus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: network.SubnetTypeArray{
 * 				&network.SubnetTypeArgs{
 * 					AddressPrefix: pulumi.String("10.0.0.0/24"),
 * 					Delegations: network.DelegationArray{
 * 						&network.DelegationArgs{
 * 							Name:        pulumi.String("myDelegation"),
 * 							ServiceName: pulumi.String("Microsoft.Sql/managedInstances"),
 * 						},
 * 					},
 * 					Name: pulumi.String("test-1"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(AddressSpaceArgs.builder()
 *                 .addressPrefixes("10.0.0.0/16")
 *                 .build())
 *             .location("westcentralus")
 *             .resourceGroupName("rg1")
 *             .subnets(SubnetArgs.builder()
 *                 .addressPrefix("10.0.0.0/24")
 *                 .delegations(DelegationArgs.builder()
 *                     .name("myDelegation")
 *                     .serviceName("Microsoft.Sql/managedInstances")
 *                     .build())
 *                 .name("test-1")
 *                 .build())
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with encryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Encryption = new AzureNative.Network.Inputs.VirtualNetworkEncryptionArgs
 *         {
 *             Enabled = true,
 *             Enforcement = AzureNative.Network.VirtualNetworkEncryptionEnforcement.AllowUnencrypted,
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/24",
 *                 Name = "test-1",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Encryption: &network.VirtualNetworkEncryptionArgs{
 * 				Enabled:     pulumi.Bool(true),
 * 				Enforcement: pulumi.String(network.VirtualNetworkEncryptionEnforcementAllowUnencrypted),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: network.SubnetTypeArray{
 * 				&network.SubnetTypeArgs{
 * 					AddressPrefix: pulumi.String("10.0.0.0/24"),
 * 					Name:          pulumi.String("test-1"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import com.pulumi.azurenative.network.inputs.VirtualNetworkEncryptionArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(AddressSpaceArgs.builder()
 *                 .addressPrefixes("10.0.0.0/16")
 *                 .build())
 *             .encryption(VirtualNetworkEncryptionArgs.builder()
 *                 .enabled(true)
 *                 .enforcement("AllowUnencrypted")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .subnets(SubnetArgs.builder()
 *                 .addressPrefix("10.0.0.0/24")
 *                 .name("test-1")
 *                 .build())
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with service endpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "vnetTest",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/16",
 *                 Name = "test-1",
 *                 ServiceEndpoints = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ServiceEndpointPropertiesFormatArgs
 *                     {
 *                         Service = "Microsoft.Storage",
 *                     },
 *                 },
 *             },
 *         },
 *         VirtualNetworkName = "vnet1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("vnetTest"),
 * 			Subnets: network.SubnetTypeArray{
 * 				&network.SubnetTypeArgs{
 * 					AddressPrefix: pulumi.String("10.0.0.0/16"),
 * 					Name:          pulumi.String("test-1"),
 * 					ServiceEndpoints: network.ServiceEndpointPropertiesFormatArray{
 * 						&network.ServiceEndpointPropertiesFormatArgs{
 * 							Service: pulumi.String("Microsoft.Storage"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("vnet1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(AddressSpaceArgs.builder()
 *                 .addressPrefixes("10.0.0.0/16")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("vnetTest")
 *             .subnets(SubnetArgs.builder()
 *                 .addressPrefix("10.0.0.0/16")
 *                 .name("test-1")
 *                 .serviceEndpoints(ServiceEndpointPropertiesFormatArgs.builder()
 *                     .service("Microsoft.Storage")
 *                     .build())
 *                 .build())
 *             .virtualNetworkName("vnet1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with service endpoints and service endpoint policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "eastus2euap",
 *         ResourceGroupName = "vnetTest",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/16",
 *                 Name = "test-1",
 *                 ServiceEndpointPolicies = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ServiceEndpointPolicyArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/vnetTest/providers/Microsoft.Network/serviceEndpointPolicies/ServiceEndpointPolicy1",
 *                     },
 *                 },
 *                 ServiceEndpoints = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ServiceEndpointPropertiesFormatArgs
 *                     {
 *                         Service = "Microsoft.Storage",
 *                     },
 *                 },
 *             },
 *         },
 *         VirtualNetworkName = "vnet1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus2euap"),
 * 			ResourceGroupName: pulumi.String("vnetTest"),
 * 			Subnets: network.SubnetTypeArray{
 * 				&network.SubnetTypeArgs{
 * 					AddressPrefix: pulumi.String("10.0.0.0/16"),
 * 					Name:          pulumi.String("test-1"),
 * 					ServiceEndpointPolicies: network.ServiceEndpointPolicyTypeArray{
 * 						&network.ServiceEndpointPolicyTypeArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/vnetTest/providers/Microsoft.Network/serviceEndpointPolicies/ServiceEndpointPolicy1"),
 * 						},
 * 					},
 * 					ServiceEndpoints: network.ServiceEndpointPropertiesFormatArray{
 * 						&network.ServiceEndpointPropertiesFormatArgs{
 * 							Service: pulumi.String("Microsoft.Storage"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("vnet1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(AddressSpaceArgs.builder()
 *                 .addressPrefixes("10.0.0.0/16")
 *                 .build())
 *             .location("eastus2euap")
 *             .resourceGroupName("vnetTest")
 *             .subnets(SubnetArgs.builder()
 *                 .addressPrefix("10.0.0.0/16")
 *                 .name("test-1")
 *                 .serviceEndpointPolicies(ServiceEndpointPolicyArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/vnetTest/providers/Microsoft.Network/serviceEndpointPolicies/ServiceEndpointPolicy1")
 *                     .build())
 *                 .serviceEndpoints(ServiceEndpointPropertiesFormatArgs.builder()
 *                     .service("Microsoft.Storage")
 *                     .build())
 *                 .build())
 *             .virtualNetworkName("vnet1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefix = "10.0.0.0/24",
 *                 Name = "test-1",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: network.SubnetTypeArray{
 * 				&network.SubnetTypeArgs{
 * 					AddressPrefix: pulumi.String("10.0.0.0/24"),
 * 					Name:          pulumi.String("test-1"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(AddressSpaceArgs.builder()
 *                 .addressPrefixes("10.0.0.0/16")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .subnets(SubnetArgs.builder()
 *                 .addressPrefix("10.0.0.0/24")
 *                 .name("test-1")
 *                 .build())
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ### Create virtual network with subnet containing address prefixes
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.Network.VirtualNetwork("virtualNetwork", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubnetArgs
 *             {
 *                 AddressPrefixes = new[]
 *                 {
 *                     "10.0.0.0/28",
 *                     "10.0.1.0/28",
 *                 },
 *                 Name = "test-2",
 *             },
 *         },
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetwork(ctx, "virtualNetwork", &network.VirtualNetworkArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnets: network.SubnetTypeArray{
 * 				&network.SubnetTypeArgs{
 * 					AddressPrefixes: pulumi.StringArray{
 * 						pulumi.String("10.0.0.0/28"),
 * 						pulumi.String("10.0.1.0/28"),
 * 					},
 * 					Name: pulumi.String("test-2"),
 * 				},
 * 			},
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetwork;
 * import com.pulumi.azurenative.network.VirtualNetworkArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import com.pulumi.azurenative.network.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .addressSpace(AddressSpaceArgs.builder()
 *                 .addressPrefixes("10.0.0.0/16")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .subnets(SubnetArgs.builder()
 *                 .addressPrefixes(
 *                     "10.0.0.0/28",
 *                     "10.0.1.0/28")
 *                 .name("test-2")
 *                 .build())
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetwork test-vnet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}
 * ```
 * @property addressSpace The AddressSpace that contains an array of IP address ranges that can be used by subnets.
 * @property bgpCommunities Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
 * @property ddosProtectionPlan The DDoS protection plan associated with the virtual network.
 * @property dhcpOptions The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
 * @property enableDdosProtection Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource.
 * @property enableVmProtection Indicates if VM protection is enabled for all the subnets in the virtual network.
 * @property encryption Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
 * @property extendedLocation The extended location of the virtual network.
 * @property flowTimeoutInMinutes The FlowTimeout value (in minutes) for the Virtual Network
 * @property id Resource ID.
 * @property ipAllocations Array of IpAllocation which reference this VNET.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property subnets A list of subnets in a Virtual Network.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property tags Resource tags.
 * @property virtualNetworkName The name of the virtual network.
 * @property virtualNetworkPeerings A list of peerings in a Virtual Network.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 */
public data class VirtualNetworkArgs(
    public val addressSpace: Output<AddressSpaceArgs>? = null,
    public val bgpCommunities: Output<VirtualNetworkBgpCommunitiesArgs>? = null,
    public val ddosProtectionPlan: Output<SubResourceArgs>? = null,
    public val dhcpOptions: Output<DhcpOptionsArgs>? = null,
    public val enableDdosProtection: Output<Boolean>? = null,
    public val enableVmProtection: Output<Boolean>? = null,
    public val encryption: Output<VirtualNetworkEncryptionArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val flowTimeoutInMinutes: Output<Int>? = null,
    public val id: Output<String>? = null,
    public val ipAllocations: Output<List<SubResourceArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnets: Output<List<SubnetArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNetworkName: Output<String>? = null,
    public val virtualNetworkPeerings: Output<List<VirtualNetworkPeeringArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualNetworkArgs =
        com.pulumi.azurenative.network.VirtualNetworkArgs.builder()
            .addressSpace(addressSpace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bgpCommunities(bgpCommunities?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ddosProtectionPlan(
                ddosProtectionPlan?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dhcpOptions(dhcpOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableDdosProtection(enableDdosProtection?.applyValue({ args0 -> args0 }))
            .enableVmProtection(enableVmProtection?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .flowTimeoutInMinutes(flowTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipAllocations(
                ipAllocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNetworkName(virtualNetworkName?.applyValue({ args0 -> args0 }))
            .virtualNetworkPeerings(
                virtualNetworkPeerings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkArgs].
 */
@PulumiTagMarker
public class VirtualNetworkArgsBuilder internal constructor() {
    private var addressSpace: Output<AddressSpaceArgs>? = null

    private var bgpCommunities: Output<VirtualNetworkBgpCommunitiesArgs>? = null

    private var ddosProtectionPlan: Output<SubResourceArgs>? = null

    private var dhcpOptions: Output<DhcpOptionsArgs>? = null

    private var enableDdosProtection: Output<Boolean>? = null

    private var enableVmProtection: Output<Boolean>? = null

    private var encryption: Output<VirtualNetworkEncryptionArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var flowTimeoutInMinutes: Output<Int>? = null

    private var id: Output<String>? = null

    private var ipAllocations: Output<List<SubResourceArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnets: Output<List<SubnetArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNetworkName: Output<String>? = null

    private var virtualNetworkPeerings: Output<List<VirtualNetworkPeeringArgs>>? = null

    /**
     * @param value The AddressSpace that contains an array of IP address ranges that can be used by subnets.
     */
    @JvmName("rubqdpsyyrcoanfk")
    public suspend fun addressSpace(`value`: Output<AddressSpaceArgs>) {
        this.addressSpace = value
    }

    /**
     * @param value Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
     */
    @JvmName("ldfdjctgshxgnvtr")
    public suspend fun bgpCommunities(`value`: Output<VirtualNetworkBgpCommunitiesArgs>) {
        this.bgpCommunities = value
    }

    /**
     * @param value The DDoS protection plan associated with the virtual network.
     */
    @JvmName("smdtcxjgheeprpqi")
    public suspend fun ddosProtectionPlan(`value`: Output<SubResourceArgs>) {
        this.ddosProtectionPlan = value
    }

    /**
     * @param value The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
     */
    @JvmName("aaoveowdacpurfhq")
    public suspend fun dhcpOptions(`value`: Output<DhcpOptionsArgs>) {
        this.dhcpOptions = value
    }

    /**
     * @param value Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource.
     */
    @JvmName("ekkdyjsvkanpjelx")
    public suspend fun enableDdosProtection(`value`: Output<Boolean>) {
        this.enableDdosProtection = value
    }

    /**
     * @param value Indicates if VM protection is enabled for all the subnets in the virtual network.
     */
    @JvmName("mshsvqlesdqggxyl")
    public suspend fun enableVmProtection(`value`: Output<Boolean>) {
        this.enableVmProtection = value
    }

    /**
     * @param value Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
     */
    @JvmName("yyxaiaoblfctpydu")
    public suspend fun encryption(`value`: Output<VirtualNetworkEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The extended location of the virtual network.
     */
    @JvmName("stpcdlbisfxmahxb")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The FlowTimeout value (in minutes) for the Virtual Network
     */
    @JvmName("mtsfrbxjnbxwwamu")
    public suspend fun flowTimeoutInMinutes(`value`: Output<Int>) {
        this.flowTimeoutInMinutes = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("iyuhtjfwcqqiakmr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Array of IpAllocation which reference this VNET.
     */
    @JvmName("qftthyibxdriptrn")
    public suspend fun ipAllocations(`value`: Output<List<SubResourceArgs>>) {
        this.ipAllocations = value
    }

    @JvmName("tbjggmtnkjhldqox")
    public suspend fun ipAllocations(vararg values: Output<SubResourceArgs>) {
        this.ipAllocations = Output.all(values.asList())
    }

    /**
     * @param values Array of IpAllocation which reference this VNET.
     */
    @JvmName("dgnbogqutobrtctl")
    public suspend fun ipAllocations(values: List<Output<SubResourceArgs>>) {
        this.ipAllocations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gsbfsoblkqcvnowg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cuornusobqhgitwu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A list of subnets in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jkjnanrdxggejxrx")
    public suspend fun subnets(`value`: Output<List<SubnetArgs>>) {
        this.subnets = value
    }

    @JvmName("pcbwbtsgiassrtwp")
    public suspend fun subnets(vararg values: Output<SubnetArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values A list of subnets in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("lemdtulbwuosehqa")
    public suspend fun subnets(values: List<Output<SubnetArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vlvjmwjbkiyudvkn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("uvilgsrhkrdpcjxh")
    public suspend fun virtualNetworkName(`value`: Output<String>) {
        this.virtualNetworkName = value
    }

    /**
     * @param value A list of peerings in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xkwbvjwaoasohxhf")
    public suspend fun virtualNetworkPeerings(`value`: Output<List<VirtualNetworkPeeringArgs>>) {
        this.virtualNetworkPeerings = value
    }

    @JvmName("vcddjfchakxmqndh")
    public suspend fun virtualNetworkPeerings(vararg values: Output<VirtualNetworkPeeringArgs>) {
        this.virtualNetworkPeerings = Output.all(values.asList())
    }

    /**
     * @param values A list of peerings in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("rldwyakspddwisnl")
    public suspend fun virtualNetworkPeerings(values: List<Output<VirtualNetworkPeeringArgs>>) {
        this.virtualNetworkPeerings = Output.all(values)
    }

    /**
     * @param value The AddressSpace that contains an array of IP address ranges that can be used by subnets.
     */
    @JvmName("mtgerrlmbsgqrslg")
    public suspend fun addressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressSpace = mapped
    }

    /**
     * @param argument The AddressSpace that contains an array of IP address ranges that can be used by subnets.
     */
    @JvmName("tmvrignxhywlxwjm")
    public suspend fun addressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.addressSpace = mapped
    }

    /**
     * @param value Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
     */
    @JvmName("umopvwbsdgpyakyq")
    public suspend fun bgpCommunities(`value`: VirtualNetworkBgpCommunitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpCommunities = mapped
    }

    /**
     * @param argument Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
     */
    @JvmName("wudgthqpxbswnnaf")
    public suspend fun bgpCommunities(argument: suspend VirtualNetworkBgpCommunitiesArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkBgpCommunitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpCommunities = mapped
    }

    /**
     * @param value The DDoS protection plan associated with the virtual network.
     */
    @JvmName("gnbhowmbkdeernux")
    public suspend fun ddosProtectionPlan(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosProtectionPlan = mapped
    }

    /**
     * @param argument The DDoS protection plan associated with the virtual network.
     */
    @JvmName("vuikhbgvqfhiqyjv")
    public suspend fun ddosProtectionPlan(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ddosProtectionPlan = mapped
    }

    /**
     * @param value The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
     */
    @JvmName("jbhybpeowcjjosru")
    public suspend fun dhcpOptions(`value`: DhcpOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dhcpOptions = mapped
    }

    /**
     * @param argument The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
     */
    @JvmName("bfawmqnyvrekrhsk")
    public suspend fun dhcpOptions(argument: suspend DhcpOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DhcpOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dhcpOptions = mapped
    }

    /**
     * @param value Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource.
     */
    @JvmName("afvvtushiwagcfvl")
    public suspend fun enableDdosProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDdosProtection = mapped
    }

    /**
     * @param value Indicates if VM protection is enabled for all the subnets in the virtual network.
     */
    @JvmName("sntnvdsepenrqcdn")
    public suspend fun enableVmProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableVmProtection = mapped
    }

    /**
     * @param value Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
     */
    @JvmName("ooqymoysnshnhmkx")
    public suspend fun encryption(`value`: VirtualNetworkEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
     */
    @JvmName("qkqrkkuvdoroxdkg")
    public suspend fun encryption(argument: suspend VirtualNetworkEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The extended location of the virtual network.
     */
    @JvmName("bnqrannsriqsxwms")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the virtual network.
     */
    @JvmName("qfksavlbkgcvrerk")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The FlowTimeout value (in minutes) for the Virtual Network
     */
    @JvmName("pucmagcevikyjkxh")
    public suspend fun flowTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowTimeoutInMinutes = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("haabosdsabnuhkxj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Array of IpAllocation which reference this VNET.
     */
    @JvmName("jjasdmwxmoohsbkw")
    public suspend fun ipAllocations(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this VNET.
     */
    @JvmName("yhrhppqnedgouqub")
    public suspend fun ipAllocations(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this VNET.
     */
    @JvmName("vxbeixpddlbqchxe")
    public suspend fun ipAllocations(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this VNET.
     */
    @JvmName("xhqukstbldnmdaoq")
    public suspend fun ipAllocations(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param values Array of IpAllocation which reference this VNET.
     */
    @JvmName("gttqmqadxfbfxapr")
    public suspend fun ipAllocations(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hmxwaudldnpligrg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rkrdjhqwjjnefpqg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A list of subnets in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("tawidnfhlytdghfx")
    public suspend fun subnets(`value`: List<SubnetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument A list of subnets in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("oryartylrfjyasaj")
    public suspend fun subnets(argument: List<suspend SubnetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument A list of subnets in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hotywtlvcxropyos")
    public suspend fun subnets(vararg argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument A list of subnets in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("gqsomdcnxhfaomwb")
    public suspend fun subnets(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubnetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values A list of subnets in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("uwyprfdomumitjoc")
    public suspend fun subnets(vararg values: SubnetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xesybkmmcyxysrbg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("umrsqenvtojwswwp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("iqiaofehdiciglyj")
    public suspend fun virtualNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkName = mapped
    }

    /**
     * @param value A list of peerings in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hyemcnoiuuvnofrm")
    public suspend fun virtualNetworkPeerings(`value`: List<VirtualNetworkPeeringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkPeerings = mapped
    }

    /**
     * @param argument A list of peerings in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("iotrylgynsicdfcj")
    public suspend fun virtualNetworkPeerings(argument: List<suspend VirtualNetworkPeeringArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPeeringArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkPeerings = mapped
    }

    /**
     * @param argument A list of peerings in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("kogjrhlhfjkbispv")
    public suspend fun virtualNetworkPeerings(vararg argument: suspend VirtualNetworkPeeringArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPeeringArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkPeerings = mapped
    }

    /**
     * @param argument A list of peerings in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("uiywayvumpqalwpa")
    public suspend fun virtualNetworkPeerings(argument: suspend VirtualNetworkPeeringArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNetworkPeeringArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkPeerings = mapped
    }

    /**
     * @param values A list of peerings in a Virtual Network.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("sxinhbypbyngevqp")
    public suspend fun virtualNetworkPeerings(vararg values: VirtualNetworkPeeringArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkPeerings = mapped
    }

    internal fun build(): VirtualNetworkArgs = VirtualNetworkArgs(
        addressSpace = addressSpace,
        bgpCommunities = bgpCommunities,
        ddosProtectionPlan = ddosProtectionPlan,
        dhcpOptions = dhcpOptions,
        enableDdosProtection = enableDdosProtection,
        enableVmProtection = enableVmProtection,
        encryption = encryption,
        extendedLocation = extendedLocation,
        flowTimeoutInMinutes = flowTimeoutInMinutes,
        id = id,
        ipAllocations = ipAllocations,
        location = location,
        resourceGroupName = resourceGroupName,
        subnets = subnets,
        tags = tags,
        virtualNetworkName = virtualNetworkName,
        virtualNetworkPeerings = virtualNetworkPeerings,
    )
}
