@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionMode
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionProtocol
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionType
import com.pulumi.azurenative.network.kotlin.inputs.GatewayCustomBgpIpAddressIpConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.GatewayCustomBgpIpAddressIpConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LocalNetworkGatewayArgs
import com.pulumi.azurenative.network.kotlin.inputs.LocalNetworkGatewayArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.TrafficSelectorPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.TrafficSelectorPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A common class for general resource information.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2016-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### CreateVirtualNetworkGatewayConnection_S2S
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkGatewayConnection = new AzureNative.Network.VirtualNetworkGatewayConnection("virtualNetworkGatewayConnection", new()
 *     {
 *         ConnectionMode = AzureNative.Network.VirtualNetworkGatewayConnectionMode.Default,
 *         ConnectionProtocol = AzureNative.Network.VirtualNetworkGatewayConnectionProtocol.IKEv2,
 *         ConnectionType = AzureNative.Network.VirtualNetworkGatewayConnectionType.IPsec,
 *         DpdTimeoutSeconds = 30,
 *         EgressNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2",
 *             },
 *         },
 *         EnableBgp = false,
 *         GatewayCustomBgpIpAddresses = new[]
 *         {
 *             new AzureNative.Network.Inputs.GatewayCustomBgpIpAddressIpConfigurationArgs
 *             {
 *                 CustomBgpIpAddress = "169.254.21.1",
 *                 IpConfigurationId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/default",
 *             },
 *             new AzureNative.Network.Inputs.GatewayCustomBgpIpAddressIpConfigurationArgs
 *             {
 *                 CustomBgpIpAddress = "169.254.21.3",
 *                 IpConfigurationId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/ActiveActive",
 *             },
 *         },
 *         IngressNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1",
 *             },
 *         },
 *         IpsecPolicies = new[] {},
 *         LocalNetworkGateway2 = new AzureNative.Network.Inputs.LocalNetworkGatewayArgs
 *         {
 *             GatewayIpAddress = "x.x.x.x",
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/localNetworkGateways/localgw",
 *             LocalNetworkAddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *             {
 *                 AddressPrefixes = new[]
 *                 {
 *                     "10.1.0.0/16",
 *                 },
 *             },
 *             Location = "centralus",
 *             Tags = null,
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "rg1",
 *         RoutingWeight = 0,
 *         SharedKey = "Abc123",
 *         TrafficSelectorPolicies = new[] {},
 *         UsePolicyBasedTrafficSelectors = false,
 *         VirtualNetworkGateway1 = new AzureNative.Network.Inputs.VirtualNetworkGatewayArgs
 *         {
 *             ActiveActive = false,
 *             BgpSettings = new AzureNative.Network.Inputs.BgpSettingsArgs
 *             {
 *                 Asn = 65514,
 *                 BgpPeeringAddress = "10.0.1.30",
 *                 PeerWeight = 0,
 *             },
 *             EnableBgp = false,
 *             GatewayType = AzureNative.Network.VirtualNetworkGatewayType.Vpn,
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw",
 *             IpConfigurations = new[]
 *             {
 *                 new AzureNative.Network.Inputs.VirtualNetworkGatewayIPConfigurationArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1",
 *                     Name = "gwipconfig1",
 *                     PrivateIPAllocationMethod = AzureNative.Network.IPAllocationMethod.Dynamic,
 *                     PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip",
 *                     },
 *                     Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet",
 *                     },
 *                 },
 *             },
 *             Location = "centralus",
 *             Sku = new AzureNative.Network.Inputs.VirtualNetworkGatewaySkuArgs
 *             {
 *                 Name = AzureNative.Network.VirtualNetworkGatewaySkuName.VpnGw1,
 *                 Tier = AzureNative.Network.VirtualNetworkGatewaySkuTier.VpnGw1,
 *             },
 *             Tags = null,
 *             VpnType = AzureNative.Network.VpnType.RouteBased,
 *         },
 *         VirtualNetworkGatewayConnectionName = "connS2S",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkGatewayConnection(ctx, "virtualNetworkGatewayConnection", &network.VirtualNetworkGatewayConnectionArgs{
 * 			ConnectionMode:     pulumi.String(network.VirtualNetworkGatewayConnectionModeDefault),
 * 			ConnectionProtocol: pulumi.String(network.VirtualNetworkGatewayConnectionProtocolIKEv2),
 * 			ConnectionType:     pulumi.String(network.VirtualNetworkGatewayConnectionTypeIPsec),
 * 			DpdTimeoutSeconds:  pulumi.Int(30),
 * 			EgressNatRules: network.SubResourceArray{
 * 				&network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2"),
 * 				},
 * 			},
 * 			EnableBgp: pulumi.Bool(false),
 * 			GatewayCustomBgpIpAddresses: network.GatewayCustomBgpIpAddressIpConfigurationArray{
 * 				&network.GatewayCustomBgpIpAddressIpConfigurationArgs{
 * 					CustomBgpIpAddress: pulumi.String("169.254.21.1"),
 * 					IpConfigurationId:  pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/default"),
 * 				},
 * 				&network.GatewayCustomBgpIpAddressIpConfigurationArgs{
 * 					CustomBgpIpAddress: pulumi.String("169.254.21.3"),
 * 					IpConfigurationId:  pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/ActiveActive"),
 * 				},
 * 			},
 * 			IngressNatRules: network.SubResourceArray{
 * 				&network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1"),
 * 				},
 * 			},
 * 			IpsecPolicies: network.IpsecPolicyArray{},
 * 			LocalNetworkGateway2: &network.LocalNetworkGatewayTypeArgs{
 * 				GatewayIpAddress: pulumi.String("x.x.x.x"),
 * 				Id:               pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/localNetworkGateways/localgw"),
 * 				LocalNetworkAddressSpace: &network.AddressSpaceArgs{
 * 					AddressPrefixes: pulumi.StringArray{
 * 						pulumi.String("10.1.0.0/16"),
 * 					},
 * 				},
 * 				Location: pulumi.String("centralus"),
 * 				Tags:     nil,
 * 			},
 * 			Location:                       pulumi.String("centralus"),
 * 			ResourceGroupName:              pulumi.String("rg1"),
 * 			RoutingWeight:                  pulumi.Int(0),
 * 			SharedKey:                      pulumi.String("Abc123"),
 * 			TrafficSelectorPolicies:        network.TrafficSelectorPolicyArray{},
 * 			UsePolicyBasedTrafficSelectors: pulumi.Bool(false),
 * 			VirtualNetworkGateway1: &network.VirtualNetworkGatewayTypeArgs{
 * 				ActiveActive: pulumi.Bool(false),
 * 				BgpSettings: &network.BgpSettingsArgs{
 * 					Asn:               pulumi.Float64(65514),
 * 					BgpPeeringAddress: pulumi.String("10.0.1.30"),
 * 					PeerWeight:        pulumi.Int(0),
 * 				},
 * 				EnableBgp:   pulumi.Bool(false),
 * 				GatewayType: pulumi.String(network.VirtualNetworkGatewayTypeVpn),
 * 				Id:          pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw"),
 * 				IpConfigurations: network.VirtualNetworkGatewayIPConfigurationArray{
 * 					&network.VirtualNetworkGatewayIPConfigurationArgs{
 * 						Id:                        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
 * 						Name:                      pulumi.String("gwipconfig1"),
 * 						PrivateIPAllocationMethod: pulumi.String(network.IPAllocationMethodDynamic),
 * 						PublicIPAddress: &network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
 * 						},
 * 						Subnet: &network.SubResourceArgs{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
 * 						},
 * 					},
 * 				},
 * 				Location: pulumi.String("centralus"),
 * 				Sku: &network.VirtualNetworkGatewaySkuArgs{
 * 					Name: pulumi.String(network.VirtualNetworkGatewaySkuNameVpnGw1),
 * 					Tier: pulumi.String(network.VirtualNetworkGatewaySkuTierVpnGw1),
 * 				},
 * 				Tags:    nil,
 * 				VpnType: pulumi.String(network.VpnTypeRouteBased),
 * 			},
 * 			VirtualNetworkGatewayConnectionName: pulumi.String("connS2S"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayConnection;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.network.inputs.GatewayCustomBgpIpAddressIpConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.LocalNetworkGatewayArgs;
 * import com.pulumi.azurenative.network.inputs.AddressSpaceArgs;
 * import com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayArgs;
 * import com.pulumi.azurenative.network.inputs.BgpSettingsArgs;
 * import com.pulumi.azurenative.network.inputs.VirtualNetworkGatewaySkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkGatewayConnection = new VirtualNetworkGatewayConnection("virtualNetworkGatewayConnection", VirtualNetworkGatewayConnectionArgs.builder()
 *             .connectionMode("Default")
 *             .connectionProtocol("IKEv2")
 *             .connectionType("IPsec")
 *             .dpdTimeoutSeconds(30)
 *             .egressNatRules(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2")
 *                 .build())
 *             .enableBgp(false)
 *             .gatewayCustomBgpIpAddresses(
 *                 GatewayCustomBgpIpAddressIpConfigurationArgs.builder()
 *                     .customBgpIpAddress("169.254.21.1")
 *                     .ipConfigurationId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/default")
 *                     .build(),
 *                 GatewayCustomBgpIpAddressIpConfigurationArgs.builder()
 *                     .customBgpIpAddress("169.254.21.3")
 *                     .ipConfigurationId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/ActiveActive")
 *                     .build())
 *             .ingressNatRules(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1")
 *                 .build())
 *             .ipsecPolicies()
 *             .localNetworkGateway2(LocalNetworkGatewayArgs.builder()
 *                 .gatewayIpAddress("x.x.x.x")
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/localNetworkGateways/localgw")
 *                 .localNetworkAddressSpace(AddressSpaceArgs.builder()
 *                     .addressPrefixes("10.1.0.0/16")
 *                     .build())
 *                 .location("centralus")
 *                 .tags()
 *                 .build())
 *             .location("centralus")
 *             .resourceGroupName("rg1")
 *             .routingWeight(0)
 *             .sharedKey("Abc123")
 *             .trafficSelectorPolicies()
 *             .usePolicyBasedTrafficSelectors(false)
 *             .virtualNetworkGateway1(VirtualNetworkGatewayArgs.builder()
 *                 .activeActive(false)
 *                 .bgpSettings(BgpSettingsArgs.builder()
 *                     .asn(65514)
 *                     .bgpPeeringAddress("10.0.1.30")
 *                     .peerWeight(0)
 *                     .build())
 *                 .enableBgp(false)
 *                 .gatewayType("Vpn")
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw")
 *                 .ipConfigurations(VirtualNetworkGatewayIPConfigurationArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1")
 *                     .name("gwipconfig1")
 *                     .privateIPAllocationMethod("Dynamic")
 *                     .publicIPAddress(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip")
 *                         .build())
 *                     .subnet(SubResourceArgs.builder()
 *                         .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet")
 *                         .build())
 *                     .build())
 *                 .location("centralus")
 *                 .sku(VirtualNetworkGatewaySkuArgs.builder()
 *                     .name("VpnGw1")
 *                     .tier("VpnGw1")
 *                     .build())
 *                 .tags()
 *                 .vpnType("RouteBased")
 *                 .build())
 *             .virtualNetworkGatewayConnectionName("connS2S")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkGatewayConnection connS2S /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}
 * ```
 * @property authorizationKey The authorizationKey.
 * @property connectionMode The connection mode for this connection.
 * @property connectionProtocol Connection protocol used for this connection.
 * @property connectionType Gateway connection type.
 * @property dpdTimeoutSeconds The dead peer detection timeout of this connection in seconds.
 * @property egressNatRules List of egress NatRules.
 * @property enableBgp EnableBgp flag.
 * @property enablePrivateLinkFastPath Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
 * @property expressRouteGatewayBypass Bypass ExpressRoute Gateway for data forwarding.
 * @property gatewayCustomBgpIpAddresses GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
 * @property id Resource ID.
 * @property ingressNatRules List of ingress NatRules.
 * @property ipsecPolicies The IPSec Policies to be considered by this connection.
 * @property localNetworkGateway2 The reference to local network gateway resource.
 * @property location Resource location.
 * @property peer The reference to peerings resource.
 * @property resourceGroupName The name of the resource group.
 * @property routingWeight The routing weight.
 * @property sharedKey The IPSec shared key.
 * @property tags Resource tags.
 * @property trafficSelectorPolicies The Traffic Selector Policies to be considered by this connection.
 * @property useLocalAzureIpAddress Use private local Azure IP for the connection.
 * @property usePolicyBasedTrafficSelectors Enable policy-based traffic selectors.
 * @property virtualNetworkGateway1 The reference to virtual network gateway resource.
 * @property virtualNetworkGateway2 The reference to virtual network gateway resource.
 * @property virtualNetworkGatewayConnectionName The name of the virtual network gateway connection.
 */
public data class VirtualNetworkGatewayConnectionArgs(
    public val authorizationKey: Output<String>? = null,
    public val connectionMode: Output<Either<String, VirtualNetworkGatewayConnectionMode>>? = null,
    public val connectionProtocol: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? =
        null,
    public val connectionType: Output<Either<String, VirtualNetworkGatewayConnectionType>>? = null,
    public val dpdTimeoutSeconds: Output<Int>? = null,
    public val egressNatRules: Output<List<SubResourceArgs>>? = null,
    public val enableBgp: Output<Boolean>? = null,
    public val enablePrivateLinkFastPath: Output<Boolean>? = null,
    public val expressRouteGatewayBypass: Output<Boolean>? = null,
    public val gatewayCustomBgpIpAddresses: Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>? = null,
    public val id: Output<String>? = null,
    public val ingressNatRules: Output<List<SubResourceArgs>>? = null,
    public val ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val localNetworkGateway2: Output<LocalNetworkGatewayArgs>? = null,
    public val location: Output<String>? = null,
    public val peer: Output<SubResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingWeight: Output<Int>? = null,
    public val sharedKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficSelectorPolicies: Output<List<TrafficSelectorPolicyArgs>>? = null,
    public val useLocalAzureIpAddress: Output<Boolean>? = null,
    public val usePolicyBasedTrafficSelectors: Output<Boolean>? = null,
    public val virtualNetworkGateway1: Output<VirtualNetworkGatewayArgs>? = null,
    public val virtualNetworkGateway2: Output<VirtualNetworkGatewayArgs>? = null,
    public val virtualNetworkGatewayConnectionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs =
        com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs.builder()
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .connectionMode(
                connectionMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .connectionProtocol(
                connectionProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectionType(
                connectionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dpdTimeoutSeconds(dpdTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .egressNatRules(
                egressNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableBgp(enableBgp?.applyValue({ args0 -> args0 }))
            .enablePrivateLinkFastPath(enablePrivateLinkFastPath?.applyValue({ args0 -> args0 }))
            .expressRouteGatewayBypass(expressRouteGatewayBypass?.applyValue({ args0 -> args0 }))
            .gatewayCustomBgpIpAddresses(
                gatewayCustomBgpIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ingressNatRules(
                ingressNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipsecPolicies(
                ipsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .localNetworkGateway2(
                localNetworkGateway2?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .peer(peer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingWeight(routingWeight?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficSelectorPolicies(
                trafficSelectorPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .useLocalAzureIpAddress(useLocalAzureIpAddress?.applyValue({ args0 -> args0 }))
            .usePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors?.applyValue({ args0 -> args0 }))
            .virtualNetworkGateway1(
                virtualNetworkGateway1?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualNetworkGateway2(
                virtualNetworkGateway2?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualNetworkGatewayConnectionName(
                virtualNetworkGatewayConnectionName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkGatewayConnectionArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayConnectionArgsBuilder internal constructor() {
    private var authorizationKey: Output<String>? = null

    private var connectionMode: Output<Either<String, VirtualNetworkGatewayConnectionMode>>? = null

    private var connectionProtocol: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? =
        null

    private var connectionType: Output<Either<String, VirtualNetworkGatewayConnectionType>>? = null

    private var dpdTimeoutSeconds: Output<Int>? = null

    private var egressNatRules: Output<List<SubResourceArgs>>? = null

    private var enableBgp: Output<Boolean>? = null

    private var enablePrivateLinkFastPath: Output<Boolean>? = null

    private var expressRouteGatewayBypass: Output<Boolean>? = null

    private var gatewayCustomBgpIpAddresses:
        Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>? = null

    private var id: Output<String>? = null

    private var ingressNatRules: Output<List<SubResourceArgs>>? = null

    private var ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var localNetworkGateway2: Output<LocalNetworkGatewayArgs>? = null

    private var location: Output<String>? = null

    private var peer: Output<SubResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingWeight: Output<Int>? = null

    private var sharedKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficSelectorPolicies: Output<List<TrafficSelectorPolicyArgs>>? = null

    private var useLocalAzureIpAddress: Output<Boolean>? = null

    private var usePolicyBasedTrafficSelectors: Output<Boolean>? = null

    private var virtualNetworkGateway1: Output<VirtualNetworkGatewayArgs>? = null

    private var virtualNetworkGateway2: Output<VirtualNetworkGatewayArgs>? = null

    private var virtualNetworkGatewayConnectionName: Output<String>? = null

    /**
     * @param value The authorizationKey.
     */
    @JvmName("sbkvdbowqdvlbbyj")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value The connection mode for this connection.
     */
    @JvmName("ovplsquylinffuvw")
    public suspend fun connectionMode(`value`: Output<Either<String, VirtualNetworkGatewayConnectionMode>>) {
        this.connectionMode = value
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("lfotdaqkbutdsaqj")
    public suspend fun connectionProtocol(`value`: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>) {
        this.connectionProtocol = value
    }

    /**
     * @param value Gateway connection type.
     */
    @JvmName("atrxrweefohenfoa")
    public suspend fun connectionType(`value`: Output<Either<String, VirtualNetworkGatewayConnectionType>>) {
        this.connectionType = value
    }

    /**
     * @param value The dead peer detection timeout of this connection in seconds.
     */
    @JvmName("wftmrabuseaxprfi")
    public suspend fun dpdTimeoutSeconds(`value`: Output<Int>) {
        this.dpdTimeoutSeconds = value
    }

    /**
     * @param value List of egress NatRules.
     */
    @JvmName("vqswpyuvgepbdlhv")
    public suspend fun egressNatRules(`value`: Output<List<SubResourceArgs>>) {
        this.egressNatRules = value
    }

    @JvmName("cfxuhsbvqmpyaesm")
    public suspend fun egressNatRules(vararg values: Output<SubResourceArgs>) {
        this.egressNatRules = Output.all(values.asList())
    }

    /**
     * @param values List of egress NatRules.
     */
    @JvmName("bahbpalrymlufkld")
    public suspend fun egressNatRules(values: List<Output<SubResourceArgs>>) {
        this.egressNatRules = Output.all(values)
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("nbjwlhjkrdcuhgfw")
    public suspend fun enableBgp(`value`: Output<Boolean>) {
        this.enableBgp = value
    }

    /**
     * @param value Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    @JvmName("hlunomobakrlhhfo")
    public suspend fun enablePrivateLinkFastPath(`value`: Output<Boolean>) {
        this.enablePrivateLinkFastPath = value
    }

    /**
     * @param value Bypass ExpressRoute Gateway for data forwarding.
     */
    @JvmName("sindiiqugxraaoay")
    public suspend fun expressRouteGatewayBypass(`value`: Output<Boolean>) {
        this.expressRouteGatewayBypass = value
    }

    /**
     * @param value GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("jinfhrvnaxvorikm")
    public suspend fun gatewayCustomBgpIpAddresses(`value`: Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>) {
        this.gatewayCustomBgpIpAddresses = value
    }

    @JvmName("snthfpboyohgohge")
    public suspend fun gatewayCustomBgpIpAddresses(vararg values: Output<GatewayCustomBgpIpAddressIpConfigurationArgs>) {
        this.gatewayCustomBgpIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("pbuhgpyphsibmjvp")
    public suspend fun gatewayCustomBgpIpAddresses(values: List<Output<GatewayCustomBgpIpAddressIpConfigurationArgs>>) {
        this.gatewayCustomBgpIpAddresses = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vwevdpohlnucggep")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of ingress NatRules.
     */
    @JvmName("qmlhceaplmttiumq")
    public suspend fun ingressNatRules(`value`: Output<List<SubResourceArgs>>) {
        this.ingressNatRules = value
    }

    @JvmName("alnwdnttoumqdwqm")
    public suspend fun ingressNatRules(vararg values: Output<SubResourceArgs>) {
        this.ingressNatRules = Output.all(values.asList())
    }

    /**
     * @param values List of ingress NatRules.
     */
    @JvmName("okxsethhukcibbho")
    public suspend fun ingressNatRules(values: List<Output<SubResourceArgs>>) {
        this.ingressNatRules = Output.all(values)
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("revljkkjapappdog")
    public suspend fun ipsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.ipsecPolicies = value
    }

    @JvmName("fddumsyinuhpxqot")
    public suspend fun ipsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.ipsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("cgljolsljjjtlvdo")
    public suspend fun ipsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.ipsecPolicies = Output.all(values)
    }

    /**
     * @param value The reference to local network gateway resource.
     */
    @JvmName("wtubgcoyvxmfcygm")
    public suspend fun localNetworkGateway2(`value`: Output<LocalNetworkGatewayArgs>) {
        this.localNetworkGateway2 = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("aglgeipfejltrkit")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The reference to peerings resource.
     */
    @JvmName("qkghsrhcijrsxyqp")
    public suspend fun peer(`value`: Output<SubResourceArgs>) {
        this.peer = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hcprmkgebyfhcsjm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The routing weight.
     */
    @JvmName("ysiuctgvemyudwfj")
    public suspend fun routingWeight(`value`: Output<Int>) {
        this.routingWeight = value
    }

    /**
     * @param value The IPSec shared key.
     */
    @JvmName("leerfbgmqlmpfvof")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vsscldaghueseirn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("ojockifhefeujerf")
    public suspend fun trafficSelectorPolicies(`value`: Output<List<TrafficSelectorPolicyArgs>>) {
        this.trafficSelectorPolicies = value
    }

    @JvmName("ruqumntefoxsvkvs")
    public suspend fun trafficSelectorPolicies(vararg values: Output<TrafficSelectorPolicyArgs>) {
        this.trafficSelectorPolicies = Output.all(values.asList())
    }

    /**
     * @param values The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("flvieeecgtliqedo")
    public suspend fun trafficSelectorPolicies(values: List<Output<TrafficSelectorPolicyArgs>>) {
        this.trafficSelectorPolicies = Output.all(values)
    }

    /**
     * @param value Use private local Azure IP for the connection.
     */
    @JvmName("nftnxmayeiaqevsn")
    public suspend fun useLocalAzureIpAddress(`value`: Output<Boolean>) {
        this.useLocalAzureIpAddress = value
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("tofmfevcfojdlehr")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Output<Boolean>) {
        this.usePolicyBasedTrafficSelectors = value
    }

    /**
     * @param value The reference to virtual network gateway resource.
     */
    @JvmName("rjqyfvpgdtoyhbjs")
    public suspend fun virtualNetworkGateway1(`value`: Output<VirtualNetworkGatewayArgs>) {
        this.virtualNetworkGateway1 = value
    }

    /**
     * @param value The reference to virtual network gateway resource.
     */
    @JvmName("pxuuthgravpqpgky")
    public suspend fun virtualNetworkGateway2(`value`: Output<VirtualNetworkGatewayArgs>) {
        this.virtualNetworkGateway2 = value
    }

    /**
     * @param value The name of the virtual network gateway connection.
     */
    @JvmName("divrruidowdesnqq")
    public suspend fun virtualNetworkGatewayConnectionName(`value`: Output<String>) {
        this.virtualNetworkGatewayConnectionName = value
    }

    /**
     * @param value The authorizationKey.
     */
    @JvmName("ivwlltkhddpjliqm")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value The connection mode for this connection.
     */
    @JvmName("cbinlwbiilcoltif")
    public suspend fun connectionMode(`value`: Either<String, VirtualNetworkGatewayConnectionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value The connection mode for this connection.
     */
    @JvmName("yyhjtbwbnnulkqyg")
    public fun connectionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value The connection mode for this connection.
     */
    @JvmName("sjnycvjwuurgrsph")
    public fun connectionMode(`value`: VirtualNetworkGatewayConnectionMode) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("dlqxspcdrfdyqvld")
    public suspend fun connectionProtocol(`value`: Either<String, VirtualNetworkGatewayConnectionProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionProtocol = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("fqupobcpdlcntjqk")
    public fun connectionProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionProtocol = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("tiycnhihsfukqddr")
    public fun connectionProtocol(`value`: VirtualNetworkGatewayConnectionProtocol) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionProtocol = mapped
    }

    /**
     * @param value Gateway connection type.
     */
    @JvmName("kaqespuibknlandk")
    public suspend fun connectionType(`value`: Either<String, VirtualNetworkGatewayConnectionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value Gateway connection type.
     */
    @JvmName("cdkstgdcqwufclss")
    public fun connectionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value Gateway connection type.
     */
    @JvmName("mxetqosrptdpfgoi")
    public fun connectionType(`value`: VirtualNetworkGatewayConnectionType) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value The dead peer detection timeout of this connection in seconds.
     */
    @JvmName("uyvaxrsuweqprhfm")
    public suspend fun dpdTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dpdTimeoutSeconds = mapped
    }

    /**
     * @param value List of egress NatRules.
     */
    @JvmName("lldruvalyellthox")
    public suspend fun egressNatRules(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("xyxmpjbjopijtmjn")
    public suspend fun egressNatRules(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("pwedlrygroahmjjg")
    public suspend fun egressNatRules(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("eeitpesfkhaqtvre")
    public suspend fun egressNatRules(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param values List of egress NatRules.
     */
    @JvmName("mgactlefwpvljweg")
    public suspend fun egressNatRules(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egressNatRules = mapped
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("idmspeppwrefukhh")
    public suspend fun enableBgp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgp = mapped
    }

    /**
     * @param value Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    @JvmName("ctsyybfyvdksnrpn")
    public suspend fun enablePrivateLinkFastPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePrivateLinkFastPath = mapped
    }

    /**
     * @param value Bypass ExpressRoute Gateway for data forwarding.
     */
    @JvmName("ipqsudojfvnrpsee")
    public suspend fun expressRouteGatewayBypass(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteGatewayBypass = mapped
    }

    /**
     * @param value GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("xofewkwdssurytpp")
    public suspend fun gatewayCustomBgpIpAddresses(`value`: List<GatewayCustomBgpIpAddressIpConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param argument GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("mpdydujdypnadgco")
    public suspend fun gatewayCustomBgpIpAddresses(argument: List<suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param argument GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("jnxuppjshbvhrpyk")
    public suspend fun gatewayCustomBgpIpAddresses(vararg argument: suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param argument GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("xvlaefuanstxadav")
    public suspend fun gatewayCustomBgpIpAddresses(argument: suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param values GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("tqiuuofilmcoapnl")
    public suspend fun gatewayCustomBgpIpAddresses(vararg values: GatewayCustomBgpIpAddressIpConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dwtjtmfvpnqkinfb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value List of ingress NatRules.
     */
    @JvmName("tmycoiqrknpxldbj")
    public suspend fun ingressNatRules(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("mokjjmbicdwbopjc")
    public suspend fun ingressNatRules(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("tosiduqgjmsprkjg")
    public suspend fun ingressNatRules(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("iawqmqvkhgygyqnf")
    public suspend fun ingressNatRules(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param values List of ingress NatRules.
     */
    @JvmName("glcpcndladacfmic")
    public suspend fun ingressNatRules(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingressNatRules = mapped
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("rsnnmifevqehflyw")
    public suspend fun ipsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("nrtxvomvfqdjvoll")
    public suspend fun ipsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("qxnohorembkhbows")
    public suspend fun ipsecPolicies(vararg argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("hflfkucqtwgjaarr")
    public suspend fun ipsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("uwyxnjgaqlfrdffq")
    public suspend fun ipsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param value The reference to local network gateway resource.
     */
    @JvmName("vptnrihdiynuwvrs")
    public suspend fun localNetworkGateway2(`value`: LocalNetworkGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localNetworkGateway2 = mapped
    }

    /**
     * @param argument The reference to local network gateway resource.
     */
    @JvmName("cwgldmtlrroqjyhx")
    public suspend fun localNetworkGateway2(argument: suspend LocalNetworkGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = LocalNetworkGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localNetworkGateway2 = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lskfskqvrmkvggps")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The reference to peerings resource.
     */
    @JvmName("gtcwrxqvkyojakgp")
    public suspend fun peer(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peer = mapped
    }

    /**
     * @param argument The reference to peerings resource.
     */
    @JvmName("phgdsfjxeumafsge")
    public suspend fun peer(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peer = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xommbiealfdfnbjq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The routing weight.
     */
    @JvmName("juxpmrviispifycp")
    public suspend fun routingWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingWeight = mapped
    }

    /**
     * @param value The IPSec shared key.
     */
    @JvmName("imcyiblkletixqvq")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ajgytqffchetnejs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bivdjvcrfebtmoee")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("wjkpprkoymlrbuli")
    public suspend fun trafficSelectorPolicies(`value`: List<TrafficSelectorPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("rjppybmakixagarl")
    public suspend fun trafficSelectorPolicies(argument: List<suspend TrafficSelectorPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrafficSelectorPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("lpdgdikactsdbjpc")
    public suspend fun trafficSelectorPolicies(vararg argument: suspend TrafficSelectorPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrafficSelectorPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("gweiwferepqfgkit")
    public suspend fun trafficSelectorPolicies(argument: suspend TrafficSelectorPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrafficSelectorPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param values The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("vqqsgcxkuclmylqv")
    public suspend fun trafficSelectorPolicies(vararg values: TrafficSelectorPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param value Use private local Azure IP for the connection.
     */
    @JvmName("hehbavgtvtextiuu")
    public suspend fun useLocalAzureIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLocalAzureIpAddress = mapped
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("mweuvkmsbtpwfesu")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePolicyBasedTrafficSelectors = mapped
    }

    /**
     * @param value The reference to virtual network gateway resource.
     */
    @JvmName("uiqwhomqypovjgvf")
    public suspend fun virtualNetworkGateway1(`value`: VirtualNetworkGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGateway1 = mapped
    }

    /**
     * @param argument The reference to virtual network gateway resource.
     */
    @JvmName("wpmfmkqjfwtkoiep")
    public suspend fun virtualNetworkGateway1(argument: suspend VirtualNetworkGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkGateway1 = mapped
    }

    /**
     * @param value The reference to virtual network gateway resource.
     */
    @JvmName("fnvfgwfxvlttvdoc")
    public suspend fun virtualNetworkGateway2(`value`: VirtualNetworkGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGateway2 = mapped
    }

    /**
     * @param argument The reference to virtual network gateway resource.
     */
    @JvmName("adhyldlankfidkci")
    public suspend fun virtualNetworkGateway2(argument: suspend VirtualNetworkGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkGateway2 = mapped
    }

    /**
     * @param value The name of the virtual network gateway connection.
     */
    @JvmName("jnqteccnwfhjuytt")
    public suspend fun virtualNetworkGatewayConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayConnectionName = mapped
    }

    internal fun build(): VirtualNetworkGatewayConnectionArgs = VirtualNetworkGatewayConnectionArgs(
        authorizationKey = authorizationKey,
        connectionMode = connectionMode,
        connectionProtocol = connectionProtocol,
        connectionType = connectionType,
        dpdTimeoutSeconds = dpdTimeoutSeconds,
        egressNatRules = egressNatRules,
        enableBgp = enableBgp,
        enablePrivateLinkFastPath = enablePrivateLinkFastPath,
        expressRouteGatewayBypass = expressRouteGatewayBypass,
        gatewayCustomBgpIpAddresses = gatewayCustomBgpIpAddresses,
        id = id,
        ingressNatRules = ingressNatRules,
        ipsecPolicies = ipsecPolicies,
        localNetworkGateway2 = localNetworkGateway2,
        location = location,
        peer = peer,
        resourceGroupName = resourceGroupName,
        routingWeight = routingWeight,
        sharedKey = sharedKey,
        tags = tags,
        trafficSelectorPolicies = trafficSelectorPolicies,
        useLocalAzureIpAddress = useLocalAzureIpAddress,
        usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors,
        virtualNetworkGateway1 = virtualNetworkGateway1,
        virtualNetworkGateway2 = virtualNetworkGateway2,
        virtualNetworkGatewayConnectionName = virtualNetworkGatewayConnectionName,
    )
}
