@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.VpnNatRuleMappingResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnNatRuleMappingResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VirtualNetworkGatewayNatRule].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayNatRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkGatewayNatRuleArgs = VirtualNetworkGatewayNatRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkGatewayNatRuleArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkGatewayNatRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualNetworkGatewayNatRule {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualNetworkGatewayNatRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetworkGatewayNatRule(builtJavaResource)
    }
}

/**
 * VirtualNetworkGatewayNatRule Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### VirtualNetworkGatewayNatRulePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkGatewayNatRule = new AzureNative.Network.VirtualNetworkGatewayNatRule("virtualNetworkGatewayNatRule", new()
 *     {
 *         ExternalMappings = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *             {
 *                 AddressSpace = "192.168.21.0/24",
 *                 PortRange = "300-400",
 *             },
 *         },
 *         InternalMappings = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *             {
 *                 AddressSpace = "10.4.0.0/24",
 *                 PortRange = "200-300",
 *             },
 *         },
 *         IpConfigurationId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/gateway1/ipConfigurations/default",
 *         Mode = AzureNative.Network.VpnNatRuleMode.EgressSnat,
 *         NatRuleName = "natRule1",
 *         ResourceGroupName = "rg1",
 *         Type = AzureNative.Network.VpnNatRuleType.Static,
 *         VirtualNetworkGatewayName = "gateway1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkGatewayNatRule(ctx, "virtualNetworkGatewayNatRule", &network.VirtualNetworkGatewayNatRuleArgs{
 * 			ExternalMappings: network.VpnNatRuleMappingArray{
 * 				&network.VpnNatRuleMappingArgs{
 * 					AddressSpace: pulumi.String("192.168.21.0/24"),
 * 					PortRange:    pulumi.String("300-400"),
 * 				},
 * 			},
 * 			InternalMappings: network.VpnNatRuleMappingArray{
 * 				&network.VpnNatRuleMappingArgs{
 * 					AddressSpace: pulumi.String("10.4.0.0/24"),
 * 					PortRange:    pulumi.String("200-300"),
 * 				},
 * 			},
 * 			IpConfigurationId:         pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/gateway1/ipConfigurations/default"),
 * 			Mode:                      pulumi.String(network.VpnNatRuleModeEgressSnat),
 * 			NatRuleName:               pulumi.String("natRule1"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			Type:                      pulumi.String(network.VpnNatRuleTypeStatic),
 * 			VirtualNetworkGatewayName: pulumi.String("gateway1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayNatRule;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayNatRuleArgs;
 * import com.pulumi.azurenative.network.inputs.VpnNatRuleMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkGatewayNatRule = new VirtualNetworkGatewayNatRule("virtualNetworkGatewayNatRule", VirtualNetworkGatewayNatRuleArgs.builder()
 *             .externalMappings(VpnNatRuleMappingArgs.builder()
 *                 .addressSpace("192.168.21.0/24")
 *                 .portRange("300-400")
 *                 .build())
 *             .internalMappings(VpnNatRuleMappingArgs.builder()
 *                 .addressSpace("10.4.0.0/24")
 *                 .portRange("200-300")
 *                 .build())
 *             .ipConfigurationId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/gateway1/ipConfigurations/default")
 *             .mode("EgressSnat")
 *             .natRuleName("natRule1")
 *             .resourceGroupName("rg1")
 *             .type("Static")
 *             .virtualNetworkGatewayName("gateway1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkGatewayNatRule natRule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules/{natRuleName}
 * ```
 */
public class VirtualNetworkGatewayNatRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualNetworkGatewayNatRule,
) : KotlinCustomResource(javaResource, VirtualNetworkGatewayNatRuleMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The private IP address external mapping for NAT.
     */
    public val externalMappings: Output<List<VpnNatRuleMappingResponse>>?
        get() = javaResource.externalMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The private IP address internal mapping for NAT.
     */
    public val internalMappings: Output<List<VpnNatRuleMappingResponse>>?
        get() = javaResource.internalMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The IP Configuration ID this NAT rule applies to.
     */
    public val ipConfigurationId: Output<String>?
        get() = javaResource.ipConfigurationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Source NAT direction of a VPN NAT.
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the NAT Rule resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualNetworkGatewayNatRuleMapper : ResourceMapper<VirtualNetworkGatewayNatRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualNetworkGatewayNatRule::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetworkGatewayNatRule =
        VirtualNetworkGatewayNatRule(
            javaResource as
                com.pulumi.azurenative.network.VirtualNetworkGatewayNatRule,
        )
}

/**
 * @see [VirtualNetworkGatewayNatRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetworkGatewayNatRule].
 */
public suspend fun virtualNetworkGatewayNatRule(
    name: String,
    block: suspend VirtualNetworkGatewayNatRuleResourceBuilder.() -> Unit,
): VirtualNetworkGatewayNatRule {
    val builder = VirtualNetworkGatewayNatRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetworkGatewayNatRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetworkGatewayNatRule(name: String): VirtualNetworkGatewayNatRule {
    val builder = VirtualNetworkGatewayNatRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
