@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualRouterArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VirtualRouter Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create VirtualRouter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualRouter = new AzureNative.Network.VirtualRouter("virtualRouter", new()
 *     {
 *         HostedGateway = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vnetGateway",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualRouterName = "virtualRouter",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualRouter(ctx, "virtualRouter", &network.VirtualRouterArgs{
 * 			HostedGateway: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vnetGateway"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualRouterName: pulumi.String("virtualRouter"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualRouter;
 * import com.pulumi.azurenative.network.VirtualRouterArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualRouter = new VirtualRouter("virtualRouter", VirtualRouterArgs.builder()
 *             .hostedGateway(SubResourceArgs.builder()
 *                 .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vnetGateway")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualRouterName("virtualRouter")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualRouter virtualRouter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}
 * ```
 * @property hostedGateway The Gateway on which VirtualRouter is hosted.
 * @property hostedSubnet The Subnet on which VirtualRouter is hosted.
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 * @property virtualRouterAsn VirtualRouter ASN.
 * @property virtualRouterIps VirtualRouter IPs.
 * @property virtualRouterName The name of the Virtual Router.
 */
public data class VirtualRouterArgs(
    public val hostedGateway: Output<SubResourceArgs>? = null,
    public val hostedSubnet: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualRouterAsn: Output<Double>? = null,
    public val virtualRouterIps: Output<List<String>>? = null,
    public val virtualRouterName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualRouterArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualRouterArgs =
        com.pulumi.azurenative.network.VirtualRouterArgs.builder()
            .hostedGateway(hostedGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostedSubnet(hostedSubnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualRouterAsn(virtualRouterAsn?.applyValue({ args0 -> args0 }))
            .virtualRouterIps(virtualRouterIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .virtualRouterName(virtualRouterName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualRouterArgs].
 */
@PulumiTagMarker
public class VirtualRouterArgsBuilder internal constructor() {
    private var hostedGateway: Output<SubResourceArgs>? = null

    private var hostedSubnet: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualRouterAsn: Output<Double>? = null

    private var virtualRouterIps: Output<List<String>>? = null

    private var virtualRouterName: Output<String>? = null

    /**
     * @param value The Gateway on which VirtualRouter is hosted.
     */
    @JvmName("lwdvsbyvxcnxqckg")
    public suspend fun hostedGateway(`value`: Output<SubResourceArgs>) {
        this.hostedGateway = value
    }

    /**
     * @param value The Subnet on which VirtualRouter is hosted.
     */
    @JvmName("xvgngypflmebvake")
    public suspend fun hostedSubnet(`value`: Output<SubResourceArgs>) {
        this.hostedSubnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gvcaxbcioionptrn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rrmcqynmwjhtuooe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lymhxthpdqmbsoer")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hjvrunevquawiedl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VirtualRouter ASN.
     */
    @JvmName("pwoakoqbbsdjskdu")
    public suspend fun virtualRouterAsn(`value`: Output<Double>) {
        this.virtualRouterAsn = value
    }

    /**
     * @param value VirtualRouter IPs.
     */
    @JvmName("xdnacdpingtagekj")
    public suspend fun virtualRouterIps(`value`: Output<List<String>>) {
        this.virtualRouterIps = value
    }

    @JvmName("qnopjxcorkkvhpuc")
    public suspend fun virtualRouterIps(vararg values: Output<String>) {
        this.virtualRouterIps = Output.all(values.asList())
    }

    /**
     * @param values VirtualRouter IPs.
     */
    @JvmName("jbgwiuqbiswrvsyg")
    public suspend fun virtualRouterIps(values: List<Output<String>>) {
        this.virtualRouterIps = Output.all(values)
    }

    /**
     * @param value The name of the Virtual Router.
     */
    @JvmName("ueovwveqakuwtbhl")
    public suspend fun virtualRouterName(`value`: Output<String>) {
        this.virtualRouterName = value
    }

    /**
     * @param value The Gateway on which VirtualRouter is hosted.
     */
    @JvmName("akrushsmdtcenpnl")
    public suspend fun hostedGateway(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostedGateway = mapped
    }

    /**
     * @param argument The Gateway on which VirtualRouter is hosted.
     */
    @JvmName("mrmiuxbrogrdqgme")
    public suspend fun hostedGateway(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostedGateway = mapped
    }

    /**
     * @param value The Subnet on which VirtualRouter is hosted.
     */
    @JvmName("btsrinnwbmkobxss")
    public suspend fun hostedSubnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostedSubnet = mapped
    }

    /**
     * @param argument The Subnet on which VirtualRouter is hosted.
     */
    @JvmName("ntscdkdcxupenoge")
    public suspend fun hostedSubnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostedSubnet = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bexjmsymmbwpufly")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vcclfqaswwyxthth")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("akblkioxdawfrmwo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xxkfewndxmombvxn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("upaabbjbpckouxaf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VirtualRouter ASN.
     */
    @JvmName("acskmbdhuqbqgqnw")
    public suspend fun virtualRouterAsn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualRouterAsn = mapped
    }

    /**
     * @param value VirtualRouter IPs.
     */
    @JvmName("lbgmqaitlmnweiar")
    public suspend fun virtualRouterIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualRouterIps = mapped
    }

    /**
     * @param values VirtualRouter IPs.
     */
    @JvmName("dacbsnygoykcnxyh")
    public suspend fun virtualRouterIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualRouterIps = mapped
    }

    /**
     * @param value The name of the Virtual Router.
     */
    @JvmName("xqrrmmehyxlylnbo")
    public suspend fun virtualRouterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualRouterName = mapped
    }

    internal fun build(): VirtualRouterArgs = VirtualRouterArgs(
        hostedGateway = hostedGateway,
        hostedSubnet = hostedSubnet,
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        virtualRouterAsn = virtualRouterAsn,
        virtualRouterIps = virtualRouterIps,
        virtualRouterName = virtualRouterName,
    )
}
