@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualRouterPeeringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Router Peering resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create Virtual Router Peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualRouterPeering = new AzureNative.Network.VirtualRouterPeering("virtualRouterPeering", new()
 *     {
 *         PeerAsn = 20000,
 *         PeerIp = "192.168.1.5",
 *         PeeringName = "peering1",
 *         ResourceGroupName = "rg1",
 *         VirtualRouterName = "virtualRouter",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualRouterPeering(ctx, "virtualRouterPeering", &network.VirtualRouterPeeringArgs{
 * 			PeerAsn:           pulumi.Float64(20000),
 * 			PeerIp:            pulumi.String("192.168.1.5"),
 * 			PeeringName:       pulumi.String("peering1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			VirtualRouterName: pulumi.String("virtualRouter"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualRouterPeering;
 * import com.pulumi.azurenative.network.VirtualRouterPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualRouterPeering = new VirtualRouterPeering("virtualRouterPeering", VirtualRouterPeeringArgs.builder()
 *             .peerAsn(20000)
 *             .peerIp("192.168.1.5")
 *             .peeringName("peering1")
 *             .resourceGroupName("rg1")
 *             .virtualRouterName("virtualRouter")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualRouterPeering peering1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}
 * ```
 * @property id Resource ID.
 * @property name Name of the virtual router peering that is unique within a virtual router.
 * @property peerAsn Peer ASN.
 * @property peerIp Peer IP.
 * @property peeringName The name of the Virtual Router Peering.
 * @property resourceGroupName The name of the resource group.
 * @property virtualRouterName The name of the Virtual Router.
 */
public data class VirtualRouterPeeringArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val peerAsn: Output<Double>? = null,
    public val peerIp: Output<String>? = null,
    public val peeringName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualRouterName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualRouterPeeringArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualRouterPeeringArgs =
        com.pulumi.azurenative.network.VirtualRouterPeeringArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .peerAsn(peerAsn?.applyValue({ args0 -> args0 }))
            .peerIp(peerIp?.applyValue({ args0 -> args0 }))
            .peeringName(peeringName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualRouterName(virtualRouterName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualRouterPeeringArgs].
 */
@PulumiTagMarker
public class VirtualRouterPeeringArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var peerAsn: Output<Double>? = null

    private var peerIp: Output<String>? = null

    private var peeringName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualRouterName: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ytpxiqfyncxsftup")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the virtual router peering that is unique within a virtual router.
     */
    @JvmName("qxguiqopdnoxasao")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Peer ASN.
     */
    @JvmName("hnibibykpvcwwjty")
    public suspend fun peerAsn(`value`: Output<Double>) {
        this.peerAsn = value
    }

    /**
     * @param value Peer IP.
     */
    @JvmName("gcsomaxvduushrol")
    public suspend fun peerIp(`value`: Output<String>) {
        this.peerIp = value
    }

    /**
     * @param value The name of the Virtual Router Peering.
     */
    @JvmName("klstvigeiieynykl")
    public suspend fun peeringName(`value`: Output<String>) {
        this.peeringName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qlixwsykqmfaeupa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Virtual Router.
     */
    @JvmName("iicwwlaygvrwdtbf")
    public suspend fun virtualRouterName(`value`: Output<String>) {
        this.virtualRouterName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vrgexucbwrllvrum")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the virtual router peering that is unique within a virtual router.
     */
    @JvmName("xvnelayqwlloxcqx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Peer ASN.
     */
    @JvmName("hivcavxcyjwonrko")
    public suspend fun peerAsn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param value Peer IP.
     */
    @JvmName("oimnoaokknxvuoju")
    public suspend fun peerIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerIp = mapped
    }

    /**
     * @param value The name of the Virtual Router Peering.
     */
    @JvmName("ehwpugotrnencrkf")
    public suspend fun peeringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vdvwtpssnuieukce")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Virtual Router.
     */
    @JvmName("okmqwmimjjweuifk")
    public suspend fun virtualRouterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualRouterName = mapped
    }

    internal fun build(): VirtualRouterPeeringArgs = VirtualRouterPeeringArgs(
        id = id,
        name = name,
        peerAsn = peerAsn,
        peerIp = peerIp,
        peeringName = peeringName,
        resourceGroupName = resourceGroupName,
        virtualRouterName = virtualRouterName,
    )
}
