@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VpnServerConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnAuthenticationType
import com.pulumi.azurenative.network.kotlin.enums.VpnGatewayTunnelingProtocol
import com.pulumi.azurenative.network.kotlin.inputs.AadAuthenticationParametersArgs
import com.pulumi.azurenative.network.kotlin.inputs.AadAuthenticationParametersArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.RadiusServerArgs
import com.pulumi.azurenative.network.kotlin.inputs.RadiusServerArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigRadiusClientRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigRadiusClientRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigRadiusServerRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigRadiusServerRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigVpnClientRevokedCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigVpnClientRevokedCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigVpnClientRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigVpnClientRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigurationPolicyGroupArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigurationPolicyGroupArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VpnServerConfiguration Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### VpnServerConfigurationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnServerConfiguration = new AzureNative.Network.VpnServerConfiguration("vpnServerConfiguration", new()
 *     {
 *         ConfigurationPolicyGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1",
 *                 IsDefault = true,
 *                 Name = "policyGroup1",
 *                 PolicyMembers = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *                     {
 *                         AttributeType = AzureNative.Network.VpnPolicyMemberAttributeType.RadiusAzureGroupId,
 *                         AttributeValue = "6ad1bd08",
 *                         Name = "policy1",
 *                     },
 *                 },
 *                 Priority = 0,
 *             },
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2",
 *                 IsDefault = true,
 *                 Name = "policyGroup2",
 *                 PolicyMembers = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *                     {
 *                         AttributeType = AzureNative.Network.VpnPolicyMemberAttributeType.CertificateGroupId,
 *                         AttributeValue = "red.com",
 *                         Name = "policy2",
 *                     },
 *                 },
 *                 Priority = 0,
 *             },
 *         },
 *         Location = "West US",
 *         RadiusClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigRadiusClientRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigRadiusClientRootCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         RadiusServerRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigRadiusServerRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigRadiusServerRootCer1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM",
 *             },
 *         },
 *         RadiusServers = new[]
 *         {
 *             new AzureNative.Network.Inputs.RadiusServerArgs
 *             {
 *                 RadiusServerAddress = "10.0.0.0",
 *                 RadiusServerScore = 25,
 *                 RadiusServerSecret = "radiusServerSecret",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VpnClientIpsecPolicies = new[]
 *         {
 *             new AzureNative.Network.Inputs.IpsecPolicyArgs
 *             {
 *                 DhGroup = AzureNative.Network.DhGroup.DHGroup14,
 *                 IkeEncryption = AzureNative.Network.IkeEncryption.AES256,
 *                 IkeIntegrity = AzureNative.Network.IkeIntegrity.SHA384,
 *                 IpsecEncryption = AzureNative.Network.IpsecEncryption.AES256,
 *                 IpsecIntegrity = AzureNative.Network.IpsecIntegrity.SHA256,
 *                 PfsGroup = AzureNative.Network.PfsGroup.PFS14,
 *                 SaDataSizeKilobytes = 429497,
 *                 SaLifeTimeSeconds = 86472,
 *             },
 *         },
 *         VpnClientRevokedCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigVpnClientRevokedCertificateArgs
 *             {
 *                 Name = "vpnServerConfigVpnClientRevokedCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         VpnClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigVpnClientRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigVpnClientRootCert1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN",
 *             },
 *         },
 *         VpnProtocols = new[]
 *         {
 *             AzureNative.Network.VpnGatewayTunnelingProtocol.IkeV2,
 *         },
 *         VpnServerConfigurationName = "vpnServerConfiguration1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVpnServerConfiguration(ctx, "vpnServerConfiguration", &network.VpnServerConfigurationArgs{
 * 			ConfigurationPolicyGroups: network.VpnServerConfigurationPolicyGroupArray{
 * 				&network.VpnServerConfigurationPolicyGroupArgs{
 * 					Id:        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
 * 					IsDefault: pulumi.Bool(true),
 * 					Name:      pulumi.String("policyGroup1"),
 * 					PolicyMembers: network.VpnServerConfigurationPolicyGroupMemberArray{
 * 						&network.VpnServerConfigurationPolicyGroupMemberArgs{
 * 							AttributeType:  pulumi.String(network.VpnPolicyMemberAttributeTypeRadiusAzureGroupId),
 * 							AttributeValue: pulumi.String("6ad1bd08"),
 * 							Name:           pulumi.String("policy1"),
 * 						},
 * 					},
 * 					Priority: pulumi.Int(0),
 * 				},
 * 				&network.VpnServerConfigurationPolicyGroupArgs{
 * 					Id:        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
 * 					IsDefault: pulumi.Bool(true),
 * 					Name:      pulumi.String("policyGroup2"),
 * 					PolicyMembers: network.VpnServerConfigurationPolicyGroupMemberArray{
 * 						&network.VpnServerConfigurationPolicyGroupMemberArgs{
 * 							AttributeType:  pulumi.String(network.VpnPolicyMemberAttributeTypeCertificateGroupId),
 * 							AttributeValue: pulumi.String("red.com"),
 * 							Name:           pulumi.String("policy2"),
 * 						},
 * 					},
 * 					Priority: pulumi.Int(0),
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			RadiusClientRootCertificates: network.VpnServerConfigRadiusClientRootCertificateArray{
 * 				&network.VpnServerConfigRadiusClientRootCertificateArgs{
 * 					Name:       pulumi.String("vpnServerConfigRadiusClientRootCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			RadiusServerRootCertificates: network.VpnServerConfigRadiusServerRootCertificateArray{
 * 				&network.VpnServerConfigRadiusServerRootCertificateArgs{
 * 					Name:           pulumi.String("vpnServerConfigRadiusServerRootCer1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
 * 				},
 * 			},
 * 			RadiusServers: network.RadiusServerArray{
 * 				&network.RadiusServerArgs{
 * 					RadiusServerAddress: pulumi.String("10.0.0.0"),
 * 					RadiusServerScore:   pulumi.Float64(25),
 * 					RadiusServerSecret:  pulumi.String("radiusServerSecret"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VpnClientIpsecPolicies: network.IpsecPolicyArray{
 * 				&network.IpsecPolicyArgs{
 * 					DhGroup:             pulumi.String(network.DhGroupDHGroup14),
 * 					IkeEncryption:       pulumi.String(network.IkeEncryptionAES256),
 * 					IkeIntegrity:        pulumi.String(network.IkeIntegritySHA384),
 * 					IpsecEncryption:     pulumi.String(network.IpsecEncryptionAES256),
 * 					IpsecIntegrity:      pulumi.String(network.IpsecIntegritySHA256),
 * 					PfsGroup:            pulumi.String(network.PfsGroupPFS14),
 * 					SaDataSizeKilobytes: pulumi.Int(429497),
 * 					SaLifeTimeSeconds:   pulumi.Int(86472),
 * 				},
 * 			},
 * 			VpnClientRevokedCertificates: network.VpnServerConfigVpnClientRevokedCertificateArray{
 * 				&network.VpnServerConfigVpnClientRevokedCertificateArgs{
 * 					Name:       pulumi.String("vpnServerConfigVpnClientRevokedCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			VpnClientRootCertificates: network.VpnServerConfigVpnClientRootCertificateArray{
 * 				&network.VpnServerConfigVpnClientRootCertificateArgs{
 * 					Name:           pulumi.String("vpnServerConfigVpnClientRootCert1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
 * 				},
 * 			},
 * 			VpnProtocols: pulumi.StringArray{
 * 				pulumi.String(network.VpnGatewayTunnelingProtocolIkeV2),
 * 			},
 * 			VpnServerConfigurationName: pulumi.String("vpnServerConfiguration1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnServerConfiguration;
 * import com.pulumi.azurenative.network.VpnServerConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupArgs;
 * import com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusClientRootCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusServerRootCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.RadiusServerArgs;
 * import com.pulumi.azurenative.network.inputs.IpsecPolicyArgs;
 * import com.pulumi.azurenative.network.inputs.VpnServerConfigVpnClientRevokedCertificateArgs;
 * import com.pulumi.azurenative.network.inputs.VpnServerConfigVpnClientRootCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnServerConfiguration = new VpnServerConfiguration("vpnServerConfiguration", VpnServerConfigurationArgs.builder()
 *             .configurationPolicyGroups(
 *                 VpnServerConfigurationPolicyGroupArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1")
 *                     .isDefault(true)
 *                     .name("policyGroup1")
 *                     .policyMembers(VpnServerConfigurationPolicyGroupMemberArgs.builder()
 *                         .attributeType("RadiusAzureGroupId")
 *                         .attributeValue("6ad1bd08")
 *                         .name("policy1")
 *                         .build())
 *                     .priority(0)
 *                     .build(),
 *                 VpnServerConfigurationPolicyGroupArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2")
 *                     .isDefault(true)
 *                     .name("policyGroup2")
 *                     .policyMembers(VpnServerConfigurationPolicyGroupMemberArgs.builder()
 *                         .attributeType("CertificateGroupId")
 *                         .attributeValue("red.com")
 *                         .name("policy2")
 *                         .build())
 *                     .priority(0)
 *                     .build())
 *             .location("West US")
 *             .radiusClientRootCertificates(VpnServerConfigRadiusClientRootCertificateArgs.builder()
 *                 .name("vpnServerConfigRadiusClientRootCert1")
 *                 .thumbprint("83FFBFC8848B5A5836C94D0112367E16148A286F")
 *                 .build())
 *             .radiusServerRootCertificates(VpnServerConfigRadiusServerRootCertificateArgs.builder()
 *                 .name("vpnServerConfigRadiusServerRootCer1")
 *                 .publicCertData("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM")
 *                 .build())
 *             .radiusServers(RadiusServerArgs.builder()
 *                 .radiusServerAddress("10.0.0.0")
 *                 .radiusServerScore(25)
 *                 .radiusServerSecret("radiusServerSecret")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .vpnClientIpsecPolicies(IpsecPolicyArgs.builder()
 *                 .dhGroup("DHGroup14")
 *                 .ikeEncryption("AES256")
 *                 .ikeIntegrity("SHA384")
 *                 .ipsecEncryption("AES256")
 *                 .ipsecIntegrity("SHA256")
 *                 .pfsGroup("PFS14")
 *                 .saDataSizeKilobytes(429497)
 *                 .saLifeTimeSeconds(86472)
 *                 .build())
 *             .vpnClientRevokedCertificates(VpnServerConfigVpnClientRevokedCertificateArgs.builder()
 *                 .name("vpnServerConfigVpnClientRevokedCert1")
 *                 .thumbprint("83FFBFC8848B5A5836C94D0112367E16148A286F")
 *                 .build())
 *             .vpnClientRootCertificates(VpnServerConfigVpnClientRootCertificateArgs.builder()
 *                 .name("vpnServerConfigVpnClientRootCert1")
 *                 .publicCertData("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN")
 *                 .build())
 *             .vpnProtocols("IkeV2")
 *             .vpnServerConfigurationName("vpnServerConfiguration1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnServerConfiguration vpnServerConfiguration1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}
 * ```
 * @property aadAuthenticationParameters The set of aad vpn authentication parameters.
 * @property configurationPolicyGroups List of all VpnServerConfigurationPolicyGroups.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the VpnServerConfiguration that is unique within a resource group.
 * @property radiusClientRootCertificates Radius client root certificate of VpnServerConfiguration.
 * @property radiusServerAddress The radius server address property of the VpnServerConfiguration resource for point to site client connection.
 * @property radiusServerRootCertificates Radius Server root certificate of VpnServerConfiguration.
 * @property radiusServerSecret The radius secret property of the VpnServerConfiguration resource for point to site client connection.
 * @property radiusServers Multiple Radius Server configuration for VpnServerConfiguration.
 * @property resourceGroupName The resource group name of the VpnServerConfiguration.
 * @property tags Resource tags.
 * @property vpnAuthenticationTypes VPN authentication types for the VpnServerConfiguration.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for VpnServerConfiguration.
 * @property vpnClientRevokedCertificates VPN client revoked certificate of VpnServerConfiguration.
 * @property vpnClientRootCertificates VPN client root certificate of VpnServerConfiguration.
 * @property vpnProtocols VPN protocols for the VpnServerConfiguration.
 * @property vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
 */
public data class VpnServerConfigurationArgs(
    public val aadAuthenticationParameters: Output<AadAuthenticationParametersArgs>? = null,
    public val configurationPolicyGroups: Output<List<VpnServerConfigurationPolicyGroupArgs>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val radiusClientRootCertificates: Output<List<VpnServerConfigRadiusClientRootCertificateArgs>>? = null,
    public val radiusServerAddress: Output<String>? = null,
    public val radiusServerRootCertificates: Output<List<VpnServerConfigRadiusServerRootCertificateArgs>>? = null,
    public val radiusServerSecret: Output<String>? = null,
    public val radiusServers: Output<List<RadiusServerArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null,
    public val vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val vpnClientRevokedCertificates: Output<List<VpnServerConfigVpnClientRevokedCertificateArgs>>? = null,
    public val vpnClientRootCertificates: Output<List<VpnServerConfigVpnClientRootCertificateArgs>>? =
        null,
    public val vpnProtocols: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>? = null,
    public val vpnServerConfigurationName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VpnServerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VpnServerConfigurationArgs =
        com.pulumi.azurenative.network.VpnServerConfigurationArgs.builder()
            .aadAuthenticationParameters(
                aadAuthenticationParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .configurationPolicyGroups(
                configurationPolicyGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .radiusClientRootCertificates(
                radiusClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .radiusServerAddress(radiusServerAddress?.applyValue({ args0 -> args0 }))
            .radiusServerRootCertificates(
                radiusServerRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .radiusServerSecret(radiusServerSecret?.applyValue({ args0 -> args0 }))
            .radiusServers(
                radiusServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpnAuthenticationTypes(
                vpnAuthenticationTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnClientIpsecPolicies(
                vpnClientIpsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnClientRevokedCertificates(
                vpnClientRevokedCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnClientRootCertificates(
                vpnClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnProtocols(
                vpnProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnServerConfigurationName(vpnServerConfigurationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnServerConfigurationArgs].
 */
@PulumiTagMarker
public class VpnServerConfigurationArgsBuilder internal constructor() {
    private var aadAuthenticationParameters: Output<AadAuthenticationParametersArgs>? = null

    private var configurationPolicyGroups: Output<List<VpnServerConfigurationPolicyGroupArgs>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var radiusClientRootCertificates:
        Output<List<VpnServerConfigRadiusClientRootCertificateArgs>>? = null

    private var radiusServerAddress: Output<String>? = null

    private var radiusServerRootCertificates:
        Output<List<VpnServerConfigRadiusServerRootCertificateArgs>>? = null

    private var radiusServerSecret: Output<String>? = null

    private var radiusServers: Output<List<RadiusServerArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null

    private var vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var vpnClientRevokedCertificates:
        Output<List<VpnServerConfigVpnClientRevokedCertificateArgs>>? = null

    private var vpnClientRootCertificates: Output<List<VpnServerConfigVpnClientRootCertificateArgs>>? =
        null

    private var vpnProtocols: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>? = null

    private var vpnServerConfigurationName: Output<String>? = null

    /**
     * @param value The set of aad vpn authentication parameters.
     */
    @JvmName("qvomlpayxyfvxhba")
    public suspend fun aadAuthenticationParameters(`value`: Output<AadAuthenticationParametersArgs>) {
        this.aadAuthenticationParameters = value
    }

    /**
     * @param value List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xwddafdaxydqvvxl")
    public suspend fun configurationPolicyGroups(`value`: Output<List<VpnServerConfigurationPolicyGroupArgs>>) {
        this.configurationPolicyGroups = value
    }

    @JvmName("ucvlyhlfckwbtkwp")
    public suspend fun configurationPolicyGroups(vararg values: Output<VpnServerConfigurationPolicyGroupArgs>) {
        this.configurationPolicyGroups = Output.all(values.asList())
    }

    /**
     * @param values List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("huctdjntqebyllxc")
    public suspend fun configurationPolicyGroups(values: List<Output<VpnServerConfigurationPolicyGroupArgs>>) {
        this.configurationPolicyGroups = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("aqxewfpivvmtkmnu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("cleqmtishcuekafn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the VpnServerConfiguration that is unique within a resource group.
     */
    @JvmName("ifcpmtdaekpksxbs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("lxemvpltleqilspq")
    public suspend fun radiusClientRootCertificates(`value`: Output<List<VpnServerConfigRadiusClientRootCertificateArgs>>) {
        this.radiusClientRootCertificates = value
    }

    @JvmName("fxnvejwrgbwqbuee")
    public suspend fun radiusClientRootCertificates(vararg values: Output<VpnServerConfigRadiusClientRootCertificateArgs>) {
        this.radiusClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("fygndgomsxmanijx")
    public suspend fun radiusClientRootCertificates(values: List<Output<VpnServerConfigRadiusClientRootCertificateArgs>>) {
        this.radiusClientRootCertificates = Output.all(values)
    }

    /**
     * @param value The radius server address property of the VpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("ckeuouujrpvrssyl")
    public suspend fun radiusServerAddress(`value`: Output<String>) {
        this.radiusServerAddress = value
    }

    /**
     * @param value Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("qpwwtqgfjlaqvomb")
    public suspend fun radiusServerRootCertificates(`value`: Output<List<VpnServerConfigRadiusServerRootCertificateArgs>>) {
        this.radiusServerRootCertificates = value
    }

    @JvmName("enkgprfplkyviugf")
    public suspend fun radiusServerRootCertificates(vararg values: Output<VpnServerConfigRadiusServerRootCertificateArgs>) {
        this.radiusServerRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("qlrfvmmwxblikyma")
    public suspend fun radiusServerRootCertificates(values: List<Output<VpnServerConfigRadiusServerRootCertificateArgs>>) {
        this.radiusServerRootCertificates = Output.all(values)
    }

    /**
     * @param value The radius secret property of the VpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("yuynfyllkqfdqemb")
    public suspend fun radiusServerSecret(`value`: Output<String>) {
        this.radiusServerSecret = value
    }

    /**
     * @param value Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("lrnuqqkmqogbpcrv")
    public suspend fun radiusServers(`value`: Output<List<RadiusServerArgs>>) {
        this.radiusServers = value
    }

    @JvmName("upencespmcniiqhu")
    public suspend fun radiusServers(vararg values: Output<RadiusServerArgs>) {
        this.radiusServers = Output.all(values.asList())
    }

    /**
     * @param values Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("ppdowwymjrisvryl")
    public suspend fun radiusServers(values: List<Output<RadiusServerArgs>>) {
        this.radiusServers = Output.all(values)
    }

    /**
     * @param value The resource group name of the VpnServerConfiguration.
     */
    @JvmName("nlknarykntvujdxr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rjskfwuqmmmhieeb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VPN authentication types for the VpnServerConfiguration.
     */
    @JvmName("sdudtppdvsatyoij")
    public suspend fun vpnAuthenticationTypes(`value`: Output<List<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = value
    }

    @JvmName("vgixfwxqpconvujh")
    public suspend fun vpnAuthenticationTypes(vararg values: Output<Either<String, VpnAuthenticationType>>) {
        this.vpnAuthenticationTypes = Output.all(values.asList())
    }

    /**
     * @param values VPN authentication types for the VpnServerConfiguration.
     */
    @JvmName("duuwkvswxsisvbcs")
    public suspend fun vpnAuthenticationTypes(values: List<Output<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = Output.all(values)
    }

    /**
     * @param value VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("ylalvsnoclldevyp")
    public suspend fun vpnClientIpsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = value
    }

    @JvmName("luqxdfegdjkhkpoq")
    public suspend fun vpnClientIpsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.vpnClientIpsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("goaxpajxgqapovld")
    public suspend fun vpnClientIpsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = Output.all(values)
    }

    /**
     * @param value VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("ujxffacpuuoxqqxc")
    public suspend fun vpnClientRevokedCertificates(`value`: Output<List<VpnServerConfigVpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = value
    }

    @JvmName("qmgxaanalwtlsxfd")
    public suspend fun vpnClientRevokedCertificates(vararg values: Output<VpnServerConfigVpnClientRevokedCertificateArgs>) {
        this.vpnClientRevokedCertificates = Output.all(values.asList())
    }

    /**
     * @param values VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("sbuhjwlekqfgxxxa")
    public suspend fun vpnClientRevokedCertificates(values: List<Output<VpnServerConfigVpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = Output.all(values)
    }

    /**
     * @param value VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("apowdofwcdcfbveh")
    public suspend fun vpnClientRootCertificates(`value`: Output<List<VpnServerConfigVpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = value
    }

    @JvmName("rnxqblnoolakclik")
    public suspend fun vpnClientRootCertificates(vararg values: Output<VpnServerConfigVpnClientRootCertificateArgs>) {
        this.vpnClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("shgcxxuqqethglic")
    public suspend fun vpnClientRootCertificates(values: List<Output<VpnServerConfigVpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = Output.all(values)
    }

    /**
     * @param value VPN protocols for the VpnServerConfiguration.
     */
    @JvmName("douogdvwecppbgwr")
    public suspend fun vpnProtocols(`value`: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>) {
        this.vpnProtocols = value
    }

    @JvmName("wndeogiofljtawrv")
    public suspend fun vpnProtocols(vararg values: Output<Either<String, VpnGatewayTunnelingProtocol>>) {
        this.vpnProtocols = Output.all(values.asList())
    }

    /**
     * @param values VPN protocols for the VpnServerConfiguration.
     */
    @JvmName("nautvimrgokklujw")
    public suspend fun vpnProtocols(values: List<Output<Either<String, VpnGatewayTunnelingProtocol>>>) {
        this.vpnProtocols = Output.all(values)
    }

    /**
     * @param value The name of the VpnServerConfiguration being created or updated.
     */
    @JvmName("ihjupklmrsvcgdob")
    public suspend fun vpnServerConfigurationName(`value`: Output<String>) {
        this.vpnServerConfigurationName = value
    }

    /**
     * @param value The set of aad vpn authentication parameters.
     */
    @JvmName("crsoujinuwyebqjr")
    public suspend fun aadAuthenticationParameters(`value`: AadAuthenticationParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAuthenticationParameters = mapped
    }

    /**
     * @param argument The set of aad vpn authentication parameters.
     */
    @JvmName("mgbtfskoqfigecaf")
    public suspend fun aadAuthenticationParameters(argument: suspend AadAuthenticationParametersArgsBuilder.() -> Unit) {
        val toBeMapped = AadAuthenticationParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadAuthenticationParameters = mapped
    }

    /**
     * @param value List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("rdcocqpmqfufhmwg")
    public suspend fun configurationPolicyGroups(`value`: List<VpnServerConfigurationPolicyGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param argument List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("aqpssulyxhyprmvb")
    public suspend fun configurationPolicyGroups(argument: List<suspend VpnServerConfigurationPolicyGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigurationPolicyGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param argument List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("lsnfhlviaemlyplp")
    public suspend fun configurationPolicyGroups(vararg argument: suspend VpnServerConfigurationPolicyGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigurationPolicyGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param argument List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("qqbkkrxysecyllka")
    public suspend fun configurationPolicyGroups(argument: suspend VpnServerConfigurationPolicyGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigurationPolicyGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param values List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("vqkfupwwkwyislbq")
    public suspend fun configurationPolicyGroups(vararg values: VpnServerConfigurationPolicyGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("koxqkfevohomjjcy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("pdbeymcrvdpgavdt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the VpnServerConfiguration that is unique within a resource group.
     */
    @JvmName("kemijflbvdeemuup")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("kxemjreymdcskmfh")
    public suspend fun radiusClientRootCertificates(`value`: List<VpnServerConfigRadiusClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("hvptbcwkvlhtgbeh")
    public suspend fun radiusClientRootCertificates(argument: List<suspend VpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("ucchtpyskgolrrdd")
    public suspend fun radiusClientRootCertificates(vararg argument: suspend VpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("wntlixkjqtlpuunc")
    public suspend fun radiusClientRootCertificates(argument: suspend VpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param values Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("cnxsfuhrdyjcqgjs")
    public suspend fun radiusClientRootCertificates(vararg values: VpnServerConfigRadiusClientRootCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param value The radius server address property of the VpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("meytvwyspjjmqadp")
    public suspend fun radiusServerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerAddress = mapped
    }

    /**
     * @param value Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("rrysimpltailqhhm")
    public suspend fun radiusServerRootCertificates(`value`: List<VpnServerConfigRadiusServerRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("shexmftmwniahvby")
    public suspend fun radiusServerRootCertificates(argument: List<suspend VpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("rwejynrtuiseobup")
    public suspend fun radiusServerRootCertificates(vararg argument: suspend VpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("iawniguqioemrpvo")
    public suspend fun radiusServerRootCertificates(argument: suspend VpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param values Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("vxjeicxkmmsfaqxi")
    public suspend fun radiusServerRootCertificates(vararg values: VpnServerConfigRadiusServerRootCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param value The radius secret property of the VpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("smjtckyifqbnbscp")
    public suspend fun radiusServerSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerSecret = mapped
    }

    /**
     * @param value Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("uymgegdajiugvtym")
    public suspend fun radiusServers(`value`: List<RadiusServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param argument Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("bdtdwuhbqjkslxtf")
    public suspend fun radiusServers(argument: List<suspend RadiusServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("gskoifrkhsmxpgif")
    public suspend fun radiusServers(vararg argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("gwnxjqjgwrdsuedf")
    public suspend fun radiusServers(argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RadiusServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param values Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("dvxcntkqocndgnjs")
    public suspend fun radiusServers(vararg values: RadiusServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param value The resource group name of the VpnServerConfiguration.
     */
    @JvmName("omdontuvlvjtwbxe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xaoudlamtsmjdrgo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cvqojncksrkuodsa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VPN authentication types for the VpnServerConfiguration.
     */
    @JvmName("rprtrwafguucqvan")
    public suspend fun vpnAuthenticationTypes(`value`: List<Either<String, VpnAuthenticationType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param values VPN authentication types for the VpnServerConfiguration.
     */
    @JvmName("hcimonnxiarppiyg")
    public suspend fun vpnAuthenticationTypes(vararg values: Either<String, VpnAuthenticationType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param value VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("ebcuvavgdpousqqf")
    public suspend fun vpnClientIpsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("ehwtbudwdsanvxbu")
    public suspend fun vpnClientIpsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("titwqusokahwiabh")
    public suspend fun vpnClientIpsecPolicies(vararg argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("gstiybafwipefgrq")
    public suspend fun vpnClientIpsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param values VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("uuqxahuyrlnuvceg")
    public suspend fun vpnClientIpsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param value VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("yunwrfkwyhmniqvi")
    public suspend fun vpnClientRevokedCertificates(`value`: List<VpnServerConfigVpnClientRevokedCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("abtridhoxnqhsucu")
    public suspend fun vpnClientRevokedCertificates(argument: List<suspend VpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("pqqslwiyeassttyq")
    public suspend fun vpnClientRevokedCertificates(vararg argument: suspend VpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("ijlyxopnvagvmaim")
    public suspend fun vpnClientRevokedCertificates(argument: suspend VpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param values VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("icqgwwsrulddeyci")
    public suspend fun vpnClientRevokedCertificates(vararg values: VpnServerConfigVpnClientRevokedCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param value VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("mskjmotxdriehhoi")
    public suspend fun vpnClientRootCertificates(`value`: List<VpnServerConfigVpnClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("trhlnriqqjftvfis")
    public suspend fun vpnClientRootCertificates(argument: List<suspend VpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("dwgnaufsrpkysrff")
    public suspend fun vpnClientRootCertificates(vararg argument: suspend VpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("riuymjlvlgnoqvwo")
    public suspend fun vpnClientRootCertificates(argument: suspend VpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param values VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("yqjaxhgrhpencsim")
    public suspend fun vpnClientRootCertificates(vararg values: VpnServerConfigVpnClientRootCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param value VPN protocols for the VpnServerConfiguration.
     */
    @JvmName("hvvgecmborgsgyqq")
    public suspend fun vpnProtocols(`value`: List<Either<String, VpnGatewayTunnelingProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnProtocols = mapped
    }

    /**
     * @param values VPN protocols for the VpnServerConfiguration.
     */
    @JvmName("uuuyjimgdofnbeji")
    public suspend fun vpnProtocols(vararg values: Either<String, VpnGatewayTunnelingProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnProtocols = mapped
    }

    /**
     * @param value The name of the VpnServerConfiguration being created or updated.
     */
    @JvmName("xwjnasnbtyhhsocm")
    public suspend fun vpnServerConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnServerConfigurationName = mapped
    }

    internal fun build(): VpnServerConfigurationArgs = VpnServerConfigurationArgs(
        aadAuthenticationParameters = aadAuthenticationParameters,
        configurationPolicyGroups = configurationPolicyGroups,
        id = id,
        location = location,
        name = name,
        radiusClientRootCertificates = radiusClientRootCertificates,
        radiusServerAddress = radiusServerAddress,
        radiusServerRootCertificates = radiusServerRootCertificates,
        radiusServerSecret = radiusServerSecret,
        radiusServers = radiusServers,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vpnAuthenticationTypes = vpnAuthenticationTypes,
        vpnClientIpsecPolicies = vpnClientIpsecPolicies,
        vpnClientRevokedCertificates = vpnClientRevokedCertificates,
        vpnClientRootCertificates = vpnClientRootCertificates,
        vpnProtocols = vpnProtocols,
        vpnServerConfigurationName = vpnServerConfigurationName,
    )
}
