@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ManagedRulesDefinitionArgs
import com.pulumi.azurenative.network.kotlin.inputs.ManagedRulesDefinitionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PolicySettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.PolicySettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.WebApplicationFirewallCustomRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.WebApplicationFirewallCustomRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines web application firewall policy.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Creates or updates a WAF policy within a resource group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webApplicationFirewallPolicy = new AzureNative.Network.WebApplicationFirewallPolicy("webApplicationFirewallPolicy", new()
 *     {
 *         CustomRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = AzureNative.Network.WebApplicationFirewallAction.Block,
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = AzureNative.Network.WebApplicationFirewallMatchVariable.RemoteAddr,
 *                             },
 *                         },
 *                         Operator = AzureNative.Network.WebApplicationFirewallOperator.IPMatch,
 *                     },
 *                 },
 *                 Name = "Rule1",
 *                 Priority = 1,
 *                 RuleType = AzureNative.Network.WebApplicationFirewallRuleType.MatchRule,
 *             },
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = AzureNative.Network.WebApplicationFirewallAction.Block,
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = AzureNative.Network.WebApplicationFirewallMatchVariable.RemoteAddr,
 *                             },
 *                         },
 *                         Operator = AzureNative.Network.WebApplicationFirewallOperator.IPMatch,
 *                     },
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "Windows",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 Selector = "UserAgent",
 *                                 VariableName = AzureNative.Network.WebApplicationFirewallMatchVariable.RequestHeaders,
 *                             },
 *                         },
 *                         Operator = AzureNative.Network.WebApplicationFirewallOperator.Contains,
 *                     },
 *                 },
 *                 Name = "Rule2",
 *                 Priority = 2,
 *                 RuleType = AzureNative.Network.WebApplicationFirewallRuleType.MatchRule,
 *             },
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = AzureNative.Network.WebApplicationFirewallAction.Block,
 *                 GroupByUserSession = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.GroupByUserSessionArgs
 *                     {
 *                         GroupByVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.GroupByVariableArgs
 *                             {
 *                                 VariableName = AzureNative.Network.ApplicationGatewayFirewallUserSessionVariable.ClientAddr,
 *                             },
 *                         },
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = AzureNative.Network.WebApplicationFirewallMatchVariable.RemoteAddr,
 *                             },
 *                         },
 *                         NegationConditon = true,
 *                         Operator = AzureNative.Network.WebApplicationFirewallOperator.IPMatch,
 *                     },
 *                 },
 *                 Name = "RateLimitRule3",
 *                 Priority = 3,
 *                 RateLimitDuration = AzureNative.Network.ApplicationGatewayFirewallRateLimitDuration.OneMin,
 *                 RateLimitThreshold = 10,
 *                 RuleType = AzureNative.Network.WebApplicationFirewallRuleType.RateLimitRule,
 *             },
 *         },
 *         Location = "WestUs",
 *         ManagedRules = new AzureNative.Network.Inputs.ManagedRulesDefinitionArgs
 *         {
 *             Exclusions = new[]
 *             {
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     ExclusionManagedRuleSets = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ExclusionManagedRuleSetArgs
 *                         {
 *                             RuleGroups = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ExclusionManagedRuleGroupArgs
 *                                 {
 *                                     RuleGroupName = "REQUEST-930-APPLICATION-ATTACK-LFI",
 *                                     Rules = new[]
 *                                     {
 *                                         new AzureNative.Network.Inputs.ExclusionManagedRuleArgs
 *                                         {
 *                                             RuleId = "930120",
 *                                         },
 *                                     },
 *                                 },
 *                                 new AzureNative.Network.Inputs.ExclusionManagedRuleGroupArgs
 *                                 {
 *                                     RuleGroupName = "REQUEST-932-APPLICATION-ATTACK-RCE",
 *                                 },
 *                             },
 *                             RuleSetType = "OWASP",
 *                             RuleSetVersion = "3.2",
 *                         },
 *                     },
 *                     MatchVariable = AzureNative.Network.OwaspCrsExclusionEntryMatchVariable.RequestArgNames,
 *                     Selector = "hello",
 *                     SelectorMatchOperator = AzureNative.Network.OwaspCrsExclusionEntrySelectorMatchOperator.StartsWith,
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     ExclusionManagedRuleSets = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ExclusionManagedRuleSetArgs
 *                         {
 *                             RuleGroups = new() { },
 *                             RuleSetType = "OWASP",
 *                             RuleSetVersion = "3.1",
 *                         },
 *                     },
 *                     MatchVariable = AzureNative.Network.OwaspCrsExclusionEntryMatchVariable.RequestArgNames,
 *                     Selector = "hello",
 *                     SelectorMatchOperator = AzureNative.Network.OwaspCrsExclusionEntrySelectorMatchOperator.EndsWith,
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     MatchVariable = AzureNative.Network.OwaspCrsExclusionEntryMatchVariable.RequestArgNames,
 *                     Selector = "test",
 *                     SelectorMatchOperator = AzureNative.Network.OwaspCrsExclusionEntrySelectorMatchOperator.StartsWith,
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     MatchVariable = AzureNative.Network.OwaspCrsExclusionEntryMatchVariable.RequestArgValues,
 *                     Selector = "test",
 *                     SelectorMatchOperator = AzureNative.Network.OwaspCrsExclusionEntrySelectorMatchOperator.StartsWith,
 *                 },
 *             },
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Network.Inputs.ManagedRuleSetArgs
 *                 {
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ManagedRuleGroupOverrideArgs
 *                         {
 *                             RuleGroupName = "REQUEST-931-APPLICATION-ATTACK-RFI",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = AzureNative.Network.ActionType.Log,
 *                                     RuleId = "931120",
 *                                     State = AzureNative.Network.ManagedRuleEnabledState.Enabled,
 *                                 },
 *                                 new AzureNative.Network.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = AzureNative.Network.ActionType.AnomalyScoring,
 *                                     RuleId = "931130",
 *                                     State = AzureNative.Network.ManagedRuleEnabledState.Disabled,
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetType = "OWASP",
 *                     RuleSetVersion = "3.2",
 *                 },
 *             },
 *         },
 *         PolicyName = "Policy1",
 *         PolicySettings = new AzureNative.Network.Inputs.PolicySettingsArgs
 *         {
 *             LogScrubbing = new AzureNative.Network.Inputs.PolicySettingsLogScrubbingArgs
 *             {
 *                 ScrubbingRules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.WebApplicationFirewallScrubbingRulesArgs
 *                     {
 *                         MatchVariable = AzureNative.Network.ScrubbingRuleEntryMatchVariable.RequestArgNames,
 *                         Selector = "test",
 *                         SelectorMatchOperator = AzureNative.Network.ScrubbingRuleEntryMatchOperator.EqualsValue,
 *                         State = AzureNative.Network.ScrubbingRuleEntryState.Enabled,
 *                     },
 *                     new AzureNative.Network.Inputs.WebApplicationFirewallScrubbingRulesArgs
 *                     {
 *                         MatchVariable = AzureNative.Network.ScrubbingRuleEntryMatchVariable.RequestIPAddress,
 *                         SelectorMatchOperator = AzureNative.Network.ScrubbingRuleEntryMatchOperator.EqualsAny,
 *                         State = AzureNative.Network.ScrubbingRuleEntryState.Enabled,
 *                     },
 *                 },
 *                 State = AzureNative.Network.WebApplicationFirewallScrubbingState.Enabled,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewWebApplicationFirewallPolicy(ctx, "webApplicationFirewallPolicy", &network.WebApplicationFirewallPolicyArgs{
 * 			CustomRules: network.WebApplicationFirewallCustomRuleArray{
 * 				&network.WebApplicationFirewallCustomRuleArgs{
 * 					Action: pulumi.String(network.WebApplicationFirewallActionBlock),
 * 					MatchConditions: network.MatchConditionArray{
 * 						&network.MatchConditionArgs{
 * 							MatchValues: pulumi.StringArray{
 * 								pulumi.String("192.168.1.0/24"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							MatchVariables: network.MatchVariableArray{
 * 								&network.MatchVariableArgs{
 * 									VariableName: pulumi.String(network.WebApplicationFirewallMatchVariableRemoteAddr),
 * 								},
 * 							},
 * 							Operator: pulumi.String(network.WebApplicationFirewallOperatorIPMatch),
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule1"),
 * 					Priority: pulumi.Int(1),
 * 					RuleType: pulumi.String(network.WebApplicationFirewallRuleTypeMatchRule),
 * 				},
 * 				&network.WebApplicationFirewallCustomRuleArgs{
 * 					Action: pulumi.String(network.WebApplicationFirewallActionBlock),
 * 					MatchConditions: network.MatchConditionArray{
 * 						&network.MatchConditionArgs{
 * 							MatchValues: pulumi.StringArray{
 * 								pulumi.String("192.168.1.0/24"),
 * 							},
 * 							MatchVariables: network.MatchVariableArray{
 * 								&network.MatchVariableArgs{
 * 									VariableName: pulumi.String(network.WebApplicationFirewallMatchVariableRemoteAddr),
 * 								},
 * 							},
 * 							Operator: pulumi.String(network.WebApplicationFirewallOperatorIPMatch),
 * 						},
 * 						&network.MatchConditionArgs{
 * 							MatchValues: pulumi.StringArray{
 * 								pulumi.String("Windows"),
 * 							},
 * 							MatchVariables: network.MatchVariableArray{
 * 								&network.MatchVariableArgs{
 * 									Selector:     pulumi.String("UserAgent"),
 * 									VariableName: pulumi.String(network.WebApplicationFirewallMatchVariableRequestHeaders),
 * 								},
 * 							},
 * 							Operator: pulumi.String(network.WebApplicationFirewallOperatorContains),
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule2"),
 * 					Priority: pulumi.Int(2),
 * 					RuleType: pulumi.String(network.WebApplicationFirewallRuleTypeMatchRule),
 * 				},
 * 				&network.WebApplicationFirewallCustomRuleArgs{
 * 					Action: pulumi.String(network.WebApplicationFirewallActionBlock),
 * 					GroupByUserSession: network.GroupByUserSessionArray{
 * 						&network.GroupByUserSessionArgs{
 * 							GroupByVariables: network.GroupByVariableArray{
 * 								&network.GroupByVariableArgs{
 * 									VariableName: pulumi.String(network.ApplicationGatewayFirewallUserSessionVariableClientAddr),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					MatchConditions: network.MatchConditionArray{
 * 						&network.MatchConditionArgs{
 * 							MatchValues: pulumi.StringArray{
 * 								pulumi.String("192.168.1.0/24"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							MatchVariables: network.MatchVariableArray{
 * 								&network.MatchVariableArgs{
 * 									VariableName: pulumi.String(network.WebApplicationFirewallMatchVariableRemoteAddr),
 * 								},
 * 							},
 * 							NegationConditon: pulumi.Bool(true),
 * 							Operator:         pulumi.String(network.WebApplicationFirewallOperatorIPMatch),
 * 						},
 * 					},
 * 					Name:               pulumi.String("RateLimitRule3"),
 * 					Priority:           pulumi.Int(3),
 * 					RateLimitDuration:  pulumi.String(network.ApplicationGatewayFirewallRateLimitDurationOneMin),
 * 					RateLimitThreshold: pulumi.Int(10),
 * 					RuleType:           pulumi.String(network.WebApplicationFirewallRuleTypeRateLimitRule),
 * 				},
 * 			},
 * 			Location: pulumi.String("WestUs"),
 * 			ManagedRules: &network.ManagedRulesDefinitionArgs{
 * 				Exclusions: network.OwaspCrsExclusionEntryArray{
 * 					&network.OwaspCrsExclusionEntryArgs{
 * 						ExclusionManagedRuleSets: network.ExclusionManagedRuleSetArray{
 * 							&network.ExclusionManagedRuleSetArgs{
 * 								RuleGroups: network.ExclusionManagedRuleGroupArray{
 * 									&network.ExclusionManagedRuleGroupArgs{
 * 										RuleGroupName: pulumi.String("REQUEST-930-APPLICATION-ATTACK-LFI"),
 * 										Rules: network.ExclusionManagedRuleArray{
 * 											&network.ExclusionManagedRuleArgs{
 * 												RuleId: pulumi.String("930120"),
 * 											},
 * 										},
 * 									},
 * 									&network.ExclusionManagedRuleGroupArgs{
 * 										RuleGroupName: pulumi.String("REQUEST-932-APPLICATION-ATTACK-RCE"),
 * 									},
 * 								},
 * 								RuleSetType:    pulumi.String("OWASP"),
 * 								RuleSetVersion: pulumi.String("3.2"),
 * 							},
 * 						},
 * 						MatchVariable:         pulumi.String(network.OwaspCrsExclusionEntryMatchVariableRequestArgNames),
 * 						Selector:              pulumi.String("hello"),
 * 						SelectorMatchOperator: pulumi.String(network.OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith),
 * 					},
 * 					&network.OwaspCrsExclusionEntryArgs{
 * 						ExclusionManagedRuleSets: network.ExclusionManagedRuleSetArray{
 * 							&network.ExclusionManagedRuleSetArgs{
 * 								RuleGroups:     network.ExclusionManagedRuleGroupArray{},
 * 								RuleSetType:    pulumi.String("OWASP"),
 * 								RuleSetVersion: pulumi.String("3.1"),
 * 							},
 * 						},
 * 						MatchVariable:         pulumi.String(network.OwaspCrsExclusionEntryMatchVariableRequestArgNames),
 * 						Selector:              pulumi.String("hello"),
 * 						SelectorMatchOperator: pulumi.String(network.OwaspCrsExclusionEntrySelectorMatchOperatorEndsWith),
 * 					},
 * 					&network.OwaspCrsExclusionEntryArgs{
 * 						MatchVariable:         pulumi.String(network.OwaspCrsExclusionEntryMatchVariableRequestArgNames),
 * 						Selector:              pulumi.String("test"),
 * 						SelectorMatchOperator: pulumi.String(network.OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith),
 * 					},
 * 					&network.OwaspCrsExclusionEntryArgs{
 * 						MatchVariable:         pulumi.String(network.OwaspCrsExclusionEntryMatchVariableRequestArgValues),
 * 						Selector:              pulumi.String("test"),
 * 						SelectorMatchOperator: pulumi.String(network.OwaspCrsExclusionEntrySelectorMatchOperatorStartsWith),
 * 					},
 * 				},
 * 				ManagedRuleSets: network.ManagedRuleSetArray{
 * 					&network.ManagedRuleSetArgs{
 * 						RuleGroupOverrides: network.ManagedRuleGroupOverrideArray{
 * 							&network.ManagedRuleGroupOverrideArgs{
 * 								RuleGroupName: pulumi.String("REQUEST-931-APPLICATION-ATTACK-RFI"),
 * 								Rules: network.ManagedRuleOverrideArray{
 * 									&network.ManagedRuleOverrideArgs{
 * 										Action: pulumi.String(network.ActionTypeLog),
 * 										RuleId: pulumi.String("931120"),
 * 										State:  pulumi.String(network.ManagedRuleEnabledStateEnabled),
 * 									},
 * 									&network.ManagedRuleOverrideArgs{
 * 										Action: pulumi.String(network.ActionTypeAnomalyScoring),
 * 										RuleId: pulumi.String("931130"),
 * 										State:  pulumi.String(network.ManagedRuleEnabledStateDisabled),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						RuleSetType:    pulumi.String("OWASP"),
 * 						RuleSetVersion: pulumi.String("3.2"),
 * 					},
 * 				},
 * 			},
 * 			PolicyName: pulumi.String("Policy1"),
 * 			PolicySettings: &network.PolicySettingsArgs{
 * 				LogScrubbing: &network.PolicySettingsLogScrubbingArgs{
 * 					ScrubbingRules: network.WebApplicationFirewallScrubbingRulesArray{
 * 						&network.WebApplicationFirewallScrubbingRulesArgs{
 * 							MatchVariable:         pulumi.String(network.ScrubbingRuleEntryMatchVariableRequestArgNames),
 * 							Selector:              pulumi.String("test"),
 * 							SelectorMatchOperator: pulumi.String(network.ScrubbingRuleEntryMatchOperatorEquals),
 * 							State:                 pulumi.String(network.ScrubbingRuleEntryStateEnabled),
 * 						},
 * 						&network.WebApplicationFirewallScrubbingRulesArgs{
 * 							MatchVariable:         pulumi.String(network.ScrubbingRuleEntryMatchVariableRequestIPAddress),
 * 							SelectorMatchOperator: pulumi.String(network.ScrubbingRuleEntryMatchOperatorEqualsAny),
 * 							State:                 pulumi.String(network.ScrubbingRuleEntryStateEnabled),
 * 						},
 * 					},
 * 					State: pulumi.String(network.WebApplicationFirewallScrubbingStateEnabled),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.WebApplicationFirewallPolicy;
 * import com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs;
 * import com.pulumi.azurenative.network.inputs.WebApplicationFirewallCustomRuleArgs;
 * import com.pulumi.azurenative.network.inputs.ManagedRulesDefinitionArgs;
 * import com.pulumi.azurenative.network.inputs.PolicySettingsArgs;
 * import com.pulumi.azurenative.network.inputs.PolicySettingsLogScrubbingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webApplicationFirewallPolicy = new WebApplicationFirewallPolicy("webApplicationFirewallPolicy", WebApplicationFirewallPolicyArgs.builder()
 *             .customRules(
 *                 WebApplicationFirewallCustomRuleArgs.builder()
 *                     .action("Block")
 *                     .matchConditions(MatchConditionArgs.builder()
 *                         .matchValues(
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24")
 *                         .matchVariables(MatchVariableArgs.builder()
 *                             .variableName("RemoteAddr")
 *                             .build())
 *                         .operator("IPMatch")
 *                         .build())
 *                     .name("Rule1")
 *                     .priority(1)
 *                     .ruleType("MatchRule")
 *                     .build(),
 *                 WebApplicationFirewallCustomRuleArgs.builder()
 *                     .action("Block")
 *                     .matchConditions(
 *                         MatchConditionArgs.builder()
 *                             .matchValues("192.168.1.0/24")
 *                             .matchVariables(MatchVariableArgs.builder()
 *                                 .variableName("RemoteAddr")
 *                                 .build())
 *                             .operator("IPMatch")
 *                             .build(),
 *                         MatchConditionArgs.builder()
 *                             .matchValues("Windows")
 *                             .matchVariables(MatchVariableArgs.builder()
 *                                 .selector("UserAgent")
 *                                 .variableName("RequestHeaders")
 *                                 .build())
 *                             .operator("Contains")
 *                             .build())
 *                     .name("Rule2")
 *                     .priority(2)
 *                     .ruleType("MatchRule")
 *                     .build(),
 *                 WebApplicationFirewallCustomRuleArgs.builder()
 *                     .action("Block")
 *                     .groupByUserSession(GroupByUserSessionArgs.builder()
 *                         .groupByVariables(GroupByVariableArgs.builder()
 *                             .variableName("ClientAddr")
 *                             .build())
 *                         .build())
 *                     .matchConditions(MatchConditionArgs.builder()
 *                         .matchValues(
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24")
 *                         .matchVariables(MatchVariableArgs.builder()
 *                             .variableName("RemoteAddr")
 *                             .build())
 *                         .negationConditon(true)
 *                         .operator("IPMatch")
 *                         .build())
 *                     .name("RateLimitRule3")
 *                     .priority(3)
 *                     .rateLimitDuration("OneMin")
 *                     .rateLimitThreshold(10)
 *                     .ruleType("RateLimitRule")
 *                     .build())
 *             .location("WestUs")
 *             .managedRules(ManagedRulesDefinitionArgs.builder()
 *                 .exclusions(
 *                     OwaspCrsExclusionEntryArgs.builder()
 *                         .exclusionManagedRuleSets(ExclusionManagedRuleSetArgs.builder()
 *                             .ruleGroups(
 *                                 ExclusionManagedRuleGroupArgs.builder()
 *                                     .ruleGroupName("REQUEST-930-APPLICATION-ATTACK-LFI")
 *                                     .rules(ExclusionManagedRuleArgs.builder()
 *                                         .ruleId("930120")
 *                                         .build())
 *                                     .build(),
 *                                 ExclusionManagedRuleGroupArgs.builder()
 *                                     .ruleGroupName("REQUEST-932-APPLICATION-ATTACK-RCE")
 *                                     .build())
 *                             .ruleSetType("OWASP")
 *                             .ruleSetVersion("3.2")
 *                             .build())
 *                         .matchVariable("RequestArgNames")
 *                         .selector("hello")
 *                         .selectorMatchOperator("StartsWith")
 *                         .build(),
 *                     OwaspCrsExclusionEntryArgs.builder()
 *                         .exclusionManagedRuleSets(ExclusionManagedRuleSetArgs.builder()
 *                             .ruleGroups()
 *                             .ruleSetType("OWASP")
 *                             .ruleSetVersion("3.1")
 *                             .build())
 *                         .matchVariable("RequestArgNames")
 *                         .selector("hello")
 *                         .selectorMatchOperator("EndsWith")
 *                         .build(),
 *                     OwaspCrsExclusionEntryArgs.builder()
 *                         .matchVariable("RequestArgNames")
 *                         .selector("test")
 *                         .selectorMatchOperator("StartsWith")
 *                         .build(),
 *                     OwaspCrsExclusionEntryArgs.builder()
 *                         .matchVariable("RequestArgValues")
 *                         .selector("test")
 *                         .selectorMatchOperator("StartsWith")
 *                         .build())
 *                 .managedRuleSets(ManagedRuleSetArgs.builder()
 *                     .ruleGroupOverrides(ManagedRuleGroupOverrideArgs.builder()
 *                         .ruleGroupName("REQUEST-931-APPLICATION-ATTACK-RFI")
 *                         .rules(
 *                             ManagedRuleOverrideArgs.builder()
 *                                 .action("Log")
 *                                 .ruleId("931120")
 *                                 .state("Enabled")
 *                                 .build(),
 *                             ManagedRuleOverrideArgs.builder()
 *                                 .action("AnomalyScoring")
 *                                 .ruleId("931130")
 *                                 .state("Disabled")
 *                                 .build())
 *                         .build())
 *                     .ruleSetType("OWASP")
 *                     .ruleSetVersion("3.2")
 *                     .build())
 *                 .build())
 *             .policyName("Policy1")
 *             .policySettings(PolicySettingsArgs.builder()
 *                 .logScrubbing(PolicySettingsLogScrubbingArgs.builder()
 *                     .scrubbingRules(
 *                         WebApplicationFirewallScrubbingRulesArgs.builder()
 *                             .matchVariable("RequestArgNames")
 *                             .selector("test")
 *                             .selectorMatchOperator("Equals")
 *                             .state("Enabled")
 *                             .build(),
 *                         WebApplicationFirewallScrubbingRulesArgs.builder()
 *                             .matchVariable("RequestIPAddress")
 *                             .selectorMatchOperator("EqualsAny")
 *                             .state("Enabled")
 *                             .build())
 *                     .state("Enabled")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:WebApplicationFirewallPolicy Policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}
 * ```
 * @property customRules The custom rules inside the policy.
 * @property id Resource ID.
 * @property location Resource location.
 * @property managedRules Describes the managedRules structure.
 * @property policyName The name of the policy.
 * @property policySettings The PolicySettings for policy.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class WebApplicationFirewallPolicyArgs(
    public val customRules: Output<List<WebApplicationFirewallCustomRuleArgs>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedRules: Output<ManagedRulesDefinitionArgs>? = null,
    public val policyName: Output<String>? = null,
    public val policySettings: Output<PolicySettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs =
        com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs.builder()
            .customRules(
                customRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedRules(managedRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policySettings(policySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WebApplicationFirewallPolicyArgs].
 */
@PulumiTagMarker
public class WebApplicationFirewallPolicyArgsBuilder internal constructor() {
    private var customRules: Output<List<WebApplicationFirewallCustomRuleArgs>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var managedRules: Output<ManagedRulesDefinitionArgs>? = null

    private var policyName: Output<String>? = null

    private var policySettings: Output<PolicySettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The custom rules inside the policy.
     */
    @JvmName("qkxqbpdgbrblvypa")
    public suspend fun customRules(`value`: Output<List<WebApplicationFirewallCustomRuleArgs>>) {
        this.customRules = value
    }

    @JvmName("ayoafwllmsdrocjy")
    public suspend fun customRules(vararg values: Output<WebApplicationFirewallCustomRuleArgs>) {
        this.customRules = Output.all(values.asList())
    }

    /**
     * @param values The custom rules inside the policy.
     */
    @JvmName("ckqvgebchdlaicax")
    public suspend fun customRules(values: List<Output<WebApplicationFirewallCustomRuleArgs>>) {
        this.customRules = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ulnhagtnntgooxtb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("aqrmpvtaonwslixl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Describes the managedRules structure.
     */
    @JvmName("vxfrmwehpjrhitrx")
    public suspend fun managedRules(`value`: Output<ManagedRulesDefinitionArgs>) {
        this.managedRules = value
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("hukegdwrqrdmqwdg")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The PolicySettings for policy.
     */
    @JvmName("pjlnkckoyibjogvs")
    public suspend fun policySettings(`value`: Output<PolicySettingsArgs>) {
        this.policySettings = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hmpbfpyryptgfrod")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rolwfwpkatwwmuar")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The custom rules inside the policy.
     */
    @JvmName("huugngfdcfxhuann")
    public suspend fun customRules(`value`: List<WebApplicationFirewallCustomRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param argument The custom rules inside the policy.
     */
    @JvmName("odgijhtaqecneqbo")
    public suspend fun customRules(argument: List<suspend WebApplicationFirewallCustomRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationFirewallCustomRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param argument The custom rules inside the policy.
     */
    @JvmName("iiklqqbvcydqnqbh")
    public suspend fun customRules(vararg argument: suspend WebApplicationFirewallCustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebApplicationFirewallCustomRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param argument The custom rules inside the policy.
     */
    @JvmName("ylfyuvnokowkxhsn")
    public suspend fun customRules(argument: suspend WebApplicationFirewallCustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationFirewallCustomRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param values The custom rules inside the policy.
     */
    @JvmName("fvxohhommqqepcdr")
    public suspend fun customRules(vararg values: WebApplicationFirewallCustomRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wnamuvlclfkoofof")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gwtwjgvsnxbfgyix")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Describes the managedRules structure.
     */
    @JvmName("bwwfqfiqajhlttjx")
    public suspend fun managedRules(`value`: ManagedRulesDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRules = mapped
    }

    /**
     * @param argument Describes the managedRules structure.
     */
    @JvmName("qqycrijelbeajgkm")
    public suspend fun managedRules(argument: suspend ManagedRulesDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedRulesDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedRules = mapped
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("ejushurxyujueoqb")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The PolicySettings for policy.
     */
    @JvmName("drqfferplsxnsfro")
    public suspend fun policySettings(`value`: PolicySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySettings = mapped
    }

    /**
     * @param argument The PolicySettings for policy.
     */
    @JvmName("lrudgcjjeckrwnuk")
    public suspend fun policySettings(argument: suspend PolicySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PolicySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policySettings = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("topdwyaleceheybl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dhlkkgtiaoshvujx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vqraktjvmoirujyj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WebApplicationFirewallPolicyArgs = WebApplicationFirewallPolicyArgs(
        customRules = customRules,
        id = id,
        location = location,
        managedRules = managedRules,
        policyName = policyName,
        policySettings = policySettings,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
