@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes the override action to be applied when rule matches.
 */
public enum class ActionType(
    public val javaValue: com.pulumi.azurenative.network.enums.ActionType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.ActionType> {
    AnomalyScoring(com.pulumi.azurenative.network.enums.ActionType.AnomalyScoring),
    Allow(com.pulumi.azurenative.network.enums.ActionType.Allow),
    Block(com.pulumi.azurenative.network.enums.ActionType.Block),
    Log(com.pulumi.azurenative.network.enums.ActionType.Log),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.ActionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.ActionType): ActionType =
            ActionType.values().first { it.javaValue == javaType }
    }
}
