@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The allowed type DNS record types for this profile.
 */
public enum class AllowedEndpointRecordType(
    public val javaValue: com.pulumi.azurenative.network.enums.AllowedEndpointRecordType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.AllowedEndpointRecordType> {
    DomainName(com.pulumi.azurenative.network.enums.AllowedEndpointRecordType.DomainName),
    IPv4Address(com.pulumi.azurenative.network.enums.AllowedEndpointRecordType.IPv4Address),
    IPv6Address(com.pulumi.azurenative.network.enums.AllowedEndpointRecordType.IPv6Address),
    Any(com.pulumi.azurenative.network.enums.AllowedEndpointRecordType.Any),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.AllowedEndpointRecordType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.AllowedEndpointRecordType): AllowedEndpointRecordType =
            AllowedEndpointRecordType.values().first { it.javaValue == javaType }
    }
}
