@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
 */
public enum class AlwaysServe(
    public val javaValue: com.pulumi.azurenative.network.enums.AlwaysServe,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.AlwaysServe> {
    Enabled(com.pulumi.azurenative.network.enums.AlwaysServe.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.AlwaysServe.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.AlwaysServe = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.AlwaysServe): AlwaysServe =
            AlwaysServe.values().first { it.javaValue == javaType }
    }
}
