@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specify what happens to the public IP address when the VM using it is deleted
 */
public enum class DeleteOptions(
    public val javaValue: com.pulumi.azurenative.network.enums.DeleteOptions,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.DeleteOptions> {
    Delete(com.pulumi.azurenative.network.enums.DeleteOptions.Delete),
    Detach(com.pulumi.azurenative.network.enums.DeleteOptions.Detach),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.DeleteOptions = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.DeleteOptions): DeleteOptions = DeleteOptions.values().first { it.javaValue == javaType }
    }
}
