@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
 */
public enum class EnforceCertificateNameCheckEnabledState(
    public val javaValue: com.pulumi.azurenative.network.enums.EnforceCertificateNameCheckEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.EnforceCertificateNameCheckEnabledState> {
    Enabled(com.pulumi.azurenative.network.enums.EnforceCertificateNameCheckEnabledState.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.EnforceCertificateNameCheckEnabledState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.EnforceCertificateNameCheckEnabledState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.EnforceCertificateNameCheckEnabledState): EnforceCertificateNameCheckEnabledState =
            EnforceCertificateNameCheckEnabledState.values().first { it.javaValue == javaType }
    }
}
