@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The peering type.
 */
public enum class ExpressRoutePeeringType(
    public val javaValue: com.pulumi.azurenative.network.enums.ExpressRoutePeeringType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.ExpressRoutePeeringType> {
    AzurePublicPeering(com.pulumi.azurenative.network.enums.ExpressRoutePeeringType.AzurePublicPeering),
    AzurePrivatePeering(com.pulumi.azurenative.network.enums.ExpressRoutePeeringType.AzurePrivatePeering),
    MicrosoftPeering(com.pulumi.azurenative.network.enums.ExpressRoutePeeringType.MicrosoftPeering),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.ExpressRoutePeeringType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.ExpressRoutePeeringType): ExpressRoutePeeringType =
            ExpressRoutePeeringType.values().first { it.javaValue == javaType }
    }
}
