@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The IKE integrity algorithm (IKE phase 2).
 */
public enum class IkeIntegrity(
    public val javaValue: com.pulumi.azurenative.network.enums.IkeIntegrity,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.IkeIntegrity> {
    MD5(com.pulumi.azurenative.network.enums.IkeIntegrity.MD5),
    SHA1(com.pulumi.azurenative.network.enums.IkeIntegrity.SHA1),
    SHA256(com.pulumi.azurenative.network.enums.IkeIntegrity.SHA256),
    SHA384(com.pulumi.azurenative.network.enums.IkeIntegrity.SHA384),
    GCMAES256(com.pulumi.azurenative.network.enums.IkeIntegrity.GCMAES256),
    GCMAES128(com.pulumi.azurenative.network.enums.IkeIntegrity.GCMAES128),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.IkeIntegrity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.IkeIntegrity): IkeIntegrity =
            IkeIntegrity.values().first { it.javaValue == javaType }
    }
}
