@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The IPSec integrity algorithm (IKE phase 1).
 */
public enum class IpsecIntegrity(
    public val javaValue: com.pulumi.azurenative.network.enums.IpsecIntegrity,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.IpsecIntegrity> {
    MD5(com.pulumi.azurenative.network.enums.IpsecIntegrity.MD5),
    SHA1(com.pulumi.azurenative.network.enums.IpsecIntegrity.SHA1),
    SHA256(com.pulumi.azurenative.network.enums.IpsecIntegrity.SHA256),
    GCMAES128(com.pulumi.azurenative.network.enums.IpsecIntegrity.GCMAES128),
    GCMAES192(com.pulumi.azurenative.network.enums.IpsecIntegrity.GCMAES192),
    GCMAES256(com.pulumi.azurenative.network.enums.IpsecIntegrity.GCMAES256),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.IpsecIntegrity = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.IpsecIntegrity): IpsecIntegrity = IpsecIntegrity.values().first { it.javaValue == javaType }
    }
}
