@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections.
 */
public enum class LoadBalancerBackendAddressAdminState(
    public val javaValue: com.pulumi.azurenative.network.enums.LoadBalancerBackendAddressAdminState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.LoadBalancerBackendAddressAdminState> {
    None(com.pulumi.azurenative.network.enums.LoadBalancerBackendAddressAdminState.None),
    Up(com.pulumi.azurenative.network.enums.LoadBalancerBackendAddressAdminState.Up),
    Down(com.pulumi.azurenative.network.enums.LoadBalancerBackendAddressAdminState.Down),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.LoadBalancerBackendAddressAdminState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.LoadBalancerBackendAddressAdminState): LoadBalancerBackendAddressAdminState =
            LoadBalancerBackendAddressAdminState.values().first { it.javaValue == javaType }
    }
}
