@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The state of the managed rule. Defaults to Disabled if not specified.
 */
public enum class ManagedRuleEnabledState(
    public val javaValue: com.pulumi.azurenative.network.enums.ManagedRuleEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.ManagedRuleEnabledState> {
    Disabled(com.pulumi.azurenative.network.enums.ManagedRuleEnabledState.Disabled),
    Enabled(com.pulumi.azurenative.network.enums.ManagedRuleEnabledState.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.ManagedRuleEnabledState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.ManagedRuleEnabledState): ManagedRuleEnabledState =
            ManagedRuleEnabledState.values().first { it.javaValue == javaType }
    }
}
