@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
 */
public enum class NextStep(
    public val javaValue: com.pulumi.azurenative.network.enums.NextStep,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.NextStep> {
    Unknown(com.pulumi.azurenative.network.enums.NextStep.Unknown),
    Continue(com.pulumi.azurenative.network.enums.NextStep.Continue),
    Terminate(com.pulumi.azurenative.network.enums.NextStep.Terminate),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.NextStep = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.NextStep): NextStep =
            NextStep.values().first { it.javaValue == javaType }
    }
}
