@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Connection monitor output destination type. Currently, only "Workspace" is supported.
 */
public enum class OutputType(
    public val javaValue: com.pulumi.azurenative.network.enums.OutputType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.OutputType> {
    Workspace(com.pulumi.azurenative.network.enums.OutputType.Workspace),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.OutputType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.OutputType): OutputType =
            OutputType.values().first { it.javaValue == javaType }
    }
}
