@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Target type of the resource provided.
 */
public enum class PacketCaptureTargetType(
    public val javaValue: com.pulumi.azurenative.network.enums.PacketCaptureTargetType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.PacketCaptureTargetType> {
    AzureVM(com.pulumi.azurenative.network.enums.PacketCaptureTargetType.AzureVM),
    AzureVMSS(com.pulumi.azurenative.network.enums.PacketCaptureTargetType.AzureVMSS),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.PacketCaptureTargetType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.PacketCaptureTargetType): PacketCaptureTargetType =
            PacketCaptureTargetType.values().first { it.javaValue == javaType }
    }
}
