@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
 */
public enum class ProbeProtocol(
    public val javaValue: com.pulumi.azurenative.network.enums.ProbeProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.ProbeProtocol> {
    Http(com.pulumi.azurenative.network.enums.ProbeProtocol.Http),
    Tcp(com.pulumi.azurenative.network.enums.ProbeProtocol.Tcp),
    Https(com.pulumi.azurenative.network.enums.ProbeProtocol.Https),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.ProbeProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.ProbeProtocol): ProbeProtocol = ProbeProtocol.values().first { it.javaValue == javaType }
    }
}
