@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * RNM supported protocol types.
 */
public enum class ProtocolType(
    public val javaValue: com.pulumi.azurenative.network.enums.ProtocolType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.ProtocolType> {
    DoNotUse(com.pulumi.azurenative.network.enums.ProtocolType.DoNotUse),
    Icmp(com.pulumi.azurenative.network.enums.ProtocolType.Icmp),
    Tcp(com.pulumi.azurenative.network.enums.ProtocolType.Tcp),
    Udp(com.pulumi.azurenative.network.enums.ProtocolType.Udp),
    Gre(com.pulumi.azurenative.network.enums.ProtocolType.Gre),
    Esp(com.pulumi.azurenative.network.enums.ProtocolType.Esp),
    Ah(com.pulumi.azurenative.network.enums.ProtocolType.Ah),
    Vxlan(com.pulumi.azurenative.network.enums.ProtocolType.Vxlan),
    All(com.pulumi.azurenative.network.enums.ProtocolType.All),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.ProtocolType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.ProtocolType): ProtocolType =
            ProtocolType.values().first { it.javaValue == javaType }
    }
}
