@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.network.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.network.enums.ResourceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.network.enums.ResourceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.network.enums.ResourceIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.network.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
