@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes what transforms applied before matching.
 */
public enum class TransformType(
    public val javaValue: com.pulumi.azurenative.network.enums.TransformType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.TransformType> {
    Lowercase(com.pulumi.azurenative.network.enums.TransformType.Lowercase),
    Uppercase(com.pulumi.azurenative.network.enums.TransformType.Uppercase),
    Trim(com.pulumi.azurenative.network.enums.TransformType.Trim),
    UrlDecode(com.pulumi.azurenative.network.enums.TransformType.UrlDecode),
    UrlEncode(com.pulumi.azurenative.network.enums.TransformType.UrlEncode),
    RemoveNulls(com.pulumi.azurenative.network.enums.TransformType.RemoveNulls),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.TransformType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.TransformType): TransformType = TransformType.values().first { it.javaValue == javaType }
    }
}
