@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If the encrypted VNet allows VM that does not support encryption
 */
public enum class VirtualNetworkEncryptionEnforcement(
    public val javaValue: com.pulumi.azurenative.network.enums.VirtualNetworkEncryptionEnforcement,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.VirtualNetworkEncryptionEnforcement> {
    DropUnencrypted(com.pulumi.azurenative.network.enums.VirtualNetworkEncryptionEnforcement.DropUnencrypted),
    AllowUnencrypted(com.pulumi.azurenative.network.enums.VirtualNetworkEncryptionEnforcement.AllowUnencrypted),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.VirtualNetworkEncryptionEnforcement =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.VirtualNetworkEncryptionEnforcement): VirtualNetworkEncryptionEnforcement =
            VirtualNetworkEncryptionEnforcement.values().first { it.javaValue == javaType }
    }
}
