@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of this virtual network gateway.
 */
public enum class VirtualNetworkGatewayType(
    public val javaValue: com.pulumi.azurenative.network.enums.VirtualNetworkGatewayType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.VirtualNetworkGatewayType> {
    Vpn(com.pulumi.azurenative.network.enums.VirtualNetworkGatewayType.Vpn),
    ExpressRoute(com.pulumi.azurenative.network.enums.VirtualNetworkGatewayType.ExpressRoute),
    LocalGateway(com.pulumi.azurenative.network.enums.VirtualNetworkGatewayType.LocalGateway),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.VirtualNetworkGatewayType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.VirtualNetworkGatewayType): VirtualNetworkGatewayType =
            VirtualNetworkGatewayType.values().first { it.javaValue == javaType }
    }
}
