@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 */
public enum class WebApplicationFirewallState(
    public val javaValue: com.pulumi.azurenative.network.enums.WebApplicationFirewallState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.WebApplicationFirewallState> {
    Disabled(com.pulumi.azurenative.network.enums.WebApplicationFirewallState.Disabled),
    Enabled(com.pulumi.azurenative.network.enums.WebApplicationFirewallState.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.WebApplicationFirewallState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.WebApplicationFirewallState): WebApplicationFirewallState =
            WebApplicationFirewallState.values().first { it.javaValue == javaType }
    }
}
