@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayClientAuthConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayClientRevocationOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Application gateway client authentication configuration.
 * @property verifyClientCertIssuerDN Verify client certificate issuer name on the application gateway.
 * @property verifyClientRevocation Verify client certificate revocation status.
 */
public data class ApplicationGatewayClientAuthConfigurationArgs(
    public val verifyClientCertIssuerDN: Output<Boolean>? = null,
    public val verifyClientRevocation: Output<Either<String, ApplicationGatewayClientRevocationOptions>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayClientAuthConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayClientAuthConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayClientAuthConfigurationArgs.builder()
            .verifyClientCertIssuerDN(verifyClientCertIssuerDN?.applyValue({ args0 -> args0 }))
            .verifyClientRevocation(
                verifyClientRevocation?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayClientAuthConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayClientAuthConfigurationArgsBuilder internal constructor() {
    private var verifyClientCertIssuerDN: Output<Boolean>? = null

    private var verifyClientRevocation:
        Output<Either<String, ApplicationGatewayClientRevocationOptions>>? = null

    /**
     * @param value Verify client certificate issuer name on the application gateway.
     */
    @JvmName("ybsslxbjyhtvujjb")
    public suspend fun verifyClientCertIssuerDN(`value`: Output<Boolean>) {
        this.verifyClientCertIssuerDN = value
    }

    /**
     * @param value Verify client certificate revocation status.
     */
    @JvmName("txlhabusaswdjmud")
    public suspend fun verifyClientRevocation(`value`: Output<Either<String, ApplicationGatewayClientRevocationOptions>>) {
        this.verifyClientRevocation = value
    }

    /**
     * @param value Verify client certificate issuer name on the application gateway.
     */
    @JvmName("waqpuplbjhhjiwdv")
    public suspend fun verifyClientCertIssuerDN(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifyClientCertIssuerDN = mapped
    }

    /**
     * @param value Verify client certificate revocation status.
     */
    @JvmName("tcgulsnlyqkaerpc")
    public suspend fun verifyClientRevocation(`value`: Either<String, ApplicationGatewayClientRevocationOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifyClientRevocation = mapped
    }

    /**
     * @param value Verify client certificate revocation status.
     */
    @JvmName("lnleahnmquwsqmfo")
    public fun verifyClientRevocation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayClientRevocationOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.verifyClientRevocation = mapped
    }

    /**
     * @param value Verify client certificate revocation status.
     */
    @JvmName("bdjysfduuxbcepmq")
    public fun verifyClientRevocation(`value`: ApplicationGatewayClientRevocationOptions) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayClientRevocationOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.verifyClientRevocation = mapped
    }

    internal fun build(): ApplicationGatewayClientAuthConfigurationArgs =
        ApplicationGatewayClientAuthConfigurationArgs(
            verifyClientCertIssuerDN = verifyClientCertIssuerDN,
            verifyClientRevocation = verifyClientRevocation,
        )
}
