@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayListenerArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Listener of an application gateway.
 * @property frontendIPConfiguration Frontend IP configuration resource of an application gateway.
 * @property frontendPort Frontend port resource of an application gateway.
 * @property id Resource ID.
 * @property name Name of the listener that is unique within an Application Gateway.
 * @property protocol Protocol of the listener.
 * @property sslCertificate SSL certificate resource of an application gateway.
 * @property sslProfile SSL profile resource of the application gateway.
 */
public data class ApplicationGatewayListenerArgs(
    public val frontendIPConfiguration: Output<SubResourceArgs>? = null,
    public val frontendPort: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null,
    public val sslCertificate: Output<SubResourceArgs>? = null,
    public val sslProfile: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayListenerArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayListenerArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayListenerArgs.builder()
            .frontendIPConfiguration(
                frontendIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontendPort(frontendPort?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sslCertificate(sslCertificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sslProfile(sslProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationGatewayListenerArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayListenerArgsBuilder internal constructor() {
    private var frontendIPConfiguration: Output<SubResourceArgs>? = null

    private var frontendPort: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null

    private var sslCertificate: Output<SubResourceArgs>? = null

    private var sslProfile: Output<SubResourceArgs>? = null

    /**
     * @param value Frontend IP configuration resource of an application gateway.
     */
    @JvmName("mmfsgqyxllduodui")
    public suspend fun frontendIPConfiguration(`value`: Output<SubResourceArgs>) {
        this.frontendIPConfiguration = value
    }

    /**
     * @param value Frontend port resource of an application gateway.
     */
    @JvmName("mksgfdvfhenpqheh")
    public suspend fun frontendPort(`value`: Output<SubResourceArgs>) {
        this.frontendPort = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("kdhlfohmqwgfpxmr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the listener that is unique within an Application Gateway.
     */
    @JvmName("snfdswvdonrsrgfn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Protocol of the listener.
     */
    @JvmName("jafxasjnqknewlnv")
    public suspend fun protocol(`value`: Output<Either<String, ApplicationGatewayProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value SSL certificate resource of an application gateway.
     */
    @JvmName("qbupnhtbvjrhnxif")
    public suspend fun sslCertificate(`value`: Output<SubResourceArgs>) {
        this.sslCertificate = value
    }

    /**
     * @param value SSL profile resource of the application gateway.
     */
    @JvmName("tqtlseynyxxwwdou")
    public suspend fun sslProfile(`value`: Output<SubResourceArgs>) {
        this.sslProfile = value
    }

    /**
     * @param value Frontend IP configuration resource of an application gateway.
     */
    @JvmName("xioguaslpatwpvkk")
    public suspend fun frontendIPConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param argument Frontend IP configuration resource of an application gateway.
     */
    @JvmName("jvccfugwxldbktgt")
    public suspend fun frontendIPConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param value Frontend port resource of an application gateway.
     */
    @JvmName("autsumdeswbptroe")
    public suspend fun frontendPort(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param argument Frontend port resource of an application gateway.
     */
    @JvmName("wrdlmeitvqhvjycw")
    public suspend fun frontendPort(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendPort = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("urypaicusdrbregx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the listener that is unique within an Application Gateway.
     */
    @JvmName("eslycwwoiasnfatg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Protocol of the listener.
     */
    @JvmName("aldvwivxpwhfgqbt")
    public suspend fun protocol(`value`: Either<String, ApplicationGatewayProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of the listener.
     */
    @JvmName("ogxmpmquoyhcwhwa")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of the listener.
     */
    @JvmName("qwtfdfoeeganevou")
    public fun protocol(`value`: ApplicationGatewayProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value SSL certificate resource of an application gateway.
     */
    @JvmName("mllgphfofodtiitk")
    public suspend fun sslCertificate(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificate = mapped
    }

    /**
     * @param argument SSL certificate resource of an application gateway.
     */
    @JvmName("qvvsgedgqoplgglt")
    public suspend fun sslCertificate(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslCertificate = mapped
    }

    /**
     * @param value SSL profile resource of the application gateway.
     */
    @JvmName("rmdolaqgtfegnadn")
    public suspend fun sslProfile(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslProfile = mapped
    }

    /**
     * @param argument SSL profile resource of the application gateway.
     */
    @JvmName("phfelxxqrbdqeldm")
    public suspend fun sslProfile(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslProfile = mapped
    }

    internal fun build(): ApplicationGatewayListenerArgs = ApplicationGatewayListenerArgs(
        frontendIPConfiguration = frontendIPConfiguration,
        frontendPort = frontendPort,
        id = id,
        name = name,
        protocol = protocol,
        sslCertificate = sslCertificate,
        sslProfile = sslProfile,
    )
}
