@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Probe of the application gateway.
 * @property host Host name to send the probe to.
 * @property id Resource ID.
 * @property interval The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
 * @property match Criterion for classifying a healthy probe response.
 * @property minServers Minimum number of servers that are always marked healthy. Default value is 0.
 * @property name Name of the probe that is unique within an Application Gateway.
 * @property path Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
 * @property pickHostNameFromBackendHttpSettings Whether the host header should be picked from the backend http settings. Default value is false.
 * @property pickHostNameFromBackendSettings Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false.
 * @property port Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
 * @property protocol The protocol used for the probe.
 * @property timeout The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
 * @property unhealthyThreshold The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
 */
public data class ApplicationGatewayProbeArgs(
    public val host: Output<String>? = null,
    public val id: Output<String>? = null,
    public val interval: Output<Int>? = null,
    public val match: Output<ApplicationGatewayProbeHealthResponseMatchArgs>? = null,
    public val minServers: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val path: Output<String>? = null,
    public val pickHostNameFromBackendHttpSettings: Output<Boolean>? = null,
    public val pickHostNameFromBackendSettings: Output<Boolean>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null,
    public val timeout: Output<Int>? = null,
    public val unhealthyThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeArgs.builder()
            .host(host?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .minServers(minServers?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .pickHostNameFromBackendHttpSettings(
                pickHostNameFromBackendHttpSettings?.applyValue({ args0 ->
                    args0
                }),
            )
            .pickHostNameFromBackendSettings(pickHostNameFromBackendSettings?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayProbeArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayProbeArgsBuilder internal constructor() {
    private var host: Output<String>? = null

    private var id: Output<String>? = null

    private var interval: Output<Int>? = null

    private var match: Output<ApplicationGatewayProbeHealthResponseMatchArgs>? = null

    private var minServers: Output<Int>? = null

    private var name: Output<String>? = null

    private var path: Output<String>? = null

    private var pickHostNameFromBackendHttpSettings: Output<Boolean>? = null

    private var pickHostNameFromBackendSettings: Output<Boolean>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null

    private var timeout: Output<Int>? = null

    private var unhealthyThreshold: Output<Int>? = null

    /**
     * @param value Host name to send the probe to.
     */
    @JvmName("rvusdgjwkmqtsblk")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tntrrhyehbyydgdy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("wgxmikduetbhtckv")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Criterion for classifying a healthy probe response.
     */
    @JvmName("kcnyhwiahbcvkfcq")
    public suspend fun match(`value`: Output<ApplicationGatewayProbeHealthResponseMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Minimum number of servers that are always marked healthy. Default value is 0.
     */
    @JvmName("yppuenxfgrfwyhhy")
    public suspend fun minServers(`value`: Output<Int>) {
        this.minServers = value
    }

    /**
     * @param value Name of the probe that is unique within an Application Gateway.
     */
    @JvmName("ehklbomhdcnghheg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
     */
    @JvmName("omwsselnwmghywvp")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Whether the host header should be picked from the backend http settings. Default value is false.
     */
    @JvmName("kpgjprqxgtpvlftb")
    public suspend fun pickHostNameFromBackendHttpSettings(`value`: Output<Boolean>) {
        this.pickHostNameFromBackendHttpSettings = value
    }

    /**
     * @param value Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false.
     */
    @JvmName("oofrdjytfcbukjdt")
    public suspend fun pickHostNameFromBackendSettings(`value`: Output<Boolean>) {
        this.pickHostNameFromBackendSettings = value
    }

    /**
     * @param value Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
     */
    @JvmName("siuydqrxkbdryrco")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol used for the probe.
     */
    @JvmName("udlqnuvidfbobvwa")
    public suspend fun protocol(`value`: Output<Either<String, ApplicationGatewayProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("fyqrkwykpsfqhqig")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
     */
    @JvmName("ybvbdstbvbhhcwga")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value Host name to send the probe to.
     */
    @JvmName("mokkvfahrtjuaoij")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pqnbknywnkqqqoff")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("buomlacfnndmnrqr")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Criterion for classifying a healthy probe response.
     */
    @JvmName("crgbcwxeylmvsrlw")
    public suspend fun match(`value`: ApplicationGatewayProbeHealthResponseMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criterion for classifying a healthy probe response.
     */
    @JvmName("sjfrwarajtyiqrym")
    public suspend fun match(argument: suspend ApplicationGatewayProbeHealthResponseMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewayProbeHealthResponseMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Minimum number of servers that are always marked healthy. Default value is 0.
     */
    @JvmName("rjqbgbaroxpytwkg")
    public suspend fun minServers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minServers = mapped
    }

    /**
     * @param value Name of the probe that is unique within an Application Gateway.
     */
    @JvmName("dpeeulatpwvxlius")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
     */
    @JvmName("qcyctnimobuiqnuh")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Whether the host header should be picked from the backend http settings. Default value is false.
     */
    @JvmName("apclbljtlulysnsc")
    public suspend fun pickHostNameFromBackendHttpSettings(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pickHostNameFromBackendHttpSettings = mapped
    }

    /**
     * @param value Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false.
     */
    @JvmName("asbvccrnyqlegtoy")
    public suspend fun pickHostNameFromBackendSettings(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pickHostNameFromBackendSettings = mapped
    }

    /**
     * @param value Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
     */
    @JvmName("rmbtfpbckgrfbuwx")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol used for the probe.
     */
    @JvmName("dsxpkrckxpqnjvue")
    public suspend fun protocol(`value`: Either<String, ApplicationGatewayProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol used for the probe.
     */
    @JvmName("hacjvgyarkiynijy")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol used for the probe.
     */
    @JvmName("qfsnwsgagvdjjgwl")
    public fun protocol(`value`: ApplicationGatewayProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("oiwiqwqikxkkloek")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
     */
    @JvmName("bbpkjswjvflpmads")
    public suspend fun unhealthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    internal fun build(): ApplicationGatewayProbeArgs = ApplicationGatewayProbeArgs(
        host = host,
        id = id,
        interval = interval,
        match = match,
        minServers = minServers,
        name = name,
        path = path,
        pickHostNameFromBackendHttpSettings = pickHostNameFromBackendHttpSettings,
        pickHostNameFromBackendSettings = pickHostNameFromBackendSettings,
        port = port,
        protocol = protocol,
        timeout = timeout,
        unhealthyThreshold = unhealthyThreshold,
    )
}
