@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayTrustedClientCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trusted client certificates of an application gateway.
 * @property data Certificate public data.
 * @property id Resource ID.
 * @property name Name of the trusted client certificate that is unique within an Application Gateway.
 */
public data class ApplicationGatewayTrustedClientCertificateArgs(
    public val `data`: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayTrustedClientCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayTrustedClientCertificateArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayTrustedClientCertificateArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayTrustedClientCertificateArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayTrustedClientCertificateArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Certificate public data.
     */
    @JvmName("cvcilxgqseafsbkx")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vsrqboeervwqadig")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the trusted client certificate that is unique within an Application Gateway.
     */
    @JvmName("rpjtyityixjxsrtl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Certificate public data.
     */
    @JvmName("eptijdvoekcotaun")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ncyrtocjqbmodpbs")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the trusted client certificate that is unique within an Application Gateway.
     */
    @JvmName("siqqtxqdrigohqkm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ApplicationGatewayTrustedClientCertificateArgs =
        ApplicationGatewayTrustedClientCertificateArgs(
            `data` = `data`,
            id = id,
            name = name,
        )
}
