@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayUrlConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Url configuration of the Actions set in Application Gateway.
 * @property modifiedPath Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
 * @property modifiedQueryString Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
 * @property reroute If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
 */
public data class ApplicationGatewayUrlConfigurationArgs(
    public val modifiedPath: Output<String>? = null,
    public val modifiedQueryString: Output<String>? = null,
    public val reroute: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayUrlConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayUrlConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayUrlConfigurationArgs.builder()
            .modifiedPath(modifiedPath?.applyValue({ args0 -> args0 }))
            .modifiedQueryString(modifiedQueryString?.applyValue({ args0 -> args0 }))
            .reroute(reroute?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayUrlConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayUrlConfigurationArgsBuilder internal constructor() {
    private var modifiedPath: Output<String>? = null

    private var modifiedQueryString: Output<String>? = null

    private var reroute: Output<Boolean>? = null

    /**
     * @param value Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
     */
    @JvmName("qtljurgyhfyapqni")
    public suspend fun modifiedPath(`value`: Output<String>) {
        this.modifiedPath = value
    }

    /**
     * @param value Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
     */
    @JvmName("kparnsvobfftptje")
    public suspend fun modifiedQueryString(`value`: Output<String>) {
        this.modifiedQueryString = value
    }

    /**
     * @param value If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
     */
    @JvmName("tdjwqixqfsarsgno")
    public suspend fun reroute(`value`: Output<Boolean>) {
        this.reroute = value
    }

    /**
     * @param value Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
     */
    @JvmName("eyrlqhnogyjnoibj")
    public suspend fun modifiedPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedPath = mapped
    }

    /**
     * @param value Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
     */
    @JvmName("vfjnyqbvgmfcwmbm")
    public suspend fun modifiedQueryString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedQueryString = mapped
    }

    /**
     * @param value If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
     */
    @JvmName("rjkdwgxgdfcclqfw")
    public suspend fun reroute(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reroute = mapped
    }

    internal fun build(): ApplicationGatewayUrlConfigurationArgs =
        ApplicationGatewayUrlConfigurationArgs(
            modifiedPath = modifiedPath,
            modifiedQueryString = modifiedQueryString,
            reroute = reroute,
        )
}
